/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProviderBase;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleTextDiffProvider
extends TwosideTextDiffProviderBase
implements TwosideTextDiffProvider {
    static final DiffUserDataKeysEx.DiffComputer DEFAULT_COMPUTER = (text1, text2, policy, innerChanges, indicator) -> {
        if (innerChanges) {
            return ComparisonManager.getInstance().compareLinesInner(text1, text2, policy, indicator);
        }
        return ComparisonManager.getInstance().compareLines(text1, text2, policy, indicator);
    };
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES_CHUNKS};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.DO_NOT_HIGHLIGHT};
    @NotNull
    private final DiffUserDataKeysEx.DiffComputer myDiffComputer;

    public SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        this(settings, rediff, DEFAULT_COMPUTER);
    }

    public SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull DiffUserDataKeysEx.DiffComputer diffComputer) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        if (diffComputer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffComputer", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        this(settings, rediff, diffComputer, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
    }

    private SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull DiffUserDataKeysEx.DiffComputer diffComputer, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        if (diffComputer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffComputer", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        if (ignorePolicies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignorePolicies", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        if (highlightPolicies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightPolicies", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "<init>"));
        }
        super(settings, rediff, ignorePolicies, highlightPolicies);
        this.myDiffComputer = diffComputer;
    }

    @Override
    @NotNull
    protected List<LineFragment> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull IgnorePolicy ignorePolicy, boolean innerFragments, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "doCompare"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "doCompare"));
        }
        if (ignorePolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignorePolicy", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "doCompare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "doCompare"));
        }
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        List<LineFragment> list = this.myDiffComputer.compute(text1, text2, policy, innerFragments, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider", "doCompare"));
        }
        return list;
    }

    public static class NoIgnore
    extends SimpleTextDiffProvider
    implements TwosideTextDiffProvider.NoIgnore {
        public NoIgnore(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore", "<init>"));
            }
            if (rediff == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore", "<init>"));
            }
            this(settings, rediff, DEFAULT_COMPUTER);
        }

        public NoIgnore(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull DiffUserDataKeysEx.DiffComputer diffComputer) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore", "<init>"));
            }
            if (rediff == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore", "<init>"));
            }
            if (diffComputer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffComputer", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore", "<init>"));
            }
            super(settings, rediff, diffComputer, IGNORE_POLICIES, (HighlightPolicy[])ArrayUtil.remove((Object[])HIGHLIGHT_POLICIES, (Object)((Object)HighlightPolicy.DO_NOT_HIGHLIGHT)));
        }

        @Override
        @NotNull
        public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore", "compare"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore", "compare"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore", "compare"));
            }
            List list = super.compare(text1, text2, indicator);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore", "compare"));
            }
            return list;
        }
    }
}

