/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.FineMergeLineFragment;
import com.intellij.diff.tools.util.text.FineMergeLineFragmentImpl;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleThreesideTextDiffProvider
extends TextDiffProviderBase {
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD};

    public SimpleThreesideTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "<init>"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "<init>"));
        }
        super(settings, rediff, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
    }

    @NotNull
    public List<FineMergeLineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "compare"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "compare"));
        }
        if (text3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text3", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "compare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "compare"));
        }
        IgnorePolicy ignorePolicy = this.getIgnorePolicy();
        HighlightPolicy highlightPolicy = this.getHighlightPolicy();
        ComparisonPolicy comparisonPolicy = ignorePolicy.getComparisonPolicy();
        List sequences = ContainerUtil.list((Object[])new CharSequence[]{text1, text2, text3});
        List lineOffsets = ContainerUtil.map((Collection)sequences, LineOffsets::create);
        indicator.checkCanceled();
        List lineFragments = ComparisonManager.getInstance().compareLines(text1, text2, text3, comparisonPolicy, indicator);
        indicator.checkCanceled();
        ArrayList<FineMergeLineFragment> result2 = new ArrayList<FineMergeLineFragment>(lineFragments.size());
        for (MergeLineFragment fragment : lineFragments) {
            MergeInnerDifferences innerDifferences;
            MergeConflictType conflictType = DiffUtil.getLineMergeType(fragment, sequences, lineOffsets, comparisonPolicy);
            if (highlightPolicy.isFineFragments()) {
                List<CharSequence> chunks = SimpleThreesideTextDiffProvider.getChunks(fragment, sequences, lineOffsets, conflictType);
                innerDifferences = DiffUtil.compareThreesideInner(chunks, comparisonPolicy, indicator);
            } else {
                innerDifferences = null;
            }
            result2.add(new FineMergeLineFragmentImpl(fragment, conflictType, innerDifferences));
        }
        ArrayList<FineMergeLineFragment> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "compare"));
        }
        return arrayList;
    }

    @NotNull
    private static List<CharSequence> getChunks(@NotNull MergeLineFragment fragment, @NotNull List<CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull MergeConflictType conflictType) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "getChunks"));
        }
        if (sequences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequences", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "getChunks"));
        }
        if (lineOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineOffsets", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "getChunks"));
        }
        if (conflictType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictType", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "getChunks"));
        }
        List list = ThreeSide.map(side -> {
            int endLine;
            if (conflictType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictType", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "lambda$getChunks$0"));
            }
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "lambda$getChunks$0"));
            }
            if (sequences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequences", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "lambda$getChunks$0"));
            }
            if (lineOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineOffsets", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "lambda$getChunks$0"));
            }
            if (!conflictType.isChange((ThreeSide)side)) {
                return null;
            }
            int startLine = fragment.getStartLine(side);
            if (startLine == (endLine = fragment.getEndLine(side))) {
                return null;
            }
            return DiffUtil.getLinesContent((CharSequence)side.select(sequences), (LineOffsets)side.select(lineOffsets), startLine, endLine);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider", "getChunks"));
        }
        return list;
    }
}

