/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProviderBase;
import com.intellij.diff.util.Side;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTextDiffProvider
extends TwosideTextDiffProviderBase
implements TwosideTextDiffProvider {
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES_CHUNKS, IgnorePolicy.FORMATTING};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.DO_NOT_HIGHLIGHT};
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContent myContent1;
    @NotNull
    private final DiffContent myContent2;
    @NotNull
    private final DiffIgnoredRangeProvider myProvider;

    @Nullable
    public static TwosideTextDiffProvider create(@Nullable Project project2, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff) {
        DiffContent content2;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "create"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "create"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "create"));
        }
        if (!Registry.is((String)"diff.smart.ignore.enabled")) {
            return null;
        }
        DiffContent content1 = (DiffContent)Side.LEFT.select(request.getContents());
        DiffIgnoredRangeProvider ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project2, content1, content2 = (DiffContent)Side.RIGHT.select(request.getContents()));
        if (ignoredRangeProvider == null) {
            return null;
        }
        return new SmartTextDiffProvider(project2, content1, content2, settings, rediff, ignoredRangeProvider);
    }

    @Nullable
    public static TwosideTextDiffProvider.NoIgnore createNoIgnore(@Nullable Project project2, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff) {
        DiffContent content2;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "createNoIgnore"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "createNoIgnore"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "createNoIgnore"));
        }
        if (!Registry.is((String)"diff.smart.ignore.enabled")) {
            return null;
        }
        DiffContent content1 = (DiffContent)Side.LEFT.select(request.getContents());
        DiffIgnoredRangeProvider ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project2, content1, content2 = (DiffContent)Side.RIGHT.select(request.getContents()));
        if (ignoredRangeProvider == null) {
            return null;
        }
        return new NoIgnore(project2, content1, content2, settings, rediff, ignoredRangeProvider);
    }

    private SmartTextDiffProvider(@Nullable Project project2, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (ignoredRangeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRangeProvider", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        this(project2, content1, content2, settings, rediff, ignoredRangeProvider, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
    }

    private SmartTextDiffProvider(@Nullable Project project2, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (ignoredRangeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRangeProvider", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (ignorePolicies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignorePolicies", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        if (highlightPolicies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightPolicies", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "<init>"));
        }
        super(settings, rediff, ignorePolicies, highlightPolicies);
        this.myProject = project2;
        this.myContent1 = content1;
        this.myContent2 = content2;
        this.myProvider = ignoredRangeProvider;
    }

    @Override
    @Nullable
    protected String getText(@NotNull IgnorePolicy option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "getText"));
        }
        if (option == IgnorePolicy.FORMATTING) {
            return this.myProvider.getDescription();
        }
        return null;
    }

    @Override
    @NotNull
    protected List<LineFragment> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull IgnorePolicy ignorePolicy, boolean innerFragments, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "doCompare"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "doCompare"));
        }
        if (ignorePolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignorePolicy", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "doCompare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "doCompare"));
        }
        if (ignorePolicy == IgnorePolicy.FORMATTING) {
            List<LineFragment> list = this.compareIgnoreFormatting(text1, text2, innerFragments, indicator);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "doCompare"));
            }
            return list;
        }
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        List<LineFragment> list = SimpleTextDiffProvider.DEFAULT_COMPUTER.compute(text1, text2, policy, innerFragments, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "doCompare"));
        }
        return list;
    }

    @NotNull
    private List<LineFragment> compareIgnoreFormatting(@NotNull CharSequence text1, @NotNull CharSequence text2, boolean innerFragments, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "compareIgnoreFormatting"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "compareIgnoreFormatting"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "compareIgnoreFormatting"));
        }
        List<TextRange> ranges1 = this.myProvider.getIgnoredRanges(this.myProject, text1, this.myContent1);
        List<TextRange> ranges2 = this.myProvider.getIgnoredRanges(this.myProject, text2, this.myContent2);
        ComparisonManagerImpl comparisonManager = ComparisonManagerImpl.getInstanceImpl();
        List<LineFragment> list = comparisonManager.compareLinesWithIgnoredRanges(text1, text2, ranges1, ranges2, innerFragments, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "compareIgnoreFormatting"));
        }
        return list;
    }

    @Nullable
    private static DiffIgnoredRangeProvider getIgnoredRangeProvider(@Nullable Project project2, @NotNull DiffContent content1, @NotNull DiffContent content2) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "getIgnoredRangeProvider"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/tools/util/text/SmartTextDiffProvider", "getIgnoredRangeProvider"));
        }
        for (DiffIgnoredRangeProvider provider : (DiffIgnoredRangeProvider[])DiffIgnoredRangeProvider.EP_NAME.getExtensions()) {
            if (!provider.accepts(project2, content1) || !provider.accepts(project2, content2)) continue;
            return provider;
        }
        return null;
    }

    public static class NoIgnore
    extends SmartTextDiffProvider
    implements TwosideTextDiffProvider.NoIgnore {
        private NoIgnore(@Nullable Project project2, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider) {
            if (content1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore", "<init>"));
            }
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore", "<init>"));
            }
            if (rediff == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore", "<init>"));
            }
            if (ignoredRangeProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredRangeProvider", "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore", "<init>"));
            }
            super(project2, content1, content2, settings, rediff, ignoredRangeProvider, IGNORE_POLICIES, (HighlightPolicy[])ArrayUtil.remove((Object[])HIGHLIGHT_POLICIES, (Object)((Object)HighlightPolicy.DO_NOT_HIGHLIGHT)));
        }

        @Override
        @NotNull
        public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore", "compare"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore", "compare"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore", "compare"));
            }
            List list = super.compare(text1, text2, indicator);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore", "compare"));
            }
            return list;
        }
    }
}

