/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.text.TextDiffProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffProviderBase
implements TextDiffProvider {
    private final TextDiffViewerUtil.IgnorePolicySettingAction myIgnorePolicySettingAction;
    private final TextDiffViewerUtil.HighlightPolicySettingAction myHighlightPolicySettingAction;

    public TextDiffProviderBase(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "<init>"));
        }
        if (rediff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "<init>"));
        }
        if (ignorePolicies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignorePolicies", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "<init>"));
        }
        if (highlightPolicies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightPolicies", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "<init>"));
        }
        this.myIgnorePolicySettingAction = new MyIgnorePolicySettingAction(settings, rediff, ignorePolicies);
        this.myHighlightPolicySettingAction = new MyHighlightPolicySettingAction(settings, rediff, highlightPolicies);
    }

    @Override
    @NotNull
    public List<AnAction> getToolbarActions() {
        List list = ContainerUtil.list((Object[])new AnAction[]{this.myIgnorePolicySettingAction, this.myHighlightPolicySettingAction});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "getToolbarActions"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<AnAction> getPopupActions() {
        List list = ContainerUtil.list((Object[])new AnAction[]{Separator.getInstance(), this.myIgnorePolicySettingAction.getActions(), Separator.getInstance(), this.myHighlightPolicySettingAction.getActions(), Separator.getInstance()});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "getPopupActions"));
        }
        return list;
    }

    @NotNull
    public IgnorePolicy getIgnorePolicy() {
        IgnorePolicy ignorePolicy = (IgnorePolicy)((Object)this.myIgnorePolicySettingAction.getValue());
        if (ignorePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "getIgnorePolicy"));
        }
        return ignorePolicy;
    }

    @NotNull
    public HighlightPolicy getHighlightPolicy() {
        HighlightPolicy highlightPolicy = (HighlightPolicy)((Object)this.myHighlightPolicySettingAction.getValue());
        if (highlightPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "getHighlightPolicy"));
        }
        return highlightPolicy;
    }

    public boolean isHighlightingDisabled() {
        return this.myHighlightPolicySettingAction.getValue() == HighlightPolicy.DO_NOT_HIGHLIGHT;
    }

    @Nullable
    protected String getText(@NotNull IgnorePolicy option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "getText"));
        }
        return null;
    }

    @Nullable
    protected String getText(@NotNull HighlightPolicy option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/text/TextDiffProviderBase", "getText"));
        }
        return null;
    }

    private class MyHighlightPolicySettingAction
    extends TextDiffViewerUtil.HighlightPolicySettingAction {
        public MyHighlightPolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, HighlightPolicy[] highlightPolicies) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyHighlightPolicySettingAction", "<init>"));
            }
            if (rediff == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyHighlightPolicySettingAction", "<init>"));
            }
            if (highlightPolicies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightPolicies", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyHighlightPolicySettingAction", "<init>"));
            }
            super(settings, rediff, highlightPolicies);
        }

        @Override
        @NotNull
        protected String getText(@NotNull HighlightPolicy option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyHighlightPolicySettingAction", "getText"));
            }
            String string = StringUtil.notNullize((String)TextDiffProviderBase.this.getText(option), (String)super.getText(option));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyHighlightPolicySettingAction", "getText"));
            }
            return string;
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerUtil.IgnorePolicySettingAction {
        public MyIgnorePolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, IgnorePolicy[] ignorePolicies) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyIgnorePolicySettingAction", "<init>"));
            }
            if (rediff == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rediff", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyIgnorePolicySettingAction", "<init>"));
            }
            if (ignorePolicies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignorePolicies", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyIgnorePolicySettingAction", "<init>"));
            }
            super(settings, rediff, ignorePolicies);
        }

        @Override
        @NotNull
        protected String getText(@NotNull IgnorePolicy option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyIgnorePolicySettingAction", "getText"));
            }
            String string = StringUtil.notNullize((String)TextDiffProviderBase.this.getText(option), (String)super.getText(option));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/text/TextDiffProviderBase$MyIgnorePolicySettingAction", "getText"));
            }
            return string;
        }
    }
}

