/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.AbstractTreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreePsiFragment;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.List;

public class TreeHashingUtils {
    protected static TreeHashResult hashCodeBlockForIndexing(AbstractTreeHasher treeHasher, FragmentsCollector callBack, List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher) {
        int statementsSize = statements.size();
        if (statementsSize > 0) {
            TreePsiFragment fragment = treeHasher.buildFragment(hasher, statements, 0, statementsSize - 1);
            fragment.setParent(upper);
            int cost = 0;
            int hash = 0;
            for (PsiElement psiElement : statements) {
                TreeHashResult res = treeHasher.hash(psiElement, null, hasher);
                hash = hash * 31 + res.getHash();
                cost += res.getCost();
            }
            TreeHashResult result2 = new TreeHashResult(hash, cost, treeHasher.buildFragment(hasher, statements, 0, statementsSize - 1));
            if (callBack != null && statementsSize > 1) {
                callBack.add(hash, cost, fragment);
            }
            return result2;
        }
        return new TreeHashResult(1, 0, treeHasher.buildFragment(hasher, statements, 0, statementsSize - 1));
    }

    static TreeHashResult computeElementHashForIndexing(AbstractTreeHasher base, FragmentsCollector callBack, PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        int size;
        List<PsiElement> children2 = hasher.getNodeChildren(root);
        TreePsiFragment fragment = base.buildFragment(hasher, root, base.getCost(root));
        if (upper != null) {
            fragment.setParent(upper);
        }
        if ((size = children2.size()) == 0 && !(root instanceof LeafElement)) {
            return new TreeHashResult(0, hasher.getNodeCost(root), fragment);
        }
        int discardCost = base.getDiscardCost(root);
        int c = hasher.getNodeCost(root);
        int h = hasher.getNodeHash(root);
        for (int i2 = 0; i2 < size; ++i2) {
            PsiElement child = children2.get(i2);
            TreeHashResult res = base.hash(child, fragment, hasher);
            int childCost = res.getCost();
            c += childCost;
            if (childCost <= discardCost && base.ignoreChildHash(child)) continue;
            h += res.getHash();
        }
        if (base.shouldAnonymize(root, hasher)) {
            h = 0;
        }
        if (callBack != null) {
            callBack.add(h, c, fragment);
        }
        return new TreeHashResult(h, c, fragment);
    }
}

