/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import javax.swing.Icon;

public class TerminateRemoteProcessDialog {
    public static GeneralSettings.ProcessCloseConfirmation show(Project project2, String sessionName, final boolean canDisconnect, boolean defaultDisconnect) {
        GeneralSettings.ProcessCloseConfirmation confirmation = GeneralSettings.getInstance().getProcessCloseConfirmation();
        if (confirmation != GeneralSettings.ProcessCloseConfirmation.ASK) {
            if (confirmation == GeneralSettings.ProcessCloseConfirmation.DISCONNECT && !canDisconnect) {
                confirmation = GeneralSettings.ProcessCloseConfirmation.TERMINATE;
            }
            return confirmation;
        }
        ArrayList<String> options = new ArrayList<String>(3);
        options.add(ExecutionBundle.message((String)"button.terminate", (Object[])new Object[0]));
        if (canDisconnect) {
            options.add(ExecutionBundle.message((String)"button.disconnect", (Object[])new Object[0]));
        }
        options.add(CommonBundle.getCancelButtonText());
        DialogWrapper.DoNotAskOption.Adapter doNotAskOption = new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                GeneralSettings.ProcessCloseConfirmation confirmation;
                if (isSelected && (confirmation = TerminateRemoteProcessDialog.getConfirmation(exitCode, canDisconnect)) != null) {
                    GeneralSettings.getInstance().setProcessCloseConfirmation(confirmation);
                }
            }
        };
        return TerminateRemoteProcessDialog.getConfirmation(Messages.showDialog((Project)project2, (String)ExecutionBundle.message((String)"terminate.process.confirmation.text", (Object[])new Object[]{sessionName}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{sessionName}), (String[])ArrayUtil.toStringArray(options), (int)(canDisconnect && defaultDisconnect ? 1 : 0), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption), canDisconnect);
    }

    private static GeneralSettings.ProcessCloseConfirmation getConfirmation(int button, boolean withDisconnect) {
        switch (button) {
            case 0: {
                return GeneralSettings.ProcessCloseConfirmation.TERMINATE;
            }
            case 1: {
                if (!withDisconnect) break;
                return GeneralSettings.ProcessCloseConfirmation.DISCONNECT;
            }
        }
        return null;
    }
}

