/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.BasicGutterContentProvider;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleGutterComponent;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.UseConsoleInputAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageConsoleBuilder {
    @Nullable
    private LanguageConsoleView consoleView;
    @Nullable
    private Condition<LanguageConsoleView> executionEnabled;
    @Nullable
    private PairFunction<VirtualFile, Project, PsiFile> psiFileFactory;
    @Nullable
    private BaseConsoleExecuteActionHandler executeActionHandler;
    @Nullable
    private String historyType;
    @Nullable
    private GutterContentProvider gutterContentProvider;
    private boolean oneLineInput;
    private String processInputStateKey;

    public LanguageConsoleBuilder(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/console/LanguageConsoleBuilder", "<init>"));
        }
        this.executionEnabled = Conditions.alwaysTrue();
        this.consoleView = consoleView;
    }

    public LanguageConsoleBuilder() {
        this.executionEnabled = Conditions.alwaysTrue();
    }

    public LanguageConsoleBuilder processHandler(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/console/LanguageConsoleBuilder", "processHandler"));
        }
        this.executionEnabled = console -> {
            if (processHandler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/console/LanguageConsoleBuilder", "lambda$processHandler$0"));
            }
            return !processHandler2.isProcessTerminated();
        };
        return this;
    }

    public LanguageConsoleBuilder executionEnabled(@NotNull Condition<LanguageConsoleView> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/execution/console/LanguageConsoleBuilder", "executionEnabled"));
        }
        this.executionEnabled = condition;
        return this;
    }

    public LanguageConsoleBuilder psiFileFactory(@NotNull PairFunction<VirtualFile, Project, PsiFile> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/execution/console/LanguageConsoleBuilder", "psiFileFactory"));
        }
        this.psiFileFactory = value;
        return this;
    }

    @NotNull
    public LanguageConsoleBuilder initActions(@NotNull BaseConsoleExecuteActionHandler executeActionHandler, @NotNull String historyType) {
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeActionHandler", "com/intellij/execution/console/LanguageConsoleBuilder", "initActions"));
        }
        if (historyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyType", "com/intellij/execution/console/LanguageConsoleBuilder", "initActions"));
        }
        if (this.consoleView == null) {
            this.executeActionHandler = executeActionHandler;
            this.historyType = historyType;
        } else {
            this.doInitAction(this.consoleView, executeActionHandler, historyType);
        }
        LanguageConsoleBuilder languageConsoleBuilder = this;
        if (languageConsoleBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleBuilder", "initActions"));
        }
        return languageConsoleBuilder;
    }

    private void doInitAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler, @NotNull String historyType) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/LanguageConsoleBuilder", "doInitAction"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeActionHandler", "com/intellij/execution/console/LanguageConsoleBuilder", "doInitAction"));
        }
        if (historyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyType", "com/intellij/execution/console/LanguageConsoleBuilder", "doInitAction"));
        }
        ConsoleExecuteAction action = new ConsoleExecuteAction(console, executeActionHandler, this.executionEnabled);
        action.registerCustomShortcutSet(action.getShortcutSet(), console.getConsoleEditor().getComponent());
        new ConsoleHistoryController(new MyConsoleRootType(historyType), null, console).install();
    }

    public static AnAction registerExecuteAction(@NotNull LanguageConsoleView console, final @NotNull Consumer<String> executeActionHandler, @NotNull String historyType, @Nullable String historyPersistenceId, @Nullable Condition<LanguageConsoleView> enabledCondition) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/LanguageConsoleBuilder", "registerExecuteAction"));
        }
        if (executeActionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executeActionHandler", "com/intellij/execution/console/LanguageConsoleBuilder", "registerExecuteAction"));
        }
        if (historyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "historyType", "com/intellij/execution/console/LanguageConsoleBuilder", "registerExecuteAction"));
        }
        ConsoleExecuteAction.ConsoleExecuteActionHandler handler2 = new ConsoleExecuteAction.ConsoleExecuteActionHandler(true){

            @Override
            void doExecute(@NotNull String text, @NotNull LanguageConsoleView consoleView) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/console/LanguageConsoleBuilder$1", "doExecute"));
                }
                if (consoleView == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/console/LanguageConsoleBuilder$1", "doExecute"));
                }
                executeActionHandler.consume((Object)text);
            }
        };
        ConsoleExecuteAction action = new ConsoleExecuteAction(console, handler2, enabledCondition);
        action.registerCustomShortcutSet(action.getShortcutSet(), console.getConsoleEditor().getComponent());
        new ConsoleHistoryController(new MyConsoleRootType(historyType), historyPersistenceId, console).install();
        return action;
    }

    public LanguageConsoleBuilder gutterContentProvider(@Nullable GutterContentProvider value) {
        this.gutterContentProvider = value;
        return this;
    }

    public LanguageConsoleBuilder oneLineInput() {
        this.oneLineInput(true);
        return this;
    }

    public LanguageConsoleBuilder oneLineInput(boolean value) {
        this.oneLineInput = value;
        return this;
    }

    @NotNull
    public LanguageConsoleBuilder processInputStateKey(@Nullable String value) {
        this.processInputStateKey = value;
        LanguageConsoleBuilder languageConsoleBuilder = this;
        if (languageConsoleBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleBuilder", "processInputStateKey"));
        }
        return languageConsoleBuilder;
    }

    @NotNull
    public LanguageConsoleView build(@NotNull Project project2, @NotNull Language language) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/LanguageConsoleBuilder", "build"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/execution/console/LanguageConsoleBuilder", "build"));
        }
        MyHelper helper = new MyHelper(project2, language.getDisplayName() + " Console", language, this.psiFileFactory);
        GutteredLanguageConsole consoleView = new GutteredLanguageConsole(helper, this.gutterContentProvider);
        if (this.oneLineInput) {
            consoleView.getConsoleEditor().setOneLineMode(true);
        }
        if (this.executeActionHandler != null) {
            assert (this.historyType != null);
            this.doInitAction(consoleView, this.executeActionHandler, this.historyType);
        }
        if (this.processInputStateKey != null) {
            assert (this.executeActionHandler != null);
            if (PropertiesComponent.getInstance().getBoolean(this.processInputStateKey)) {
                this.executeActionHandler.myUseProcessStdIn = true;
                DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)consoleView.getProject());
                daemonCodeAnalyzer.setHighlightingEnabled(consoleView.getFile(), false);
            }
            consoleView.addCustomConsoleAction((AnAction)new UseConsoleInputAction(this.processInputStateKey));
        }
        GutteredLanguageConsole gutteredLanguageConsole = consoleView;
        if (gutteredLanguageConsole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleBuilder", "build"));
        }
        return gutteredLanguageConsole;
    }

    private static class MyConsoleRootType
    extends ConsoleRootType {
        public MyConsoleRootType(String historyType) {
            super(historyType, null);
        }
    }

    private static final class GutteredLanguageConsole
    extends LanguageConsoleImpl {
        private final GutterContentProvider gutterContentProvider;

        public GutteredLanguageConsole(@NotNull MyHelper helper, @Nullable GutterContentProvider gutterContentProvider) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "<init>"));
            }
            super(helper);
            helper.console = this;
            this.gutterContentProvider = gutterContentProvider == null ? new BasicGutterContentProvider() : gutterContentProvider;
        }

        @Override
        boolean isHistoryViewerForceAdditionalColumnsUsage() {
            return false;
        }

        @Override
        int getMinHistoryLineCount() {
            return 1;
        }

        void setupEditor(@NotNull EditorEx editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole", "setupEditor"));
            }
            if (editor == this.getConsoleEditor()) {
                return;
            }
            final ConsoleGutterComponent lineStartGutter = new ConsoleGutterComponent(editor, this.gutterContentProvider, true);
            final ConsoleGutterComponent lineEndGutter = new ConsoleGutterComponent(editor, this.gutterContentProvider, false);
            editor.getSoftWrapModel().forceAdditionalColumnsUsage();
            ((SoftWrapModelImpl)editor.getSoftWrapModel()).getApplianceManager().setWidthProvider(new SoftWrapApplianceManager.VisibleAreaWidthProvider(){

                @Override
                public int getVisibleAreaWidth() {
                    int guttersWidth = lineEndGutter.getPreferredWidth() + lineStartGutter.getPreferredWidth();
                    EditorEx editor = this.getHistoryViewer();
                    return editor.getScrollingModel().getVisibleArea().width - guttersWidth;
                }
            });
            editor.setHorizontalScrollbarVisible(true);
            JLayeredPane layeredPane = new JLayeredPane(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension editorSize = this.getEditorComponent().getPreferredSize();
                    return new Dimension(lineStartGutter.getPreferredSize().width + editorSize.width, editorSize.height);
                }

                @Override
                public Dimension getMinimumSize() {
                    Dimension editorSize = this.getEditorComponent().getMinimumSize();
                    return new Dimension(lineStartGutter.getPreferredSize().width + editorSize.width, editorSize.height);
                }

                @Override
                public void doLayout() {
                    EditorComponentImpl editor = this.getEditorComponent();
                    int w = this.getWidth();
                    int h = this.getHeight();
                    int lineStartGutterWidth = lineStartGutter.getPreferredSize().width;
                    lineStartGutter.setBounds(0, 0, lineStartGutterWidth + gutterContentProvider.getLineStartGutterOverlap(editor.getEditor()), h);
                    editor.setBounds(lineStartGutterWidth, 0, w - lineStartGutterWidth, h);
                    int lineEndGutterWidth = lineEndGutter.getPreferredSize().width;
                    lineEndGutter.setBounds(lineStartGutterWidth + (w - lineEndGutterWidth - editor.getEditor().getScrollPane().getVerticalScrollBar().getWidth()), 0, lineEndGutterWidth, h);
                }

                @NotNull
                private EditorComponentImpl getEditorComponent() {
                    for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
                        Component component = this.getComponent(i2);
                        if (!(component instanceof EditorComponentImpl)) continue;
                        EditorComponentImpl editorComponentImpl = (EditorComponentImpl)component;
                        if (editorComponentImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$2", "getEditorComponent"));
                        }
                        return editorComponentImpl;
                    }
                    throw new IllegalStateException();
                }
            };
            layeredPane.add((Component)lineStartGutter, JLayeredPane.PALETTE_LAYER);
            JScrollPane scrollPane = editor.getScrollPane();
            layeredPane.add(scrollPane.getViewport().getView(), JLayeredPane.DEFAULT_LAYER);
            layeredPane.add((Component)lineEndGutter, JLayeredPane.PALETTE_LAYER);
            scrollPane.setViewportView(layeredPane);
            GutterUpdateScheduler gutterUpdateScheduler = new GutterUpdateScheduler(lineStartGutter, lineEndGutter);
            this.getProject().getMessageBus().connect((Disposable)this).subscribe(DocumentBulkUpdateListener.TOPIC, (Object)gutterUpdateScheduler);
            editor.getDocument().addDocumentListener((DocumentListener)gutterUpdateScheduler);
        }

        @Override
        protected void doAddPromptToHistory() {
            this.gutterContentProvider.beforeEvaluate(this.getHistoryViewer());
        }

        @Override
        public void dispose() {
            PsiFile file2 = this.getFile();
            DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).setHighlightingEnabled(file2, true);
            super.dispose();
        }

        @Override
        public void scrollToEnd() {
            this.getComponent().validate();
            super.scrollToEnd();
        }

        private final class GutterUpdateScheduler
        extends DocumentAdapter
        implements DocumentBulkUpdateListener {
            private final ConsoleGutterComponent lineStartGutter;
            private final ConsoleGutterComponent lineEndGutter;
            private Task gutterSizeUpdater;
            private RangeHighlighter lineSeparatorPainter;
            private final CustomHighlighterRenderer renderer;

            public GutterUpdateScheduler(@NotNull ConsoleGutterComponent lineStartGutter, ConsoleGutterComponent lineEndGutter) {
                if (lineStartGutter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineStartGutter", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler", "<init>"));
                }
                if (lineEndGutter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineEndGutter", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler", "<init>"));
                }
                this.renderer = new CustomHighlighterRenderer(){

                    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
                        int endLine;
                        if (editor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler$1", "paint"));
                        }
                        if (highlighter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler$1", "paint"));
                        }
                        if (g == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler$1", "paint"));
                        }
                        Rectangle clip = g.getClipBounds();
                        int lineHeight = editor.getLineHeight();
                        int startLine = clip.y / lineHeight;
                        if (startLine >= (endLine = Math.min((clip.y + clip.height) / lineHeight + 1, ((EditorImpl)editor).getVisibleLineCount()))) {
                            return;
                        }
                        int actualStartLine = startLine == 0 ? 0 : startLine - 1;
                        int y = (actualStartLine + 1) * lineHeight;
                        g.setColor(editor.getColorsScheme().getColor(EditorColors.INDENT_GUIDE_COLOR));
                        for (int visualLine = actualStartLine; visualLine < endLine; ++visualLine) {
                            if (GutteredLanguageConsole.this.gutterContentProvider.isShowSeparatorLine(editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0)).line, editor)) {
                                g.drawLine(clip.x, y, clip.x + clip.width, y);
                            }
                            y += lineHeight;
                        }
                    }
                };
                this.lineStartGutter = lineStartGutter;
                this.lineEndGutter = lineEndGutter;
                GutteredLanguageConsole.this.getHistoryViewer().getMarkupModel().addMarkupModelListener(GutteredLanguageConsole.this, new MarkupModelListener.Adapter(){

                    @Override
                    public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                        if (highlighter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler$2", "beforeRemoved"));
                        }
                        if (GutterUpdateScheduler.this.lineSeparatorPainter == highlighter) {
                            GutterUpdateScheduler.this.lineSeparatorPainter = null;
                        }
                    }
                });
            }

            private void addLineSeparatorPainterIfNeed() {
                if (this.lineSeparatorPainter != null) {
                    return;
                }
                RangeHighlighter highlighter = GutteredLanguageConsole.this.getHistoryViewer().getMarkupModel().addRangeHighlighter(0, this.getDocument().getTextLength(), 3000, null, HighlighterTargetArea.EXACT_RANGE);
                highlighter.setGreedyToRight(true);
                highlighter.setCustomRenderer(this.renderer);
                this.lineSeparatorPainter = highlighter;
            }

            private DocumentEx getDocument() {
                return GutteredLanguageConsole.this.getHistoryViewer().getDocument();
            }

            public void documentChanged(DocumentEvent event) {
                DocumentEx document = this.getDocument();
                if (document.isInBulkUpdate()) {
                    return;
                }
                if (document.getTextLength() > 0) {
                    this.addLineSeparatorPainterIfNeed();
                    int startDocLine = document.getLineNumber(event.getOffset());
                    int endDocLine = document.getLineNumber(event.getOffset() + event.getNewLength());
                    if (event.getOldLength() > event.getNewLength() || startDocLine != endDocLine || StringUtil.indexOf((CharSequence)event.getOldFragment(), (char)'\n') != -1) {
                        this.updateGutterSize(startDocLine, endDocLine);
                    }
                } else if (event.getOldLength() > 0) {
                    this.documentCleared();
                }
            }

            private void documentCleared() {
                this.gutterSizeUpdater = null;
                this.lineEndGutter.documentCleared();
                GutteredLanguageConsole.this.gutterContentProvider.documentCleared(GutteredLanguageConsole.this.getHistoryViewer());
            }

            @Override
            public void updateStarted(@NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler", "updateStarted"));
                }
            }

            @Override
            public void updateFinished(@NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler", "updateFinished"));
                }
                if (this.getDocument().getTextLength() == 0) {
                    this.documentCleared();
                } else {
                    this.addLineSeparatorPainterIfNeed();
                    this.updateGutterSize(0, Integer.MAX_VALUE);
                }
            }

            private void updateGutterSize(int start, int end) {
                if (this.gutterSizeUpdater != null) {
                    this.gutterSizeUpdater.start = Math.min(start, this.gutterSizeUpdater.start);
                    this.gutterSizeUpdater.end = Math.max(end, this.gutterSizeUpdater.end);
                    return;
                }
                this.gutterSizeUpdater = new Task(start, end);
                SwingUtilities.invokeLater(this.gutterSizeUpdater);
            }

            private final class Task
            implements Runnable {
                private int start;
                private int end;

                public Task(int start, int end) {
                    this.start = start;
                    this.end = end;
                }

                @Override
                public void run() {
                    if (!GutteredLanguageConsole.this.getHistoryViewer().isDisposed()) {
                        GutterUpdateScheduler.this.lineStartGutter.updateSize(this.start, this.end);
                        GutterUpdateScheduler.this.lineEndGutter.updateSize(this.start, this.end);
                    }
                    GutterUpdateScheduler.this.gutterSizeUpdater = null;
                }
            }
        }
    }

    private static class MyHelper
    extends LanguageConsoleImpl.Helper {
        private final PairFunction<VirtualFile, Project, PsiFile> psiFileFactory;
        GutteredLanguageConsole console;

        public MyHelper(@NotNull Project project2, @NotNull String title, @NotNull Language language, @Nullable PairFunction<VirtualFile, Project, PsiFile> psiFileFactory) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/LanguageConsoleBuilder$MyHelper", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/console/LanguageConsoleBuilder$MyHelper", "<init>"));
            }
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/execution/console/LanguageConsoleBuilder$MyHelper", "<init>"));
            }
            super(project2, (VirtualFile)new LightVirtualFile(title, language, (CharSequence)""));
            this.psiFileFactory = psiFileFactory;
        }

        @Override
        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.psiFileFactory == null ? super.getFile() : (PsiFile)this.psiFileFactory.fun((Object)this.virtualFile, (Object)this.project);
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleBuilder$MyHelper", "getFile"));
            }
            return psiFile;
        }

        @Override
        public void setupEditor(@NotNull EditorEx editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleBuilder$MyHelper", "setupEditor"));
            }
            super.setupEditor(editor);
            this.console.setupEditor(editor);
        }
    }
}

