/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.RuntimeDashboardContributor;
import com.intellij.execution.dashboard.TreeContent;
import com.intellij.execution.dashboard.tree.DashboardGrouper;
import com.intellij.execution.dashboard.tree.RuntimeDashboardTreeStructure;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimeDashboardContent
extends JPanel
implements TreeContent,
Disposable {
    public static final DataKey<RuntimeDashboardContent> KEY = DataKey.create((String)"runtimeDashboardContent");
    @NonNls
    private static final String PLACE_TOOLBAR = "RuntimeDashboardContent#Toolbar";
    @NonNls
    private static final String RUNTIME_DASHBOARD_TOOLBAR = "RuntimeDashboardToolbar";
    @NonNls
    private static final String RUNTIME_DASHBOARD_POPUP = "RuntimeDashboardPopup";
    private static final String MESSAGE_CARD = "message";
    private static final String CONTENT_CARD = "content";
    private final Tree myTree;
    private final CardLayout myDetailsPanelLayout;
    private final JPanel myDetailsPanel;
    private final JBPanelWithEmptyText myMessagePanel;
    private final DefaultTreeModel myTreeModel;
    private AbstractTreeBuilder myBuilder;
    private AbstractTreeNode<?> myLastSelection;
    private Set<Object> myCollapsedTreeNodeValues;
    private List<DashboardGrouper> myGroupers;
    @NotNull
    private final ContentManager myContentManager;
    @NotNull
    private final ContentManagerListener myContentManagerListener;
    @NotNull
    private final Project myProject;

    public RuntimeDashboardContent(@NotNull Project project2, @NotNull ContentManager contentManager, @NotNull List<DashboardGrouper> groupers) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/dashboard/RuntimeDashboardContent", "<init>"));
        }
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/execution/dashboard/RuntimeDashboardContent", "<init>"));
        }
        if (groupers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupers", "com/intellij/execution/dashboard/RuntimeDashboardContent", "<init>"));
        }
        super(new BorderLayout());
        this.myCollapsedTreeNodeValues = new HashSet<Object>();
        this.myProject = project2;
        this.myGroupers = groupers;
        this.myTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.setLineStyleAngled();
        this.add((Component)this.createToolbar(), "West");
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)1));
        this.myDetailsPanelLayout = new CardLayout();
        this.myDetailsPanel = new JPanel(this.myDetailsPanelLayout);
        this.myMessagePanel = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"runtime.dashboard.empty.selection.message", (Object[])new Object[0]));
        this.myDetailsPanel.add(MESSAGE_CARD, (Component)this.myMessagePanel);
        splitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.add((Component)splitter, "Center");
        this.myContentManager = contentManager;
        this.myContentManagerListener = new ContentManagerAdapter(){

            public void selectionChanged(final ContentManagerEvent event) {
                if (ContentManagerEvent.ContentOperation.add != event.getOperation()) {
                    return;
                }
                RuntimeDashboardContent.this.myBuilder.queueUpdate().doWhenDone(() -> RuntimeDashboardContent.this.myBuilder.accept(DashboardNode.class, (TreeVisitor)new TreeVisitor<DashboardNode>(){

                    public boolean visit(@NotNull DashboardNode node) {
                        if (node == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/execution/dashboard/RuntimeDashboardContent$1$1", "visit"));
                        }
                        if (node.getContent() == event.getContent()) {
                            RuntimeDashboardContent.this.myBuilder.select((Object)node);
                        }
                        return false;
                    }
                }));
                RuntimeDashboardContent.this.showContentPanel();
            }
        };
        this.myContentManager.addContentManagerListener(this.myContentManagerListener);
        this.myDetailsPanel.add(CONTENT_CARD, this.myContentManager.getComponent());
        this.setupBuilder();
        this.myTree.addTreeSelectionListener(e -> this.onSelectionChanged());
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object value = this.getNodeValue(event);
                if (value != null) {
                    RuntimeDashboardContent.this.myCollapsedTreeNodeValues.remove(value);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                Object value = this.getNodeValue(event);
                if (value != null) {
                    RuntimeDashboardContent.this.myCollapsedTreeNodeValues.add(value);
                }
            }

            private Object getNodeValue(TreeExpansionEvent event) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)event.getPath().getLastPathComponent(), DefaultMutableTreeNode.class);
                if (treeNode == null) {
                    return null;
                }
                AbstractTreeNode nodeDescriptor = (AbstractTreeNode)ObjectUtils.tryCast((Object)treeNode.getUserObject(), AbstractTreeNode.class);
                if (nodeDescriptor == null) {
                    return null;
                }
                return nodeDescriptor.getValue();
            }
        });
        DefaultActionGroup popupActionGroup = new DefaultActionGroup();
        popupActionGroup.add(ActionManager.getInstance().getAction(RUNTIME_DASHBOARD_TOOLBAR));
        popupActionGroup.add(ActionManager.getInstance().getAction(RUNTIME_DASHBOARD_POPUP));
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)popupActionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
        new TreeSpeedSearch(this.myTree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
    }

    private void onSelectionChanged() {
        Content content;
        Set nodes = this.myBuilder.getSelectedElements(AbstractTreeNode.class);
        if (nodes.size() != 1) {
            this.showMessagePanel(ExecutionBundle.message((String)"runtime.dashboard.empty.selection.message", (Object[])new Object[0]));
            this.myLastSelection = null;
            return;
        }
        AbstractTreeNode node = (AbstractTreeNode)nodes.iterator().next();
        if (Comparing.equal((Object)node, this.myLastSelection)) {
            return;
        }
        this.myLastSelection = node;
        if (node instanceof DashboardNode && (content = ((DashboardNode)node).getContent()) != null) {
            if (content != this.myContentManager.getSelectedContent()) {
                this.myContentManager.removeContentManagerListener(this.myContentManagerListener);
                this.myContentManager.setSelectedContent(content);
                this.myContentManager.addContentManagerListener(this.myContentManagerListener);
            }
            this.showContentPanel();
            return;
        }
        this.showMessagePanel("");
    }

    private void showMessagePanel(String text) {
        Content selectedContent = this.myContentManager.getSelectedContent();
        if (selectedContent != null) {
            this.myContentManager.removeContentManagerListener(this.myContentManagerListener);
            this.myContentManager.removeFromSelection(selectedContent);
            this.myContentManager.addContentManagerListener(this.myContentManagerListener);
        }
        this.myMessagePanel.getEmptyText().setText(text);
        this.myDetailsPanelLayout.show(this.myDetailsPanel, MESSAGE_CARD);
    }

    private void showContentPanel() {
        this.myDetailsPanelLayout.show(this.myDetailsPanel, CONTENT_CARD);
    }

    private void setupBuilder() {
        RuntimeDashboardTreeStructure structure = new RuntimeDashboardTreeStructure(this.myProject, this.myGroupers);
        this.myBuilder = new AbstractTreeBuilder((JTree)this.myTree, this.myTreeModel, structure, (Comparator)IndexComparator.INSTANCE){

            protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                return super.isAutoExpandNode(nodeDescriptor) || !RuntimeDashboardContent.this.myCollapsedTreeNodeValues.contains(((AbstractTreeNode)nodeDescriptor).getValue());
            }
        };
        this.myBuilder.initRootNode();
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        RunManagerEx.getInstanceEx(this.myProject).addRunManagerListener(new RunManagerListener(){

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/dashboard/RuntimeDashboardContent$4", "runConfigurationAdded"));
                }
                RuntimeDashboardContent.this.updateTreeIfNeeded(settings);
            }

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/dashboard/RuntimeDashboardContent$4", "runConfigurationRemoved"));
                }
                RuntimeDashboardContent.this.updateTreeIfNeeded(settings);
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/dashboard/RuntimeDashboardContent$4", "runConfigurationChanged"));
                }
                RuntimeDashboardContent.this.updateTreeIfNeeded(settings);
            }
        });
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/dashboard/RuntimeDashboardContent$5", "processStarted"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/dashboard/RuntimeDashboardContent$5", "processStarted"));
                }
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/dashboard/RuntimeDashboardContent$5", "processStarted"));
                }
                RuntimeDashboardContent.this.updateTreeIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/dashboard/RuntimeDashboardContent$5", "processTerminated"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/dashboard/RuntimeDashboardContent$5", "processTerminated"));
                }
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/dashboard/RuntimeDashboardContent$5", "processTerminated"));
                }
                RuntimeDashboardContent.this.updateTreeIfNeeded(env.getRunnerAndConfigurationSettings());
            }
        });
    }

    private void updateTreeIfNeeded(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null && RuntimeDashboardContributor.isShowInDashboard((ConfigurationType)settings.getType())) {
            this.updateTree(true);
        }
    }

    private JComponent createToolbar() {
        JPanel toolBarPanel = new JPanel(new GridLayout());
        DefaultActionGroup leftGroup = new DefaultActionGroup();
        leftGroup.add(ActionManager.getInstance().getAction(RUNTIME_DASHBOARD_TOOLBAR));
        ActionToolbar leftActionToolBar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)leftGroup, false);
        toolBarPanel.add(leftActionToolBar.getComponent());
        this.myTree.putClientProperty((Object)"DataProvider", (Object)new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (KEY.getName().equals(dataId)) {
                    return RuntimeDashboardContent.this;
                }
                return null;
            }
        });
        leftActionToolBar.setTargetComponent((JComponent)this.myTree);
        DefaultActionGroup rightGroup = new DefaultActionGroup();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.myTree);
        AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, (JComponent)this);
        rightGroup.add(expandAllAction);
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this);
        rightGroup.add(collapseAllAction);
        rightGroup.add((AnAction)new Separator());
        this.myGroupers.stream().filter(grouper -> !grouper.getRule().isAlwaysEnabled()).forEach(grouper -> rightGroup.add((AnAction)new GroupAction((DashboardGrouper)grouper)));
        ActionToolbar rightActionToolBar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)rightGroup, false);
        toolBarPanel.add(rightActionToolBar.getComponent());
        rightActionToolBar.setTargetComponent((JComponent)this.myTree);
        return toolBarPanel;
    }

    public void dispose() {
    }

    public void updateTree(boolean withStructure) {
        ApplicationManager.getApplication().invokeLater(() -> this.myBuilder.queueUpdate(withStructure).doWhenDone(() -> {
            final HashSet nodes = new HashSet();
            this.myBuilder.accept(AbstractTreeNode.class, (TreeVisitor)new TreeVisitor<AbstractTreeNode>(){

                public boolean visit(@NotNull AbstractTreeNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/execution/dashboard/RuntimeDashboardContent$7", "visit"));
                    }
                    nodes.add(node.getValue());
                    return false;
                }
            });
            this.myCollapsedTreeNodeValues.retainAll(nodes);
        }), this.myProject.getDisposed());
    }

    @NotNull
    public AbstractTreeBuilder getBuilder() {
        AbstractTreeBuilder abstractTreeBuilder = this.myBuilder;
        if (abstractTreeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RuntimeDashboardContent", "getBuilder"));
        }
        return abstractTreeBuilder;
    }

    private class GroupAction
    extends ToggleAction
    implements DumbAware {
        private DashboardGrouper myGrouper;

        public GroupAction(DashboardGrouper grouper) {
            this.myGrouper = grouper;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/dashboard/RuntimeDashboardContent$GroupAction", "update"));
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            ActionPresentation actionPresentation = this.myGrouper.getRule().getPresentation();
            presentation.setText(actionPresentation.getText());
            presentation.setDescription(actionPresentation.getDescription());
            presentation.setIcon(actionPresentation.getIcon());
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myGrouper.isEnabled();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myGrouper.setEnabled(state);
            RuntimeDashboardContent.this.updateTree(true);
        }
    }
}

