/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.dashboard.DashboardGroupingRule;
import com.intellij.execution.dashboard.PanelContentUI;
import com.intellij.execution.dashboard.RuntimeDashboardContent;
import com.intellij.execution.dashboard.RuntimeDashboardManager;
import com.intellij.execution.dashboard.tree.DashboardGrouper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RuntimeDashboard", storages={@Storage(value="$WORKSPACE_FILE$")})
public class RuntimeDashboardManagerImpl
implements RuntimeDashboardManager,
PersistentStateComponent<State> {
    @NotNull
    private final ContentManager myContentManager;
    private List<DashboardGrouper> myGroupers;

    public RuntimeDashboardManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/dashboard/RuntimeDashboardManagerImpl", "<init>"));
        }
        this.myGroupers = new ArrayList<DashboardGrouper>();
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        PanelContentUI contentUI = new PanelContentUI();
        this.myContentManager = contentFactory.createContentManager((ContentUI)contentUI, false, project2);
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.getToolWindowId(), false, ToolWindowAnchor.BOTTOM, (Disposable)project2, true);
        toolWindow.setIcon(this.getToolWindowIcon());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myGroupers = Arrays.stream(DashboardGroupingRule.EP_NAME.getExtensions()).sorted(DashboardGroupingRule.PRIORITY_COMPARATOR).map(DashboardGrouper::new).collect(Collectors.toList());
            RuntimeDashboardContent dashboardContent = new RuntimeDashboardContent(project2, this.myContentManager, this.myGroupers);
            Content content = contentFactory.createContent((JComponent)dashboardContent, null, false);
            Disposer.register((Disposable)content, (Disposable)dashboardContent);
            toolWindow.getContentManager().addContent(content);
        }
        if (!Registry.is((String)"ide.runtime.dashboard")) {
            toolWindow.setAvailable(false, null);
        }
    }

    public ContentManager getDashboardContentManager() {
        return this.myContentManager;
    }

    public String getToolWindowId() {
        return ToolWindowId.RUNTIME_DASHBOARD;
    }

    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowRun;
    }

    @Nullable
    public State getState() {
        State state = new State();
        state.ruleStates = this.myGroupers.stream().filter(grouper -> !grouper.getRule().isAlwaysEnabled()).map(grouper -> new RuleState(grouper.getRule().getName(), grouper.isEnabled())).collect(Collectors.toList());
        return state;
    }

    public void loadState(State state) {
        state.ruleStates.forEach(ruleState -> {
            for (DashboardGrouper grouper : this.myGroupers) {
                if (!grouper.getRule().getName().equals(ruleState.name) || grouper.getRule().isAlwaysEnabled()) continue;
                grouper.setEnabled(ruleState.enabled);
                return;
            }
        });
    }

    private static class RuleState {
        public String name;
        public boolean enabled = true;

        public RuleState() {
        }

        public RuleState(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }
    }

    static class State {
        public List<RuleState> ruleStates = new ArrayList<RuleState>();

        State() {
        }
    }
}

