/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RuntimeDashboardContent;
import com.intellij.execution.dashboard.TreeContent;
import com.intellij.execution.dashboard.actions.RunConfigurationTreeAction;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.content.Content;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RemoveConfigurationAction
extends RunConfigurationTreeAction {
    public RemoveConfigurationAction() {
        super(ExecutionBundle.message((String)"runtime.dashboard.remove.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"runtime.dashboard.remove.configuration.action.name", (Object[])new Object[0]), AllIcons.General.Remove);
    }

    protected boolean isEnabled4(DashboardRunConfigurationNode node) {
        Content content = node.getContent();
        return content == null || RunContentManagerImpl.isTerminated(content);
    }

    protected boolean isMultiSelectionAllowed() {
        return true;
    }

    protected void doActionPerformed(@NotNull RuntimeDashboardContent content, AnActionEvent e, List<DashboardRunConfigurationNode> nodes) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/dashboard/actions/RemoveConfigurationAction", "doActionPerformed"));
        }
        if (Messages.showYesNoDialog((Project)null, (String)ExecutionBundle.message((String)"runtime.dashboard.remove.configuration.dialog.message", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"runtime.dashboard.remove.configuration.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        super.doActionPerformed((TreeContent)content, e, nodes);
    }

    protected void doActionPerformed(DashboardRunConfigurationNode node) {
        RunManagerEx.getInstanceEx(node.getProject()).removeConfiguration(node.getConfigurationSettings());
    }
}

