/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.actions.RuntimeDashboardTreeAction;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class RuntimeDashboardTreeLeafAction<T extends DashboardNode>
extends RuntimeDashboardTreeAction<T> {
    protected RuntimeDashboardTreeLeafAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    protected final boolean isMultiSelectionAllowed() {
        return true;
    }

    @NotNull
    protected Set<?> collectNodes(@NotNull AbstractTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeBuilder", "com/intellij/execution/dashboard/actions/RuntimeDashboardTreeLeafAction", "collectNodes"));
        }
        Set selectedElement = treeBuilder.getSelectedElements();
        ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
        for (Object o : selectedElement) {
            if (!(o instanceof AbstractTreeNode)) {
                Set set2 = Collections.emptySet();
                if (set2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/actions/RuntimeDashboardTreeLeafAction", "collectNodes"));
                }
                return set2;
            }
            nodes.add((AbstractTreeNode)o);
        }
        Set<AbstractTreeNode> set3 = RuntimeDashboardTreeLeafAction.getLeaves(nodes);
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/actions/RuntimeDashboardTreeLeafAction", "collectNodes"));
        }
        return set3;
    }

    private static Set<AbstractTreeNode> getLeaves(Collection<? extends AbstractTreeNode> nodes) {
        HashSet<AbstractTreeNode> result2 = new HashSet<AbstractTreeNode>();
        for (AbstractTreeNode abstractTreeNode : nodes) {
            Collection children2 = abstractTreeNode.getChildren();
            if (children2.isEmpty()) {
                if (abstractTreeNode instanceof GroupingNode) continue;
                result2.add(abstractTreeNode);
                continue;
            }
            result2.addAll(RuntimeDashboardTreeLeafAction.getLeaves(children2));
        }
        return result2;
    }
}

