/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.DashboardGroup;
import com.intellij.execution.dashboard.DashboardGroupingRule;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.tree.DashboardGroupImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FolderDashboardGroupingRule
implements DashboardGroupingRule {
    @NonNls
    private static final String NAME = "FolderDashboardGroupingRule";

    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/tree/FolderDashboardGroupingRule", "getName"));
        }
        return NAME;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        ActionPresentationData actionPresentationData = new ActionPresentationData(ExecutionBundle.message((String)"runtime.dashboard.group.by.folder.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"runtime.dashboard.group.by.folder.action.name", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        if (actionPresentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/tree/FolderDashboardGroupingRule", "getPresentation"));
        }
        return actionPresentationData;
    }

    public int getPriority() {
        return 400;
    }

    public boolean isAlwaysEnabled() {
        return true;
    }

    public boolean shouldGroupSingleNodes() {
        return true;
    }

    @Nullable
    public DashboardGroup getGroup(AbstractTreeNode<?> node) {
        RunnerAndConfigurationSettings configurationSettings;
        String folderName;
        if (node instanceof DashboardRunConfigurationNode && (folderName = (configurationSettings = ((DashboardRunConfigurationNode)node).getConfigurationSettings()).getFolderName()) != null) {
            return new DashboardGroupImpl<String>(folderName, folderName, AllIcons.Nodes.Folder);
        }
        return null;
    }
}

