/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public interface Printer {
    public void print(String var1, ConsoleViewContentType var2);

    public void onNewAvailable(@NotNull Printable var1);

    public void printHyperlink(String var1, HyperlinkInfo var2);

    public void mark();

    default public void printWithAnsiColoring(@NotNull String text, final @NotNull Key processOutputType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/Printer", "printWithAnsiColoring"));
        }
        if (processOutputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutputType", "com/intellij/execution/testframework/Printer", "printWithAnsiColoring"));
        }
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        decoder.escapeText(text, ProcessOutputTypes.STDOUT, new AnsiEscapeDecoder.ColoredTextAcceptor(){

            public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/Printer$1", "coloredTextAvailable"));
                }
                if (attributes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/execution/testframework/Printer$1", "coloredTextAvailable"));
                }
                ConsoleViewContentType contentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
                if (contentType == null || contentType == ConsoleViewContentType.NORMAL_OUTPUT) {
                    contentType = ConsoleViewContentType.getConsoleViewType((Key)processOutputType);
                }
                Printer.this.print(text, contentType);
            }
        });
    }

    default public void printWithAnsiColoring(@NotNull String text, final @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/Printer", "printWithAnsiColoring"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/testframework/Printer", "printWithAnsiColoring"));
        }
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        decoder.escapeText(text, ProcessOutputTypes.STDOUT, new AnsiEscapeDecoder.ColoredTextAcceptor(){

            public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/Printer$2", "coloredTextAvailable"));
                }
                if (attributes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/execution/testframework/Printer$2", "coloredTextAvailable"));
                }
                ConsoleViewContentType viewContentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
                if (viewContentType == null) {
                    viewContentType = contentType;
                }
                Printer.this.print(text, viewContentType);
            }
        });
    }
}

