/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFindUsagesHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findUsages.JavaFindUsagesHelper");

    @NotNull
    public static Set<String> getElementNames(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getElementNames"));
        }
        if (element instanceof PsiDirectory) {
            PsiPackage aPackage = (PsiPackage)ReadAction.compute(() -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$getElementNames$0"));
                }
                return JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
            });
            Set<Object> set2 = aPackage == null ? Collections.emptySet() : JavaFindUsagesHelper.getElementNames((PsiElement)aPackage);
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getElementNames"));
            }
            return set2;
        }
        HashSet<String> result2 = new HashSet<String>();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$getElementNames$1"));
            }
            if (element instanceof PsiPackage) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)((PsiPackage)element).getQualifiedName());
            } else if (element instanceof PsiClass) {
                String qname = ((PsiClass)element).getQualifiedName();
                if (qname != null) {
                    result2.add(qname);
                    PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)element);
                    if (topLevelClass != null) {
                        String topName = topLevelClass.getQualifiedName();
                        assert (topName != null) : "topLevelClass : " + topLevelClass + "; element: " + element + " (" + qname + ") top level file: " + InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element);
                        if (qname.length() > topName.length()) {
                            result2.add(topName + qname.substring(topName.length()).replace('.', '$'));
                        }
                    }
                }
            } else if (element instanceof PsiMethod) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)((PsiMethod)element).getName());
            } else if (element instanceof PsiVariable) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)((PsiVariable)element).getName());
            } else if (element instanceof PsiMetaOwner) {
                PsiMetaData metaData = ((PsiMetaOwner)element).getMetaData();
                if (metaData != null) {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)metaData.getName());
                }
            } else if (element instanceof PsiNamedElement) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)((PsiNamedElement)element).getName());
            } else if (element instanceof XmlAttributeValue) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)((XmlAttributeValue)element).getValue());
            } else {
                LOG.error("Unknown element type: " + element);
            }
        });
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getElementNames"));
        }
        return hashSet;
    }

    public static boolean processElementUsages(@NotNull PsiElement element, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor2) {
        Collection stringsToSearch;
        boolean success;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processElementUsages"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processElementUsages"));
        }
        if (options instanceof JavaVariableFindUsagesOptions) {
            JavaVariableFindUsagesOptions varOptions = (JavaVariableFindUsagesOptions)options;
            if ((varOptions.isReadAccess || varOptions.isWriteAccess) && (varOptions.isReadAccess && varOptions.isWriteAccess ? !JavaFindUsagesHelper.addElementUsages(element, options, processor2) : !JavaFindUsagesHelper.addElementUsages(element, varOptions, (Processor<UsageInfo>)((Processor)info -> {
                boolean isWrite;
                if (processor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$2"));
                }
                PsiElement element1 = info.getElement();
                boolean bl = isWrite = element1 instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element1));
                return isWrite != varOptions.isWriteAccess || processor2.process(info);
            })))) {
                return false;
            }
        } else if (options.isUsages && !JavaFindUsagesHelper.addElementUsages(element, options, processor2)) {
            return false;
        }
        if (!(success = ((Boolean)ReadAction.compute(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$3"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$3"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$3"));
            }
            if (ThrowSearchUtil.isSearchable(element) && options instanceof JavaThrowFindUsagesOptions && options.isUsages) {
                ThrowSearchUtil.Root[] roots;
                ThrowSearchUtil.Root root = ((JavaThrowFindUsagesOptions)options).getRoot();
                if (root == null && (roots = ThrowSearchUtil.getSearchRoots(element)) != null && roots.length > 0) {
                    root = roots[0];
                }
                if (root != null) {
                    return ThrowSearchUtil.addThrowUsages(processor2, root, options);
                }
            }
            return true;
        })).booleanValue())) {
            return false;
        }
        if (options instanceof JavaPackageFindUsagesOptions && ((JavaPackageFindUsagesOptions)options).isClassesUsages && !JavaFindUsagesHelper.addClassesUsages((PsiPackage)element, (JavaPackageFindUsagesOptions)options, processor2)) {
            return false;
        }
        if (options instanceof JavaClassFindUsagesOptions) {
            JavaClassFindUsagesOptions classOptions = (JavaClassFindUsagesOptions)options;
            PsiClass psiClass = (PsiClass)element;
            PsiManager manager = (PsiManager)ReadAction.compute(() -> ((PsiClass)psiClass).getManager());
            if (classOptions.isMethodsUsages && !JavaFindUsagesHelper.addMethodsUsages(psiClass, manager, classOptions, processor2)) {
                return false;
            }
            if (classOptions.isFieldsUsages && !JavaFindUsagesHelper.addFieldsUsages(psiClass, manager, classOptions, processor2)) {
                return false;
            }
            if (((Boolean)ReadAction.compute(() -> psiClass.isInterface())).booleanValue()) {
                if (classOptions.isDerivedInterfaces ? (classOptions.isImplementingClasses ? !JavaFindUsagesHelper.addInheritors(psiClass, classOptions, processor2) : !JavaFindUsagesHelper.addDerivedInterfaces(psiClass, classOptions, processor2)) : classOptions.isImplementingClasses && !JavaFindUsagesHelper.addImplementingClasses(psiClass, classOptions, processor2)) {
                    return false;
                }
                if (classOptions.isImplementingClasses) {
                    FunctionalExpressionSearch.search((PsiClass)psiClass, (SearchScope)classOptions.searchScope).forEach((Processor)new PsiElementProcessorAdapter(expression -> {
                        if (options == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$5"));
                        }
                        if (processor2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$5"));
                        }
                        return JavaFindUsagesHelper.addResult(expression, options, processor2);
                    }));
                }
            } else if (classOptions.isDerivedClasses && !JavaFindUsagesHelper.addInheritors(psiClass, classOptions, processor2)) {
                return false;
            }
        }
        if (options instanceof JavaMethodFindUsagesOptions) {
            PsiMethod psiMethod = (PsiMethod)element;
            boolean isAbstract = (Boolean)ReadAction.compute(() -> psiMethod.hasModifierProperty("abstract"));
            JavaMethodFindUsagesOptions methodOptions = (JavaMethodFindUsagesOptions)options;
            if (isAbstract && methodOptions.isImplementingMethods || methodOptions.isOverridingMethods) {
                if (!JavaFindUsagesHelper.processOverridingMethods(psiMethod, processor2, methodOptions)) {
                    return false;
                }
                FunctionalExpressionSearch.search((PsiMethod)psiMethod, (SearchScope)methodOptions.searchScope).forEach((Processor)new PsiElementProcessorAdapter(expression -> {
                    if (options == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$7"));
                    }
                    if (processor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$7"));
                    }
                    return JavaFindUsagesHelper.addResult(expression, options, processor2);
                }));
            }
        }
        if (element instanceof PomTarget && !JavaFindUsagesHelper.addAliasingUsages((PomTarget)element, options, processor2)) {
            return false;
        }
        Boolean isSearchable = (Boolean)ReadAction.compute(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$8"));
            }
            return ThrowSearchUtil.isSearchable(element);
        });
        return isSearchable != false || !options.isSearchForTextOccurrences || !(options.searchScope instanceof GlobalSearchScope) || FindUsagesHelper.processUsagesInText(element, stringsToSearch = (Collection)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processElementUsages$9"));
            }
            return JavaFindUsagesHelper.getElementNames(element);
        })), (GlobalSearchScope)options.searchScope, processor2);
    }

    private static boolean addAliasingUsages(@NotNull PomTarget pomTarget, final @NotNull FindUsagesOptions options, final @NotNull Processor<UsageInfo> processor2) {
        if (pomTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pomTarget", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addAliasingUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addAliasingUsages"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addAliasingUsages"));
        }
        for (AliasingPsiTargetMapper aliasingPsiTargetMapper : (AliasingPsiTargetMapper[])Extensions.getExtensions((ExtensionPointName)AliasingPsiTargetMapper.EP_NAME)) {
            for (AliasingPsiTarget psiTarget : aliasingPsiTargetMapper.getTargets(pomTarget)) {
                boolean success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters((PsiElement)ReadAction.compute(() -> PomService.convertToPsi((PsiTarget)psiTarget)), options.searchScope, false, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHelper.addResult(reference, options, (Processor<UsageInfo>)processor2);
                    }
                });
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processOverridingMethods(@NotNull PsiMethod psiMethod, @NotNull Processor<UsageInfo> processor2, @NotNull JavaMethodFindUsagesOptions options) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processOverridingMethods"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processOverridingMethods"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "processOverridingMethods"));
        }
        return OverridingMethodsSearch.search((PsiMethod)psiMethod, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter(element -> {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processOverridingMethods$11"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$processOverridingMethods$11"));
            }
            return JavaFindUsagesHelper.addResult(element.getNavigationElement(), (FindUsagesOptions)options, processor2);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addClassesUsages(@NotNull PsiPackage aPackage, final @NotNull JavaPackageFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor2) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesUsages"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesUsages"));
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.pushState();
        }
        try {
            ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
            JavaFindUsagesHelper.addClassesInPackage(aPackage, options.isIncludeSubpackages, classes);
            for (PsiClass aClass : classes) {
                boolean success;
                if (progress != null) {
                    String name = (String)ReadAction.compute(() -> ((PsiClass)aClass).getName());
                    progress.setText(FindBundle.message("find.searching.for.references.to.class.progress", name));
                    progress.checkCanceled();
                }
                if (success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters((PsiElement)aClass, options.searchScope, false, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference psiReference) {
                        return JavaFindUsagesHelper.addResult(psiReference, options, (Processor<UsageInfo>)processor2);
                    }
                })) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
        return true;
    }

    private static void addClassesInPackage(@NotNull PsiPackage aPackage, boolean includeSubpackages, @NotNull List<PsiClass> array) {
        PsiDirectory[] dirs;
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesInPackage"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesInPackage"));
        }
        for (PsiDirectory dir : dirs = (PsiDirectory[])ReadAction.compute(() -> ((PsiPackage)aPackage).getDirectories())) {
            JavaFindUsagesHelper.addClassesInDirectory(dir, includeSubpackages, array);
        }
    }

    private static void addClassesInDirectory(@NotNull PsiDirectory dir, boolean includeSubdirs, @NotNull List<PsiClass> array) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesInDirectory"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addClassesInDirectory"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addClassesInDirectory$12"));
            }
            if (array == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addClassesInDirectory$12"));
            }
            Object[] classes = JavaDirectoryService.getInstance().getClasses(dir);
            ContainerUtil.addAll((Collection)array, (Object[])classes);
            if (includeSubdirs) {
                PsiDirectory[] dirs;
                for (PsiDirectory directory : dirs = dir.getSubdirectories()) {
                    JavaFindUsagesHelper.addClassesInDirectory(directory, true, array);
                }
            }
        });
    }

    private static boolean addMethodsUsages(@NotNull PsiClass aClass, @NotNull PsiManager manager, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<UsageInfo> processor2) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addMethodsUsages"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addMethodsUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addMethodsUsages"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addMethodsUsages"));
        }
        if (options.isIncludeInherited) {
            PsiMethod[] methods = (PsiMethod[])ReadAction.compute(() -> ((PsiClass)aClass).getAllMethods());
            for (int i2 = 0; i2 < methods.length; ++i2) {
                MethodReferencesSearch.SearchParameters parameters;
                boolean success;
                boolean equivalent;
                PsiMethod method2 = methods[i2];
                int finalI = i2;
                PsiClass methodClass = (PsiClass)ReadAction.compute(() -> {
                    MethodSignature methodSignature = method2.getSignature(PsiSubstitutor.EMPTY);
                    for (int j = 0; j < finalI; ++j) {
                        if (!methodSignature.equals(methods[j].getSignature(PsiSubstitutor.EMPTY))) continue;
                        return null;
                    }
                    return method2.getContainingClass();
                });
                if (methodClass == null || !((equivalent = ((Boolean)ReadAction.compute(() -> {
                    if (manager == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addMethodsUsages$14"));
                    }
                    if (aClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addMethodsUsages$14"));
                    }
                    return manager.areElementsEquivalent((PsiElement)methodClass, (PsiElement)aClass);
                })).booleanValue()) ? !JavaFindUsagesHelper.addElementUsages((PsiElement)method2, options, processor2) : !(success = MethodReferencesSearch.search((MethodReferencesSearch.SearchParameters)(parameters = new MethodReferencesSearch.SearchParameters(method2, options.searchScope, true, options.fastTrack))).forEach((Processor)new PsiReferenceProcessorAdapter(reference -> {
                    if (manager == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addMethodsUsages$15"));
                    }
                    if (aClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addMethodsUsages$15"));
                    }
                    if (options == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addMethodsUsages$15"));
                    }
                    if (processor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addMethodsUsages$15"));
                    }
                    JavaFindUsagesHelper.addResultFromReference(reference, methodClass, manager, aClass, options, processor2);
                    return true;
                }))))) continue;
                return false;
            }
        } else {
            PsiMethod[] methods;
            for (PsiMethod method3 : methods = (PsiMethod[])ReadAction.compute(() -> ((PsiClass)aClass).getMethods())) {
                if (JavaFindUsagesHelper.addElementUsages((PsiElement)method3, options, processor2)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean addFieldsUsages(final @NotNull PsiClass aClass, final @NotNull PsiManager manager, final @NotNull JavaClassFindUsagesOptions options, final @NotNull Processor<UsageInfo> processor2) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addFieldsUsages"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addFieldsUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addFieldsUsages"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addFieldsUsages"));
        }
        if (options.isIncludeInherited) {
            PsiField[] fields = (PsiField[])ReadAction.compute(() -> ((PsiClass)aClass).getAllFields());
            for (int i2 = 0; i2 < fields.length; ++i2) {
                boolean success;
                boolean equivalent;
                int finalI = i2;
                PsiField field = fields[i2];
                final PsiClass fieldClass = (PsiClass)ReadAction.compute(() -> {
                    for (int j = 0; j < finalI; ++j) {
                        if (!Comparing.strEqual((String)field.getName(), (String)fields[j].getName())) continue;
                        return null;
                    }
                    return field.getContainingClass();
                });
                if (fieldClass == null || !((equivalent = ((Boolean)ReadAction.compute(() -> {
                    if (manager == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addFieldsUsages$17"));
                    }
                    if (aClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addFieldsUsages$17"));
                    }
                    return manager.areElementsEquivalent((PsiElement)fieldClass, (PsiElement)aClass);
                })).booleanValue()) ? !JavaFindUsagesHelper.addElementUsages((PsiElement)fields[i2], options, processor2) : !(success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters((PsiElement)field, options.searchScope, false, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHelper.addResultFromReference(reference, fieldClass, manager, aClass, options, (Processor<UsageInfo>)processor2);
                    }
                })))) continue;
                return false;
            }
        } else {
            PsiField[] fields;
            for (PsiField field : fields = (PsiField[])ReadAction.compute(() -> ((PsiClass)aClass).getFields())) {
                if (JavaFindUsagesHelper.addElementUsages((PsiElement)field, options, processor2)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static PsiClass getFieldOrMethodAccessedClass(@NotNull PsiReferenceExpression ref, @NotNull PsiClass fieldOrMethodClass) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getFieldOrMethodAccessedClass"));
        }
        if (fieldOrMethodClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldOrMethodClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "getFieldOrMethodAccessedClass"));
        }
        PsiElement[] children2 = ref.getChildren();
        if (children2.length > 1 && children2[0] instanceof PsiExpression) {
            PsiElement refElement;
            PsiExpression expr = (PsiExpression)children2[0];
            PsiType type = expr.getType();
            if (type != null) {
                if (!(type instanceof PsiClassType)) {
                    return null;
                }
                return PsiUtil.resolveClassInType((PsiType)type);
            }
            if (expr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)expr).resolve()) instanceof PsiClass) {
                return (PsiClass)refElement;
            }
            return null;
        }
        PsiManager manager = ref.getManager();
        for (PsiReferenceExpression parent = ref; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiClass) || !manager.areElementsEquivalent((PsiElement)parent, (PsiElement)fieldOrMethodClass) && !((PsiClass)parent).isInheritor(fieldOrMethodClass, true)) continue;
            return (PsiClass)parent;
        }
        return null;
    }

    private static boolean addInheritors(@NotNull PsiClass aClass, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<UsageInfo> processor2) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addInheritors"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addInheritors"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addInheritors"));
        }
        return ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter(element -> {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addInheritors$18"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addInheritors$18"));
            }
            return JavaFindUsagesHelper.addResult(element, (FindUsagesOptions)options, processor2);
        }));
    }

    private static boolean addDerivedInterfaces(@NotNull PsiClass anInterface, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<UsageInfo> processor2) {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anInterface", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addDerivedInterfaces"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addDerivedInterfaces"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addDerivedInterfaces"));
        }
        return ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter(inheritor -> {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addDerivedInterfaces$19"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addDerivedInterfaces$19"));
            }
            return !inheritor.isInterface() || JavaFindUsagesHelper.addResult(inheritor, (FindUsagesOptions)options, processor2);
        }));
    }

    private static boolean addImplementingClasses(@NotNull PsiClass anInterface, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<UsageInfo> processor2) {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anInterface", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addImplementingClasses"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addImplementingClasses"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addImplementingClasses"));
        }
        return ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter(inheritor -> {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addImplementingClasses$20"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addImplementingClasses$20"));
            }
            return inheritor.isInterface() || JavaFindUsagesHelper.addResult(inheritor, (FindUsagesOptions)options, processor2);
        }));
    }

    private static boolean addResultFromReference(@NotNull PsiReference reference, @NotNull PsiClass methodClass, @NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor2) {
        PsiClass usedClass;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (methodClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResultFromReference"));
        }
        PsiElement refElement = reference.getElement();
        return !(refElement instanceof PsiReferenceExpression) || (usedClass = JavaFindUsagesHelper.getFieldOrMethodAccessedClass((PsiReferenceExpression)refElement, methodClass)) == null || !manager.areElementsEquivalent((PsiElement)usedClass, (PsiElement)aClass) && !usedClass.isInheritor(aClass, true) || JavaFindUsagesHelper.addResult(refElement, options, processor2);
    }

    private static boolean addElementUsages(@NotNull PsiElement element, final @NotNull FindUsagesOptions options, final @NotNull Processor<UsageInfo> processor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addElementUsages"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addElementUsages"));
        }
        SearchScope searchScope = options.searchScope;
        PsiClass[] parentClass = new PsiClass[1];
        if (element instanceof PsiMethod && ((Boolean)ReadAction.compute(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "lambda$addElementUsages$21"));
            }
            PsiMethod method2 = (PsiMethod)element;
            parentClass[0] = method2.getContainingClass();
            return method2.isConstructor();
        })).booleanValue()) {
            PsiMethod method2 = (PsiMethod)element;
            if (parentClass[0] != null) {
                boolean strictSignatureSearch = !(options instanceof JavaMethodFindUsagesOptions) || !((JavaMethodFindUsagesOptions)options).isIncludeOverloadUsages;
                return MethodReferencesSearch.search((MethodReferencesSearch.SearchParameters)new MethodReferencesSearch.SearchParameters(method2, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference ref) {
                        return JavaFindUsagesHelper.addResult(ref, options, (Processor<UsageInfo>)processor2);
                    }
                });
            }
            return true;
        }
        ReadActionProcessor<PsiReference> consumer = new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference ref) {
                return JavaFindUsagesHelper.addResult(ref, options, (Processor<UsageInfo>)processor2);
            }
        };
        if (element instanceof PsiMethod) {
            boolean strictSignatureSearch = !(options instanceof JavaMethodFindUsagesOptions) || !((JavaMethodFindUsagesOptions)options).isIncludeOverloadUsages;
            return MethodReferencesSearch.search((MethodReferencesSearch.SearchParameters)new MethodReferencesSearch.SearchParameters((PsiMethod)element, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor)consumer);
        }
        return ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, searchScope, false, options.fastTrack)).forEach((Processor)consumer);
    }

    private static boolean addResult(@NotNull PsiElement element, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        return !JavaFindUsagesHelper.filterUsage(element, options) || processor2.process((Object)new UsageInfo(element));
    }

    private static boolean addResult(@NotNull PsiReference ref, @NotNull FindUsagesOptions options, @NotNull Processor<UsageInfo> processor2) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/find/findUsages/JavaFindUsagesHelper", "addResult"));
        }
        if (JavaFindUsagesHelper.filterUsage(ref.getElement(), options)) {
            TextRange rangeInElement = ref.getRangeInElement();
            return processor2.process((Object)new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
        }
        return true;
    }

    private static boolean filterUsage(PsiElement usage, @NotNull FindUsagesOptions options) {
        PsiElement parent;
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/JavaFindUsagesHelper", "filterUsage"));
        }
        if (!(usage instanceof PsiJavaCodeReferenceElement)) {
            return true;
        }
        if (options instanceof JavaPackageFindUsagesOptions && !((JavaPackageFindUsagesOptions)options).isIncludeSubpackages && ((PsiReference)usage).resolve() instanceof PsiPackage && (parent = usage.getParent()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)parent).resolve() instanceof PsiPackage) {
            return false;
        }
        if (!(usage instanceof PsiReferenceExpression)) {
            if (options instanceof JavaFindUsagesOptions && ((JavaFindUsagesOptions)options).isSkipImportStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiImportStatement) {
                    return false;
                }
            }
            if (options instanceof JavaPackageFindUsagesOptions && ((JavaPackageFindUsagesOptions)options).isSkipPackageStatements) {
                parent = usage.getParent();
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiPackageStatement) {
                    return false;
                }
            }
        }
        return true;
    }
}

