/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkNode;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.framework.detection.impl.ui.DetectedFrameworksComponent;
import com.intellij.framework.detection.impl.ui.FrameworkDirectoryNode;
import com.intellij.framework.detection.impl.ui.FrameworkTypeNode;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.Consumer;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class DetectedFrameworksTree
extends CheckboxTree {
    private List<? extends DetectedFrameworkDescription> myDetectedFrameworks;
    private final FrameworkDetectionContext myContext;
    private DetectedFrameworksComponent.GroupByOption myGroupByOption;

    public DetectedFrameworksTree(FrameworkDetectionContext context, DetectedFrameworksComponent.GroupByOption groupByOption) {
        super(new DetectedFrameworksTreeRenderer(), new CheckedTreeNode(null), new CheckboxTreeBase.CheckPolicy(true, true, true, false));
        this.myContext = context;
        this.myGroupByOption = groupByOption;
        this.setShowsRootHandles(false);
        this.setRootVisible(false);
    }

    private void createNodesGroupedByDirectory(CheckedTreeNode root, List<? extends DetectedFrameworkDescription> frameworks) {
        HashMap<VirtualFile, FrameworkDirectoryNode> nodes = new HashMap<VirtualFile, FrameworkDirectoryNode>();
        ArrayList<DetectedFrameworkNode> externalNodes = new ArrayList<DetectedFrameworkNode>();
        for (DetectedFrameworkDescription detectedFrameworkDescription : frameworks) {
            VirtualFile parent = VfsUtil.getCommonAncestor((Collection)detectedFrameworkDescription.getRelatedFiles());
            if (parent != null && !parent.isDirectory()) {
                parent = parent.getParent();
            }
            DetectedFrameworkNode frameworkNode = new DetectedFrameworkNode(detectedFrameworkDescription, this.myContext);
            if (parent != null) {
                DetectedFrameworksTree.createDirectoryNodes(parent, nodes).add((MutableTreeNode)((Object)frameworkNode));
                continue;
            }
            externalNodes.add(frameworkNode);
        }
        ArrayList<FrameworkDirectoryNode> rootDirs = new ArrayList<FrameworkDirectoryNode>();
        for (FrameworkDirectoryNode directoryNode : nodes.values()) {
            if (directoryNode.getParent() != null) continue;
            rootDirs.add(directoryNode);
        }
        for (FrameworkDirectoryNode dir : rootDirs) {
            root.add((MutableTreeNode)((Object)DetectedFrameworksTree.collapseDirectoryNode(dir)));
        }
        for (DetectedFrameworkNode node : externalNodes) {
            root.add((MutableTreeNode)((Object)node));
        }
    }

    public void processUncheckedNodes(@NotNull Consumer<DetectedFrameworkTreeNodeBase> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/framework/detection/impl/ui/DetectedFrameworksTree", "processUncheckedNodes"));
        }
        TreeUtil.traverse((TreeNode)this.getRoot(), node -> {
            DetectedFrameworkTreeNodeBase frameworkNode;
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/framework/detection/impl/ui/DetectedFrameworksTree", "lambda$processUncheckedNodes$0"));
            }
            if (node instanceof DetectedFrameworkTreeNodeBase && !(frameworkNode = (DetectedFrameworkTreeNodeBase)((Object)((Object)node))).isChecked()) {
                consumer.consume((Object)frameworkNode);
            }
            return true;
        });
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        List<Object> checked = Arrays.asList(this.getCheckedNodes(DetectedFrameworkDescription.class, null));
        List<DetectedFrameworkDescription> disabled = FrameworkDetectionUtil.getDisabledDescriptions(checked, Collections.emptyList());
        for (DetectedFrameworkDescription description : disabled) {
            DefaultMutableTreeNode treeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.getRoot(), (Object)description);
            if (!(treeNode instanceof CheckedTreeNode)) continue;
            ((CheckedTreeNode)treeNode).setChecked(false);
        }
    }

    private static FrameworkDirectoryNode collapseDirectoryNode(FrameworkDirectoryNode node) {
        TreeNode child;
        if (node.getChildCount() == 1 && (child = node.getChildAt(0)) instanceof FrameworkDirectoryNode) {
            return DetectedFrameworksTree.collapseDirectoryNode((FrameworkDirectoryNode)((Object)child));
        }
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            FrameworkDirectoryNode collapsed;
            TreeNode child2 = node.getChildAt(i2);
            if (!(child2 instanceof FrameworkDirectoryNode) || (collapsed = DetectedFrameworksTree.collapseDirectoryNode((FrameworkDirectoryNode)((Object)child2))) == child2) continue;
            node.remove(i2);
            node.insert((MutableTreeNode)((Object)collapsed), i2);
        }
        return node;
    }

    @NotNull
    private static FrameworkDirectoryNode createDirectoryNodes(@NotNull VirtualFile dir, @NotNull Map<VirtualFile, FrameworkDirectoryNode> nodes) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/framework/detection/impl/ui/DetectedFrameworksTree", "createDirectoryNodes"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/framework/detection/impl/ui/DetectedFrameworksTree", "createDirectoryNodes"));
        }
        FrameworkDirectoryNode node = nodes.get(dir);
        if (node != null) {
            FrameworkDirectoryNode frameworkDirectoryNode = node;
            if (frameworkDirectoryNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/ui/DetectedFrameworksTree", "createDirectoryNodes"));
            }
            return frameworkDirectoryNode;
        }
        FrameworkDirectoryNode newNode = new FrameworkDirectoryNode(dir);
        nodes.put(dir, newNode);
        VirtualFile parent = dir.getParent();
        if (parent != null) {
            DetectedFrameworksTree.createDirectoryNodes(parent, nodes).add((MutableTreeNode)((Object)newNode));
        }
        FrameworkDirectoryNode frameworkDirectoryNode = newNode;
        if (frameworkDirectoryNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/ui/DetectedFrameworksTree", "createDirectoryNodes"));
        }
        return frameworkDirectoryNode;
    }

    private void createNodesGroupedByType(CheckedTreeNode root, List<? extends DetectedFrameworkDescription> frameworks) {
        HashMap<FrameworkType, FrameworkTypeNode> groupNodes = new HashMap<FrameworkType, FrameworkTypeNode>();
        for (DetectedFrameworkDescription detectedFrameworkDescription : frameworks) {
            FrameworkType type = detectedFrameworkDescription.getDetector().getFrameworkType();
            FrameworkTypeNode group = (FrameworkTypeNode)((Object)groupNodes.get(type));
            if (group == null) {
                group = new FrameworkTypeNode(type);
                groupNodes.put(type, group);
                root.add((MutableTreeNode)((Object)group));
            }
            group.add((MutableTreeNode)((Object)new DetectedFrameworkNode(detectedFrameworkDescription, this.myContext)));
        }
    }

    private CheckedTreeNode getRoot() {
        return (CheckedTreeNode)this.getModel().getRoot();
    }

    public void changeGroupBy(DetectedFrameworksComponent.GroupByOption option) {
        if (this.myGroupByOption.equals((Object)option)) {
            return;
        }
        this.myGroupByOption = option;
        if (this.myDetectedFrameworks != null) {
            this.rebuildTree(this.myDetectedFrameworks);
        }
    }

    public void rebuildTree(List<? extends DetectedFrameworkDescription> frameworks) {
        CheckedTreeNode root = this.getRoot();
        root.removeAllChildren();
        if (this.myGroupByOption == DetectedFrameworksComponent.GroupByOption.TYPE) {
            this.createNodesGroupedByType(root, frameworks);
        } else {
            this.createNodesGroupedByDirectory(root, frameworks);
        }
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged((TreeNode)root);
        TreeUtil.expandAll((JTree)((Object)this));
        this.myDetectedFrameworks = frameworks;
    }

    private static class DetectedFrameworksTreeRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private DetectedFrameworksTreeRenderer() {
            super(true, false);
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof DetectedFrameworkTreeNodeBase) {
                ((DetectedFrameworkTreeNodeBase)((Object)value)).renderNode(this.getTextRenderer());
            }
        }
    }
}

