/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InspectionDump
implements ApplicationStarter {
    public String getCommandName() {
        return "inspection-dump";
    }

    public void premain(String[] args) {
    }

    public void main(String[] args) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element inspections = document.createElement("Inspections");
            document.appendChild(inspections);
            List<InspectionToolWrapper> tools = InspectionToolRegistrar.getInstance().createTools();
            for (InspectionToolWrapper tool : tools) {
                Element inspection = document.createElement("Inspection");
                inspection.setAttribute("group", tool.getGroupDisplayName());
                inspection.setAttribute("name", tool.getDisplayName());
                inspection.setAttribute("level", tool.getDefaultLevel().getName());
                if (tool.getLanguage() != null) {
                    inspection.setAttribute("language", tool.getLanguage());
                }
                Element description = document.createElement("description");
                CDATASection descriptionSection = document.createCDATASection(InspectionDump.escapeCDATA(tool.loadDescription()));
                description.appendChild(descriptionSection);
                inspection.appendChild(description);
                inspections.appendChild(inspection);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            String path = args.length == 2 ? args[1] : PathManager.getHomePath() + File.separator + "AllInspections.xml";
            StreamResult console = new StreamResult(new File(path));
            transformer.transform(source, console);
            System.exit(0);
        }
        catch (ParserConfigurationException | TransformerException e) {
            e.printStackTrace();
        }
    }

    private static String escapeCDATA(String cData) {
        return cData.replaceAll("\\]", "&#x005D;").replaceAll("\\[", "&#x005B;");
    }
}

