/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.Content;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileEntry
extends Entry {
    private long myTimestamp;
    private boolean isReadOnly;
    private Content myContent;

    public FileEntry(int nameId, Content content, long timestamp, boolean isReadOnly) {
        super(nameId);
        this.myTimestamp = timestamp;
        this.isReadOnly = isReadOnly;
        this.myContent = content;
    }

    public FileEntry(String name, Content content, long timestamp, boolean isReadOnly) {
        this(FileEntry.toNameId(name), content, timestamp, isReadOnly);
    }

    public FileEntry(DataInput in, boolean dummy) throws IOException {
        super(in);
        this.myTimestamp = in.readLong();
        this.isReadOnly = in.readBoolean();
        this.myContent = new StoredContent(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.myTimestamp);
        out.writeBoolean(this.isReadOnly);
        this.myContent.write(out);
    }

    @Override
    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Content getContent() {
        return this.myContent;
    }

    @Override
    public boolean hasUnavailableContent(List<Entry> entriesWithUnavailableContent) {
        if (this.myContent.isAvailable()) {
            return false;
        }
        entriesWithUnavailableContent.add(this);
        return true;
    }

    @Override
    @NotNull
    public FileEntry copy() {
        FileEntry fileEntry = new FileEntry(this.getNameId(), this.myContent, this.myTimestamp, this.isReadOnly);
        if (fileEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/core/tree/FileEntry", "copy"));
        }
        return fileEntry;
    }

    @Override
    public void setContent(Content newContent, long newTimestamp) {
        this.myContent = newContent;
        this.myTimestamp = newTimestamp;
    }

    @Override
    public void collectDifferencesWith(Entry e, List<Difference> result2) {
        if (this.getPath().equals(e.getPath()) && this.myContent.equals(e.getContent()) && this.isReadOnly == e.isReadOnly()) {
            return;
        }
        result2.add(new Difference(true, this, e));
    }

    @Override
    protected void collectCreatedDifferences(List<Difference> result2) {
        result2.add(new Difference(true, null, this));
    }

    @Override
    protected void collectDeletedDifferences(List<Difference> result2) {
        result2.add(new Difference(true, this, null));
    }
}

