/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.patches.PatchCreator;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HistoryDialogModel {
    protected final Project myProject;
    protected LocalHistoryFacade myVcs;
    protected VirtualFile myFile;
    protected IdeaGateway myGateway;
    private String myFilter;
    private List<RevisionItem> myRevisionsCache;
    private Revision myCurrentRevisionCache;
    private int myRightRevisionIndex;
    private int myLeftRevisionIndex;
    private Entry[] myLeftEntryCache;
    private Entry[] myRightEntryCache;

    public HistoryDialogModel(Project p, IdeaGateway gw, LocalHistoryFacade vcs, VirtualFile f) {
        this.myProject = p;
        this.myVcs = vcs;
        this.myFile = f;
        this.myGateway = gw;
    }

    public String getTitle() {
        return FileUtil.toSystemDependentName((String)this.myFile.getPath());
    }

    public List<RevisionItem> getRevisions() {
        if (this.myRevisionsCache == null) {
            Pair<Revision, List<RevisionItem>> revs = this.calcRevisionsCache();
            this.myCurrentRevisionCache = (Revision)revs.first;
            this.myRevisionsCache = (List)revs.second;
        }
        return this.myRevisionsCache;
    }

    public Revision getCurrentRevision() {
        this.getRevisions();
        return this.myCurrentRevisionCache;
    }

    protected Pair<Revision, List<RevisionItem>> calcRevisionsCache() {
        return (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<Revision, List<RevisionItem>>>(){

            public Pair<Revision, List<RevisionItem>> compute() {
                HistoryDialogModel.this.myGateway.registerUnsavedDocuments(HistoryDialogModel.this.myVcs);
                String path = HistoryDialogModel.this.myFile.getPath();
                RootEntry root = HistoryDialogModel.this.myGateway.createTransientRootEntry();
                RevisionsCollector collector = new RevisionsCollector(HistoryDialogModel.this.myVcs, root, path, HistoryDialogModel.this.myProject.getLocationHash(), HistoryDialogModel.this.myFilter);
                List<Revision> all = collector.getResult();
                return Pair.create((Object)all.get(0), (Object)HistoryDialogModel.this.groupRevisions(all.subList(1, all.size())));
            }
        });
    }

    private List<RevisionItem> groupRevisions(List<Revision> revs) {
        LinkedList<RevisionItem> result2 = new LinkedList<RevisionItem>();
        for (Revision each : ContainerUtil.iterateBackward(revs)) {
            if (each.isLabel() && !result2.isEmpty()) {
                result2.getFirst().labels.addFirst(each);
                continue;
            }
            result2.addFirst(new RevisionItem(each));
        }
        return result2;
    }

    public void setFilter(@Nullable String filter) {
        this.myFilter = StringUtil.isEmptyOrSpaces((String)filter) ? null : filter;
        this.clearRevisions();
    }

    public void clearRevisions() {
        this.myRevisionsCache = null;
        this.resetEntriesCache();
    }

    private void resetEntriesCache() {
        this.myLeftEntryCache = null;
        this.myRightEntryCache = null;
    }

    public Revision getLeftRevision() {
        if (this.getRevisions().isEmpty()) {
            return this.getCurrentRevision();
        }
        return this.getRevisions().get((int)this.myLeftRevisionIndex).revision;
    }

    public Revision getRightRevision() {
        if (this.isCurrentRevisionSelected() || this.getRevisions().isEmpty()) {
            return this.getCurrentRevision();
        }
        return this.getRevisions().get((int)this.myRightRevisionIndex).revision;
    }

    protected Entry getLeftEntry() {
        if (this.myLeftEntryCache == null) {
            this.myLeftEntryCache = new Entry[]{this.getLeftRevision().findEntry()};
        }
        return this.myLeftEntryCache[0];
    }

    protected Entry getRightEntry() {
        if (this.myRightEntryCache == null) {
            this.myRightEntryCache = new Entry[]{this.getRightRevision().findEntry()};
        }
        return this.myRightEntryCache[0];
    }

    public void selectRevisions(int first, int second) {
        if (first == second) {
            this.myRightRevisionIndex = -1;
            this.myLeftRevisionIndex = first == -1 ? 0 : first;
        } else {
            this.myRightRevisionIndex = first;
            this.myLeftRevisionIndex = second;
        }
        this.resetEntriesCache();
    }

    public void resetSelection() {
        this.selectRevisions(0, 0);
    }

    public boolean isCurrentRevisionSelected() {
        return this.myRightRevisionIndex == -1;
    }

    public List<Change> getChanges() {
        List<Difference> dd = this.getDifferences();
        ArrayList<Change> result2 = new ArrayList<Change>();
        for (Difference d : dd) {
            result2.add(this.createChange(d));
        }
        return result2;
    }

    protected List<Difference> getDifferences() {
        return this.getLeftRevision().getDifferencesWith(this.getRightRevision());
    }

    protected Change createChange(Difference d) {
        return new Change(d.getLeftContentRevision(this.myGateway), d.getRightContentRevision(this.myGateway));
    }

    public void createPatch(String path, String basePath, boolean isReverse, @NotNull Charset charset) throws VcsException, IOException {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/history/integration/ui/models/HistoryDialogModel", "createPatch"));
        }
        PatchCreator.create(this.myProject, basePath, this.getChanges(), path, isReverse, null, charset);
    }

    public abstract Reverter createReverter();

    public boolean isRevertEnabled() {
        return this.isCorrectSelectionForRevertAndPatch();
    }

    public boolean isCreatePatchEnabled() {
        return this.isCorrectSelectionForRevertAndPatch();
    }

    private boolean isCorrectSelectionForRevertAndPatch() {
        return this.myLeftRevisionIndex != -1;
    }

    public boolean canPerformCreatePatch() {
        return !this.getLeftEntry().hasUnavailableContent() && !this.getRightEntry().hasUnavailableContent();
    }
}

