/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDesktopEntryAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.CreateDesktopEntryAction");
    private static final NullableLazyValue<String> ourScript = new AtomicNullableLazyValue<String>(){

        @Nullable
        protected String compute() {
            String binPath = PathManager.getBinPath();
            ApplicationNamesInfo names = ApplicationNamesInfo.getInstance();
            String execPath = binPath + '/' + names.getProductName() + ".sh";
            if (new File(execPath).canExecute()) {
                return execPath;
            }
            execPath = binPath + '/' + names.getProductName().toLowerCase(Locale.US) + ".sh";
            if (new File(execPath).canExecute()) {
                return execPath;
            }
            execPath = binPath + '/' + names.getScriptName() + ".sh";
            if (new File(execPath).canExecute()) {
                return execPath;
            }
            return null;
        }
    };

    public static boolean isAvailable() {
        return SystemInfo.isUnix && SystemInfo.hasXdgOpen();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/CreateDesktopEntryAction", "update"));
        }
        boolean enabled = CreateDesktopEntryAction.isAvailable();
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/CreateDesktopEntryAction", "actionPerformed"));
        }
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        Project project2 = event.getProject();
        CreateDesktopEntryDialog dialog2 = new CreateDesktopEntryDialog(project2);
        if (!dialog2.showAndGet()) {
            return;
        }
        final boolean globalEntry = dialog2.myGlobalEntryCheckBox.isSelected();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, ApplicationBundle.message((String)"desktop.entry.title", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/CreateDesktopEntryAction$2", "run"));
                }
                try {
                    indicator.setIndeterminate(true);
                    CreateDesktopEntryAction.createDesktopEntry(globalEntry);
                    String message = ApplicationBundle.message((String)"desktop.entry.success", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
                    Notifications.Bus.notify((Notification)new Notification("System Messages", "Desktop Entry Created", message, NotificationType.INFORMATION), (Project)this.getProject());
                }
                catch (Exception e) {
                    CreateDesktopEntryAction.reportFailure(e, this.getProject());
                }
            }
        });
    }

    public static void createDesktopEntry(boolean globalEntry) throws Exception {
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        File entry = null;
        try {
            CreateDesktopEntryAction.check();
            entry = CreateDesktopEntryAction.prepare();
            CreateDesktopEntryAction.install(entry, globalEntry);
        }
        finally {
            if (entry != null) {
                FileUtil.delete((File)entry);
            }
        }
    }

    public static void reportFailure(@NotNull Exception e, @Nullable Project project2) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CreateDesktopEntryAction", "reportFailure"));
        }
        LOG.warn((Throwable)e);
        String message = ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"Internal error");
        Notifications.Bus.notify((Notification)new Notification("System Messages", "Desktop Entry Creation Failed", message, NotificationType.ERROR), (Project)project2);
    }

    private static void check() throws ExecutionException, InterruptedException {
        int result2 = new GeneralCommandLine(new String[]{"which", "xdg-desktop-menu"}).createProcess().waitFor();
        if (result2 != 0) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.xdg.missing", (Object[])new Object[0]));
        }
    }

    private static File prepare() throws IOException {
        String binPath = PathManager.getBinPath();
        assert (new File(binPath).isDirectory()) : "Invalid bin path: '" + binPath + "'";
        String iconPath = AppUIUtil.findIcon(binPath);
        if (iconPath == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.icon.missing", (Object[])new Object[]{binPath}));
        }
        String execPath = (String)ourScript.getValue();
        if (execPath == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.script.missing", (Object[])new Object[]{binPath}));
        }
        String name = ApplicationNamesInfo.getInstance().getFullProductName();
        if (PlatformUtils.isIdeaCommunity()) {
            name = name + " Community Edition";
        }
        String wmClass = AppUIUtil.getFrameClass();
        Map vars = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"$NAME$", (Object)name), (Pair[])new Pair[]{Pair.pair((Object)"$SCRIPT$", (Object)execPath), Pair.pair((Object)"$ICON$", (Object)iconPath), Pair.pair((Object)"$WM_CLASS$", (Object)wmClass)});
        String content = ExecUtil.loadTemplate((ClassLoader)CreateDesktopEntryAction.class.getClassLoader(), (String)"entry.desktop", (Map)vars);
        File entryFile = new File(FileUtil.getTempDirectory(), wmClass + ".desktop");
        FileUtil.writeToFile((File)entryFile, (String)content);
        return entryFile;
    }

    private static void install(File entryFile, boolean globalEntry) throws IOException, ExecutionException {
        if (globalEntry) {
            File script = ExecUtil.createTempExecutableScript((String)"create_desktop_entry_", (String)".sh", (String)("#!/bin/sh\nxdg-desktop-menu install --mode system '" + entryFile.getAbsolutePath() + "' && xdg-desktop-menu forceupdate --mode system\n"));
            try {
                CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{script.getPath()}), ApplicationBundle.message((String)"desktop.entry.sudo.prompt", (Object[])new Object[0]));
            }
            finally {
                FileUtil.delete((File)script);
            }
        } else {
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "install", "--mode", "user", entryFile.getAbsolutePath()}), null);
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "forceupdate", "--mode", "user"}), null);
        }
    }

    private static void exec(GeneralCommandLine command, @Nullable String prompt) throws IOException, ExecutionException {
        command.setRedirectErrorStream(true);
        ProcessOutput result2 = prompt != null ? ExecUtil.sudoAndGetOutput((GeneralCommandLine)command, (String)prompt) : ExecUtil.execAndGetOutput((GeneralCommandLine)command);
        int exitCode = result2.getExitCode();
        if (exitCode != 0) {
            String message = "Command '" + (prompt != null ? "sudo " : "") + command.getCommandLineString() + "' returned " + exitCode;
            String output = result2.getStdout();
            if (!StringUtil.isEmptyOrSpaces((String)output)) {
                message = message + "\nOutput: " + output.trim();
            }
            throw new RuntimeException(message);
        }
    }

    @Nullable
    public static String getLauncherScript() {
        return (String)ourScript.getValue();
    }

    public static class CreateDesktopEntryDialog
    extends DialogWrapper {
        private JPanel myContentPane;
        private JLabel myLabel;
        private JCheckBox myGlobalEntryCheckBox;

        public CreateDesktopEntryDialog(Project project2) {
            super(project2);
            this.$$$setupUI$$$();
            this.init();
            this.setTitle(ApplicationBundle.message((String)"desktop.entry.title", (Object[])new Object[0]));
            this.myLabel.setText(this.myLabel.getText().replace("$APP_NAME$", ApplicationNamesInfo.getInstance().getProductName()));
        }

        protected JComponent createCenterPanel() {
            return this.myContentPane;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.myContentPane = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
            this.myGlobalEntryCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Create the entry for all users (requires superuser privileges)");
            jCheckBox.setMnemonic('A');
            jCheckBox.setDisplayedMnemonicIndex(21);
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myLabel = jLabel = new JLabel();
            jLabel.setText("<html>You can create a desktop entry for easier starting $APP_NAME$ from a system menu<br>and better desktop integration.<html>");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myContentPane;
        }
    }
}

