/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.annotations.Nullable;

public class SynchronizeCurrentFileAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        VirtualFile[] files = SynchronizeCurrentFileAction.getFiles(e);
        if (SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e) == null || files == null || files.length == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        e.getPresentation().setText(SynchronizeCurrentFileAction.getMessage(files));
    }

    private static String getMessage(VirtualFile[] files) {
        return files.length == 1 ? IdeBundle.message((String)"action.synchronize.file", (Object[])new Object[]{StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)files[0].getName(), (int)20))}) : IdeBundle.message((String)"action.synchronize.selected.files", (Object[])new Object[0]);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e);
        VirtualFile[] files = SynchronizeCurrentFileAction.getFiles(e);
        if (project2 == null || files == null || files.length == 0) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile file2 : files) {
                if (!(file2 instanceof NewVirtualFile)) continue;
                ((NewVirtualFile)file2).markDirtyRecursively();
            }
        });
        RefreshQueue.getInstance().refresh(true, true, () -> SynchronizeCurrentFileAction.postRefresh(project2, files), files);
    }

    private static void postRefresh(Project project2, VirtualFile[] files) {
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project2);
        for (VirtualFile f : files) {
            if (f.isDirectory()) {
                dirtyScopeManager.dirDirtyRecursively(f);
                continue;
            }
            dirtyScopeManager.fileDirty(f);
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
        if (statusBar != null) {
            statusBar.setInfo(IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[]{SynchronizeCurrentFileAction.getMessage(files)}));
        }
    }

    @Nullable
    private static VirtualFile[] getFiles(AnActionEvent e) {
        return (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
    }
}

