/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

import com.intellij.ide.highlighter.custom.AbstractCustomLexer;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.tokens.BraceTokenParser;
import com.intellij.ide.highlighter.custom.tokens.HexNumberParser;
import com.intellij.ide.highlighter.custom.tokens.IdentifierParser;
import com.intellij.ide.highlighter.custom.tokens.KeywordParser;
import com.intellij.ide.highlighter.custom.tokens.LineCommentParser;
import com.intellij.ide.highlighter.custom.tokens.MultilineCommentParser;
import com.intellij.ide.highlighter.custom.tokens.NumberParser;
import com.intellij.ide.highlighter.custom.tokens.PunctuationParser;
import com.intellij.ide.highlighter.custom.tokens.QuotedStringParser;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.ide.highlighter.custom.tokens.WhitespaceParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CustomHighlighterTokenType;
import java.util.ArrayList;
import java.util.List;

public final class CustomFileTypeLexer
extends AbstractCustomLexer {
    public CustomFileTypeLexer(SyntaxTable table, boolean forHighlighting) {
        super(CustomFileTypeLexer.buildTokenParsers(table, forHighlighting));
    }

    public CustomFileTypeLexer(SyntaxTable table) {
        this(table, false);
    }

    private static List<TokenParser> buildTokenParsers(SyntaxTable table, boolean forHighlighting) {
        LineCommentParser lineCommentParser = StringUtil.isEmpty((String)table.getLineComment()) ? null : new LineCommentParser(table.getLineComment(), table.lineCommentOnlyAtStart);
        MultilineCommentParser multilineCommentParser = MultilineCommentParser.create(table.getStartComment(), table.getEndComment());
        NumberParser numberParser = new NumberParser(table.getNumPostfixChars(), table.isIgnoreCase());
        HexNumberParser hexNumberParser = HexNumberParser.create(table.getHexPrefix());
        final KeywordParser parser = table.getKeywordParser();
        TokenParser keywordParser = new TokenParser(){

            @Override
            public boolean hasToken(int position) {
                return parser.hasToken(position, this.myBuffer, this.myTokenInfo);
            }
        };
        IdentifierParser identifierParser = new IdentifierParser(parser);
        QuotedStringParser quotedStringParser = new QuotedStringParser("\"", CustomHighlighterTokenType.STRING, table.isHasStringEscapes());
        QuotedStringParser quotedStringParser2 = new QuotedStringParser("'", forHighlighting ? CustomHighlighterTokenType.SINGLE_QUOTED_STRING : CustomHighlighterTokenType.STRING, table.isHasStringEscapes());
        ArrayList<TokenParser> tokenParsers = new ArrayList<TokenParser>();
        tokenParsers.add(new WhitespaceParser());
        if (lineCommentParser != null) {
            tokenParsers.add(lineCommentParser);
        }
        if (multilineCommentParser != null) {
            tokenParsers.add(multilineCommentParser);
        }
        tokenParsers.add(quotedStringParser);
        tokenParsers.add(quotedStringParser2);
        tokenParsers.add(new PunctuationParser());
        if (hexNumberParser != null) {
            tokenParsers.add(hexNumberParser);
        }
        tokenParsers.add(numberParser);
        tokenParsers.add(keywordParser);
        tokenParsers.add(identifierParser);
        if (table.isHasBraces()) {
            tokenParsers.addAll(BraceTokenParser.getBraces());
        }
        if (table.isHasParens()) {
            tokenParsers.addAll(BraceTokenParser.getParens());
        }
        if (table.isHasBrackets()) {
            tokenParsers.addAll(BraceTokenParser.getBrackets());
        }
        return tokenParsers;
    }
}

