/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.DataManager;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class SelectInNavBarTarget
extends SelectInTargetPsiWrapper
implements DumbAware {
    public static final String NAV_BAR_ID = "NavBar";

    public SelectInNavBarTarget(Project project2) {
        super(project2);
    }

    @NonNls
    public String getToolWindowId() {
        return NAV_BAR_ID;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        return UISettings.getInstance().getShowNavigationBar();
    }

    @Override
    protected void select(Object selector, VirtualFile virtualFile, boolean requestFocus) {
        SelectInNavBarTarget.selectInNavBar();
    }

    @Override
    protected void select(PsiElement element, boolean requestFocus) {
        SelectInNavBarTarget.selectInNavBar();
    }

    private static void selectInNavBar() {
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(context -> {
            IdeRootPaneNorthExtension navBarExt;
            IdeFrame frame = (IdeFrame)IdeFrame.KEY.getData(context);
            if (frame != null && (navBarExt = frame.getNorthExtension(NAV_BAR_ID)) != null) {
                JComponent c = navBarExt.getComponent();
                NavBarPanel panel2 = (NavBarPanel)c.getClientProperty("NavBarPanel");
                panel2.rebuildAndSelectTail(true);
            }
        });
    }

    public float getWeight() {
        return 8.0f;
    }

    public String getMinorViewId() {
        return null;
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return false;
    }

    @Override
    public String toString() {
        return SelectInManager.NAV_BAR;
    }
}

