/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class RepositoryContentHandler
extends DefaultHandler {
    private static final String CATEGORY = "category";
    private static final String PLUGIN = "plugin";
    private static final String IDEA_PLUGIN = "idea-plugin";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String VENDOR = "vendor";
    private static final String EMAIL = "email";
    private static final String URL = "url";
    private static final String IDEA_VERSION = "idea-version";
    private static final String SINCE_BUILD = "since-build";
    private static final String UNTIL_BUILD = "until-build";
    private static final String CHANGE_NOTES = "change-notes";
    private static final String DEPENDS = "depends";
    private static final String DOWNLOADS = "downloads";
    private static final String DOWNLOAD_URL = "downloadUrl";
    private static final String DOWNLOAD_URL_NEW_STYLE = "download-url";
    private static final String SIZE = "size";
    private static final String RATING = "rating";
    private static final String DATE = "date";
    private final StringBuilder currentValue = new StringBuilder();
    private PluginNode currentPlugin;
    private List<IdeaPluginDescriptor> plugins;
    private Stack<String> categories;
    private String categoryName;

    RepositoryContentHandler() {
    }

    @NotNull
    public List<IdeaPluginDescriptor> getPluginsList() {
        List<Object> list = this.plugins != null ? this.plugins : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryContentHandler", "getPluginsList"));
        }
        return list;
    }

    @Override
    public void startDocument() throws SAXException {
        this.plugins = ContainerUtil.newArrayList();
        this.categories = ContainerUtil.newStack();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(CATEGORY)) {
            String category = attributes.getValue(NAME);
            if (!StringUtil.isEmptyOrSpaces((String)category)) {
                this.categories.push((Object)category);
                this.categoryName = null;
            }
        } else if (qName.equals(IDEA_PLUGIN)) {
            this.currentPlugin = new PluginNode();
            this.currentPlugin.setCategory(this.buildCategoryName());
            this.currentPlugin.setDownloads(attributes.getValue(DOWNLOADS));
            this.currentPlugin.setSize(attributes.getValue(SIZE));
            this.currentPlugin.setUrl(attributes.getValue(URL));
            String dateString = attributes.getValue(DATE);
            if (dateString != null) {
                this.currentPlugin.setDate(dateString);
            }
            this.currentPlugin.setIncomplete(false);
            this.plugins.add(this.currentPlugin);
        } else if (qName.equals(IDEA_VERSION)) {
            this.currentPlugin.setSinceBuild(attributes.getValue(SINCE_BUILD));
            this.currentPlugin.setUntilBuild(IdeaPluginDescriptorImpl.convertExplicitBigNumberInUntilBuildToStar(attributes.getValue(UNTIL_BUILD)));
        } else if (qName.equals(VENDOR)) {
            this.currentPlugin.setVendorEmail(attributes.getValue(EMAIL));
            this.currentPlugin.setVendorUrl(attributes.getValue(URL));
        } else if (qName.equals(PLUGIN)) {
            this.currentPlugin = new PluginNode();
            String id = attributes.getValue(ID);
            if (id != null) {
                this.currentPlugin.setId(id);
            }
            this.currentPlugin.setDownloadUrl(attributes.getValue(URL));
            this.currentPlugin.setVersion(attributes.getValue(VERSION));
            this.currentPlugin.setIncomplete(true);
            this.plugins.add(this.currentPlugin);
        }
        this.currentValue.setLength(0);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String currentValueString = this.currentValue.toString();
        this.currentValue.setLength(0);
        if (qName.equals(ID)) {
            this.currentPlugin.setId(currentValueString);
        } else if (qName.equals(NAME)) {
            this.currentPlugin.setName(currentValueString);
        } else if (qName.equals(DESCRIPTION)) {
            this.currentPlugin.setDescription(currentValueString);
        } else if (qName.equals(VERSION)) {
            this.currentPlugin.setVersion(currentValueString);
            if (PluginManagerCore.isBrokenPlugin(this.currentPlugin)) {
                this.plugins.remove(this.currentPlugin);
            }
        } else if (qName.equals(VENDOR)) {
            this.currentPlugin.setVendor(currentValueString);
        } else if (qName.equals(DEPENDS)) {
            this.currentPlugin.addDepends(currentValueString);
        } else if (qName.equals(CHANGE_NOTES)) {
            this.currentPlugin.setChangeNotes(currentValueString);
        } else if (qName.equals(CATEGORY)) {
            this.categories.pop();
            this.categoryName = null;
        } else if (qName.equals(RATING)) {
            this.currentPlugin.setRating(currentValueString);
        } else if (qName.equals(DOWNLOAD_URL) || qName.equals(DOWNLOAD_URL_NEW_STYLE)) {
            this.currentPlugin.setDownloadUrl(currentValueString);
        } else if (qName.equals(IDEA_PLUGIN) || qName.equals(PLUGIN)) {
            this.currentPlugin = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentValue.append(ch, start, length);
    }

    private String buildCategoryName() {
        if (this.categoryName == null) {
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < this.categories.size(); ++i2) {
                if (i2 > 0) {
                    builder.append('/');
                }
                builder.append((String)this.categories.get(i2));
            }
            this.categoryName = builder.toString();
        }
        return this.categoryName;
    }
}

