/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ActionUrl
implements JDOMExternalizable {
    public static final int ADDED = 1;
    public static final int DELETED = -1;
    public static final int MOVE = 2;
    private ArrayList<String> myGroupPath;
    private Object myComponent;
    private int myActionType;
    private int myAbsolutePosition;
    public int myInitialPosition = -1;
    @NonNls
    private static final String IS_GROUP = "is_group";
    @NonNls
    private static final String SEPARATOR = "seperator";
    @NonNls
    private static final String IS_ACTION = "is_action";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String ACTION_TYPE = "action_type";
    @NonNls
    private static final String POSITION = "position";

    public ActionUrl() {
        this.myGroupPath = new ArrayList();
    }

    public ActionUrl(ArrayList<String> groupPath, Object component, int actionType, int position) {
        this.myGroupPath = groupPath;
        this.myComponent = component;
        this.myActionType = actionType;
        this.myAbsolutePosition = position;
    }

    public ArrayList<String> getGroupPath() {
        return this.myGroupPath;
    }

    public String getParentGroup() {
        return this.myGroupPath.get(this.myGroupPath.size() - 1);
    }

    public String getRootGroup() {
        return this.myGroupPath.size() >= 1 ? this.myGroupPath.get(1) : "";
    }

    public Object getComponent() {
        return this.myComponent;
    }

    @Nullable
    public AnAction getComponentAction() {
        if (this.myComponent instanceof Separator) {
            return Separator.getInstance();
        }
        if (this.myComponent instanceof String) {
            return ActionManager.getInstance().getAction((String)this.myComponent);
        }
        if (this.myComponent instanceof Group) {
            String id = ((Group)this.myComponent).getId();
            if (id == null || id.length() == 0) {
                return ((Group)this.myComponent).constructActionGroup(true);
            }
            return ActionManager.getInstance().getAction(id);
        }
        return null;
    }

    public int getActionType() {
        return this.myActionType;
    }

    public void setActionType(int actionType) {
        this.myActionType = actionType;
    }

    public int getAbsolutePosition() {
        return this.myAbsolutePosition;
    }

    public void setAbsolutePosition(int absolutePosition) {
        this.myAbsolutePosition = absolutePosition;
    }

    public int getInitialPosition() {
        return this.myInitialPosition;
    }

    public void setInitialPosition(int initialPosition) {
        this.myInitialPosition = initialPosition;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myGroupPath = new ArrayList();
        for (Object o : element.getChildren(PATH)) {
            this.myGroupPath.add(((Element)o).getAttributeValue(VALUE));
        }
        String attributeValue = element.getAttributeValue(VALUE);
        if (element.getAttributeValue(IS_ACTION) != null) {
            this.myComponent = attributeValue;
        } else if (element.getAttributeValue(SEPARATOR) != null) {
            this.myComponent = Separator.getInstance();
        } else if (element.getAttributeValue(IS_GROUP) != null) {
            AnAction action = ActionManager.getInstance().getAction(attributeValue);
            this.myComponent = action instanceof ActionGroup ? ActionsTreeUtil.createGroup((ActionGroup)action, true, null) : new Group(attributeValue, attributeValue, null);
        }
        this.myActionType = Integer.parseInt(element.getAttributeValue(ACTION_TYPE));
        this.myAbsolutePosition = Integer.parseInt(element.getAttributeValue(POSITION));
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (String s : this.myGroupPath) {
            Element path = new Element(PATH);
            path.setAttribute(VALUE, s);
            element.addContent(path);
        }
        if (this.myComponent instanceof String) {
            element.setAttribute(VALUE, (String)this.myComponent);
            element.setAttribute(IS_ACTION, Boolean.TRUE.toString());
        } else if (this.myComponent instanceof Separator) {
            element.setAttribute(SEPARATOR, Boolean.TRUE.toString());
        } else if (this.myComponent instanceof Group) {
            String groupId = ((Group)this.myComponent).getId() != null && ((Group)this.myComponent).getId().length() != 0 ? ((Group)this.myComponent).getId() : ((Group)this.myComponent).getName();
            element.setAttribute(VALUE, groupId != null ? groupId : "");
            element.setAttribute(IS_GROUP, Boolean.TRUE.toString());
        }
        element.setAttribute(ACTION_TYPE, Integer.toString(this.myActionType));
        element.setAttribute(POSITION, Integer.toString(this.myAbsolutePosition));
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public boolean isGroupContainsInPath(ActionGroup group) {
        for (String s : this.myGroupPath) {
            if (!s.equals(group.getTemplatePresentation().getText())) continue;
            return true;
        }
        return false;
    }

    public static void changePathInActionsTree(JTree tree, ActionUrl url) {
        if (url.myActionType == 1) {
            ActionUrl.addPathToActionsTree(tree, url);
        } else if (url.myActionType == -1) {
            ActionUrl.removePathFromActionsTree(tree, url);
        } else if (url.myActionType == 2) {
            ActionUrl.movePathInActionsTree(tree, url);
        }
    }

    private static void addPathToActionsTree(JTree tree, ActionUrl url) {
        TreePath treePath = CustomizationUtil.getTreePath(tree, url);
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        int absolutePosition = url.getAbsolutePosition();
        if (node.getChildCount() >= absolutePosition && absolutePosition >= 0) {
            if (url.getComponent() instanceof Group) {
                node.insert(ActionsTreeUtil.createNode((Group)url.getComponent()), absolutePosition);
            } else {
                node.insert(new DefaultMutableTreeNode(url.getComponent()), absolutePosition);
            }
        }
    }

    private static void removePathFromActionsTree(JTree tree, ActionUrl url) {
        DefaultMutableTreeNode child;
        if (url.myComponent == null) {
            return;
        }
        TreePath treePath = CustomizationUtil.getTreePath(tree, url);
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        int absolutePosition = url.getAbsolutePosition();
        if (node.getChildCount() > absolutePosition && absolutePosition >= 0 && (child = (DefaultMutableTreeNode)node.getChildAt(absolutePosition)).getUserObject().equals(url.getComponent())) {
            node.remove(child);
        }
    }

    private static void movePathInActionsTree(JTree tree, ActionUrl url) {
        TreePath treePath = CustomizationUtil.getTreePath(tree, url);
        if (treePath != null && treePath.getLastPathComponent() != null) {
            DefaultMutableTreeNode child;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            int absolutePosition = url.getAbsolutePosition();
            int initialPosition = url.getInitialPosition();
            if (parent.getChildCount() > absolutePosition && absolutePosition >= 0 && parent.getChildCount() > initialPosition && initialPosition >= 0 && (child = (DefaultMutableTreeNode)parent.getChildAt(initialPosition)).getUserObject().equals(url.getComponent())) {
                parent.remove(child);
                parent.insert(child, absolutePosition);
            }
        }
    }

    public static ArrayList<String> getGroupPath(TreePath treePath) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i2 = 0; i2 < treePath.getPath().length - 1; ++i2) {
            Object o = ((DefaultMutableTreeNode)treePath.getPath()[i2]).getUserObject();
            if (!(o instanceof Group)) continue;
            result2.add(((Group)o).getName());
        }
        return result2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActionUrl)) {
            return false;
        }
        ActionUrl url = (ActionUrl)object;
        Object comp = this.myComponent instanceof Pair ? ((Pair)this.myComponent).first : this.myComponent;
        Object thatComp = url.myComponent instanceof Pair ? ((Pair)url.myComponent).first : url.myComponent;
        return Comparing.equal((Object)comp, (Object)thatComp) && this.myGroupPath.equals(url.myGroupPath) && this.myAbsolutePosition == url.getAbsolutePosition();
    }

    public int hashCode() {
        int result2 = this.myComponent != null ? this.myComponent.hashCode() : 0;
        return result2 += 29 * this.myGroupPath.hashCode();
    }

    public void setComponent(Object object) {
        this.myComponent = object;
    }

    public void setGroupPath(ArrayList<String> groupPath) {
        this.myGroupPath = groupPath;
    }

    public String toString() {
        return "ActionUrl{myGroupPath=" + this.myGroupPath + ", myComponent=" + this.myComponent + ", myActionType=" + this.myActionType + ", myAbsolutePosition=" + this.myAbsolutePosition + ", myInitialPosition=" + this.myInitialPosition + '}';
    }
}

