/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaTitlePane;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.WindowResizeListener;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class DarculaRootPaneUI
extends BasicRootPaneUI {
    private Window myWindow;
    private JComponent myTitlePane;
    private MouseInputListener myMouseInputListener;
    private MouseInputListener myTitleMouseInputListener;
    private LayoutManager myLayoutManager;
    private LayoutManager myOldLayout;
    protected JRootPane myRootPane;
    protected WindowListener myWindowListener;
    protected Window myCurrentWindow;
    protected HierarchyListener myHierarchyListener;
    protected ComponentListener myWindowComponentListener;
    protected GraphicsConfiguration currentRootPaneGC;
    protected PropertyChangeListener myPropertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        return DarculaRootPaneUI.isCustomDecoration() ? new DarculaRootPaneUI() : DarculaRootPaneUI.createDefaultWindowsRootPaneUI();
    }

    private static ComponentUI createDefaultWindowsRootPaneUI() {
        try {
            return (ComponentUI)Class.forName("com.sun.java.swing.plaf.windows.WindowsRootPaneUI").newInstance();
        }
        catch (Exception e) {
            return new BasicRootPaneUI();
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (DarculaRootPaneUI.isCustomDecoration()) {
            this.myRootPane = (JRootPane)c;
            int style = this.myRootPane.getWindowDecorationStyle();
            if (style != 0) {
                this.installClientDecorations(this.myRootPane);
            }
        }
    }

    public void installMenuBar(JMenuBar menu) {
        if (menu != null && DarculaRootPaneUI.isCustomDecoration()) {
            this.getTitlePane().add(menu);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (DarculaRootPaneUI.isCustomDecoration()) {
            this.uninstallClientDecorations(this.myRootPane);
            this.myLayoutManager = null;
            this.myMouseInputListener = null;
            this.myRootPane = null;
        }
    }

    private static boolean isCustomDecoration() {
        return Registry.is((String)"ide.win.frame.decoration");
    }

    public void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            root.setBorder(JBUI.Borders.customLine((Color)Gray._73, (int)1, (int)1, (int)1, (int)1));
        }
    }

    private static void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        Window window = this.myWindow = parent == null ? null : UIUtil.getWindow((Component)parent);
        if (this.myWindow != null) {
            if (this.myMouseInputListener == null) {
                this.myMouseInputListener = new WindowResizeListener(parent, (Insets)JBUI.insets((int)11), null){

                    @Override
                    protected Insets getResizeOffset(Component view) {
                        return this.getResizeBorder(view);
                    }
                };
            }
            this.myWindow.addMouseListener(this.myMouseInputListener);
            this.myWindow.addMouseMotionListener(this.myMouseInputListener);
            if (this.myTitlePane != null) {
                if (this.myTitleMouseInputListener == null) {
                    this.myTitleMouseInputListener = new WindowMoveListener(this.myTitlePane){

                        @Override
                        protected boolean isDisabled(Component view) {
                            RootPaneContainer container;
                            JRootPane pane;
                            if (view instanceof RootPaneContainer && (pane = (container = (RootPaneContainer)((Object)view)).getRootPane()) != null && 0 == pane.getWindowDecorationStyle()) {
                                return true;
                            }
                            return super.isDisabled(view);
                        }
                    };
                }
                this.myTitlePane.addMouseMotionListener(this.myTitleMouseInputListener);
                this.myTitlePane.addMouseListener(this.myTitleMouseInputListener);
            }
            this.setMaximized();
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.myWindow != null) {
            this.myWindow.removeMouseListener(this.myMouseInputListener);
            this.myWindow.removeMouseMotionListener(this.myMouseInputListener);
        }
        if (this.myTitlePane != null) {
            this.myTitlePane.removeMouseListener(this.myTitleMouseInputListener);
            this.myTitlePane.removeMouseMotionListener(this.myTitleMouseInputListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.myLayoutManager == null) {
            this.myLayoutManager = this.createLayoutManager();
        }
        this.myOldLayout = root.getLayout();
        root.setLayout(this.myLayoutManager);
    }

    @Override
    protected void installListeners(final JRootPane root) {
        super.installListeners(root);
        this.myHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Container parent = root.getParent();
                if (parent == null) {
                    return;
                }
                if (parent.getClass().getName().startsWith("org.jdesktop.jdic.tray") || parent.getClass().getName().compareTo("javax.swing.Popup$HeavyWeightWindow") == 0) {
                    SwingUtilities.invokeLater(() -> {
                        root.removeHierarchyListener(DarculaRootPaneUI.this.myHierarchyListener);
                        DarculaRootPaneUI.this.myHierarchyListener = null;
                    });
                }
                Window currWindow = UIUtil.getWindow((Component)parent);
                if (DarculaRootPaneUI.this.myWindowListener != null) {
                    DarculaRootPaneUI.this.myCurrentWindow.removeWindowListener(DarculaRootPaneUI.this.myWindowListener);
                    DarculaRootPaneUI.this.myWindowListener = null;
                }
                if (DarculaRootPaneUI.this.myWindowComponentListener != null) {
                    DarculaRootPaneUI.this.myCurrentWindow.removeComponentListener(DarculaRootPaneUI.this.myWindowComponentListener);
                    DarculaRootPaneUI.this.myWindowComponentListener = null;
                }
                if (currWindow != null) {
                    DarculaRootPaneUI.this.myWindowListener = new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            SwingUtilities.invokeLater(() -> {
                                Frame[] frames;
                                for (Frame frame : frames = Frame.getFrames()) {
                                    if (!frame.isDisplayable()) continue;
                                    return;
                                }
                            });
                        }
                    };
                    if (!(parent instanceof JInternalFrame)) {
                        currWindow.addWindowListener(DarculaRootPaneUI.this.myWindowListener);
                    }
                    DarculaRootPaneUI.this.myWindowComponentListener = new ComponentAdapter(){

                        @Override
                        public void componentMoved(ComponentEvent e) {
                            this.processNewPosition();
                        }

                        @Override
                        public void componentResized(ComponentEvent e) {
                            this.processNewPosition();
                        }

                        private void processNewPosition() {
                            SwingUtilities.invokeLater(() -> {
                                if (DarculaRootPaneUI.this.myWindow == null) {
                                    return;
                                }
                                if (!DarculaRootPaneUI.this.myWindow.isShowing() || !DarculaRootPaneUI.this.myWindow.isDisplayable()) {
                                    DarculaRootPaneUI.this.currentRootPaneGC = null;
                                    return;
                                }
                                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                                GraphicsDevice[] gds = ge.getScreenDevices();
                                if (gds.length == 1) {
                                    return;
                                }
                                Point midLoc = new Point(((DarculaRootPaneUI)DarculaRootPaneUI.this).myWindow.getLocationOnScreen().x + DarculaRootPaneUI.this.myWindow.getWidth() / 2, ((DarculaRootPaneUI)DarculaRootPaneUI.this).myWindow.getLocationOnScreen().y + DarculaRootPaneUI.this.myWindow.getHeight() / 2);
                                for (GraphicsDevice gd : gds) {
                                    GraphicsConfiguration gc = gd.getDefaultConfiguration();
                                    Rectangle bounds = gc.getBounds();
                                    if (!bounds.contains(midLoc)) continue;
                                    if (gc == DarculaRootPaneUI.this.currentRootPaneGC) break;
                                    DarculaRootPaneUI.this.currentRootPaneGC = gc;
                                    DarculaRootPaneUI.this.setMaximized();
                                    break;
                                }
                            });
                        }
                    };
                    if (parent instanceof JFrame) {
                        currWindow.addComponentListener(DarculaRootPaneUI.this.myWindowComponentListener);
                    }
                    DarculaRootPaneUI.this.myWindow = currWindow;
                }
                DarculaRootPaneUI.this.myCurrentWindow = currWindow;
            }
        };
        root.addHierarchyListener(this.myHierarchyListener);
        root.addPropertyChangeListener(this.myPropertyChangeListener);
    }

    @Override
    protected void uninstallListeners(JRootPane root) {
        if (this.myWindow != null) {
            this.myWindow.removeWindowListener(this.myWindowListener);
            this.myWindowListener = null;
            this.myWindow.removeComponentListener(this.myWindowComponentListener);
            this.myWindowComponentListener = null;
        }
        root.removeHierarchyListener(this.myHierarchyListener);
        this.myHierarchyListener = null;
        root.removePropertyChangeListener(this.myPropertyChangeListener);
        this.myPropertyChangeListener = null;
        super.uninstallListeners(root);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.myOldLayout != null) {
            root.setLayout(this.myOldLayout);
            this.myOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.myWindow != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        DarculaRootPaneUI.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.myWindow != null) {
            this.myWindow.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.myWindow = null;
    }

    protected JComponent createTitlePane(JRootPane root) {
        return new DarculaTitlePane(root, this);
    }

    protected LayoutManager createLayoutManager() {
        return new DarculaRootLayout();
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.myTitlePane = titlePane;
    }

    public void setMaximized() {
        if (Registry.is((String)"darcula.fix.maximized.frame.bounds")) {
            return;
        }
        Container tla = this.myRootPane.getTopLevelAncestor();
        GraphicsConfiguration gc = this.currentRootPaneGC != null ? this.currentRootPaneGC : tla.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        screenBounds.x = 0;
        screenBounds.y = 0;
        Insets screenInsets = ScreenUtil.getScreenInsets((GraphicsConfiguration)gc);
        Rectangle maxBounds = new Rectangle(screenBounds.x + screenInsets.left, screenBounds.y + screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom));
        if (tla instanceof JFrame) {
            ((JFrame)tla).setMaximizedBounds(maxBounds);
        }
    }

    public JComponent getTitlePane() {
        return this.myTitlePane;
    }

    protected JRootPane getRootPane() {
        return this.myRootPane;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        }
        if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.myRootPane);
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.myRootPane, this.myRootPane.getParent());
            }
        }
    }

    private static int max(int a, int b, int ... others) {
        int result2 = Math.max(a, b);
        for (int other : others) {
            result2 = Math.max(result2, other);
        }
        return result2;
    }

    protected class DarculaRootLayout
    implements LayoutManager2 {
        protected DarculaRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i2 = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof DarculaRootPaneUI && (titlePane = ((DarculaRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(DarculaRootPaneUI.max(cpWidth, mbWidth, new int[]{tpWidth}) + i2.left + i2.right, cpHeight + mbHeight + tpHeight + i2.top + i2.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i2 = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof DarculaRootPaneUI && (titlePane = ((DarculaRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(DarculaRootPaneUI.max(cpWidth, mbWidth, new int[]{tpWidth}) + i2.left + i2.right, cpHeight + mbHeight + tpHeight + i2.top + i2.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i2 = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof DarculaRootPaneUI && (titlePane = ((DarculaRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = DarculaRootPaneUI.max(cpHeight, mbHeight, new int[]{tpHeight})) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i2.top + i2.bottom;
            }
            if ((maxWidth = DarculaRootPaneUI.max(cpWidth, mbWidth, new int[]{tpWidth})) != Integer.MAX_VALUE) {
                maxWidth += i2.left + i2.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i2 = root.getInsets();
            int nextY = 0;
            int w = b.width - i2.right - i2.left;
            int h = b.height - i2.top - i2.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i2.left, i2.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i2.left, i2.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof DarculaRootPaneUI && (titlePane = ((DarculaRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

