/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.Gray;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class DarculaTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public DarculaTextFieldUI(JTextField textField) {
        super(textField);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaTextFieldUI((JTextField)c);
    }

    @Override
    public void showSearchPopup() {
        Object value = this.myTextField.getClientProperty("JTextField.Search.FindPopup");
        JTextComponent editor = this.getComponent();
        if (editor != null && value instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)value;
            popup.show(editor, this.getSearchIconCoord().x, editor.getHeight());
        }
    }

    @Override
    public TextFieldWithPopupHandlerUI.SearchAction getActionUnder(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ide/ui/laf/darcula/ui/DarculaTextFieldUI", "getActionUnder"));
        }
        int off = JBUI.scale((int)8);
        Point point = new Point(p.x - off, p.y - off);
        return point.distance(this.getSearchIconCoord()) <= (double)off ? TextFieldWithPopupHandlerUI.SearchAction.POPUP : (this.hasText() && point.distance(this.getClearIconCoord()) <= (double)off ? TextFieldWithPopupHandlerUI.SearchAction.CLEAR : null);
    }

    protected Rectangle getDrawingRect() {
        JTextField c = this.myTextField;
        JBInsets i2 = JBInsets.create((Insets)c.getInsets());
        int x = i2.right - JBUI.scale((int)4) - JBUI.scale((int)16);
        int y = i2.top - JBUI.scale((int)3);
        int w = c.getWidth() - i2.width() + JBUI.scale((int)41);
        int h = c.getBounds().height - i2.height() + JBUI.scale((int)5);
        if (h % 2 == 1) {
            ++h;
        }
        return new Rectangle(x, y, w, h);
    }

    protected Point getSearchIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + JBUI.scale((int)3), r.y + (r.height - JBUI.scale((int)16)) / 2 + JBUI.scale((int)1));
    }

    protected Point getClearIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + r.width - JBUI.scale((int)16) - JBUI.scale((int)2), r.y + (r.height - JBUI.scale((int)16)) / 2);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        Rectangle r = this.getDrawingRect();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        GraphicsConfig config = new GraphicsConfig((Graphics)g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Border border = c.getBorder();
        if (DarculaTextFieldUI.isSearchField(c)) {
            this.paintSearchField(g, c, r);
        } else if (border instanceof DarculaTextBorder) {
            this.paintDarculaBackground(g, c, border);
        } else {
            super.paintBackground(g);
        }
        config.restore();
    }

    protected void paintDarculaBackground(Graphics2D g, JTextComponent c, Border border) {
        if (c.isEnabled() && c.isEditable()) {
            g.setColor(c.getBackground());
        }
        int width = c.getWidth();
        int height = c.getHeight();
        Insets i2 = border.getBorderInsets(c);
        if (c.hasFocus()) {
            g.fillRoundRect(i2.left - JBUI.scale((int)5), i2.top - JBUI.scale((int)2), width - i2.right - i2.left + JBUI.scale((int)10), height - i2.top - i2.bottom + JBUI.scale((int)6), JBUI.scale((int)5), JBUI.scale((int)5));
        } else {
            g.fillRect(i2.left - JBUI.scale((int)5), i2.top - JBUI.scale((int)2), width - i2.right - i2.left + JBUI.scale((int)12), height - i2.top - i2.bottom + JBUI.scale((int)6));
        }
    }

    protected void paintSearchField(Graphics2D g, JTextComponent c, Rectangle r) {
        Icon searchIcon;
        boolean noBorder = c.getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE;
        int radius = r.height - 1;
        if (noBorder) {
            g.setColor(c.getBackground());
            RectanglePainter.FILL.paint(g, r.x, r.y, r.width, r.height, (Object)radius);
        } else if (c.hasFocus()) {
            g.setColor(c.getBackground());
            RectanglePainter.FILL.paint(g, r.x, r.y, r.width, r.height, (Object)radius);
            DarculaUIUtil.paintSearchFocusRing(g, r, c);
        } else {
            RectanglePainter.paint((Graphics2D)g, (int)r.x, (int)r.y, (int)r.width, (int)r.height, (int)radius, (Color)c.getBackground(), (Color)(c.isEnabled() ? Gray._100 : Gray._83));
        }
        Point p = this.getSearchIconCoord();
        Icon icon = searchIcon = this.myTextField.getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu ? UIManager.getIcon("TextField.darcula.searchWithHistory.icon") : UIManager.getIcon("TextField.darcula.search.icon");
        if (searchIcon == null) {
            searchIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/search.png", DarculaTextFieldUI.class, (boolean)true);
        }
        searchIcon.paintIcon(null, g, p.x, p.y);
        if (this.hasText()) {
            p = this.getClearIconCoord();
            Icon clearIcon = UIManager.getIcon("TextField.darcula.clear.icon");
            if (clearIcon == null) {
                clearIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/clear.png", DarculaTextFieldUI.class, (boolean)true);
            }
            clearIcon.paintIcon(null, g, p.x, p.y);
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.paintBackground(g);
        super.paintSafely(g);
    }
}

