/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class SuperMethodWarningDialog
extends DialogWrapper {
    static final int NO_EXIT_CODE = 3;
    private final String myName;
    private final String[] myClassNames;
    private final String myActionString;
    private final boolean myIsSuperAbstract;
    private final boolean myIsParentInterface;
    private final boolean myIsContainedInInterface;

    SuperMethodWarningDialog(@NotNull Project project2, @NotNull String name, @NotNull String actionString, boolean isSuperAbstract, boolean isParentInterface, boolean isContainedInInterface, String ... classNames) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/SuperMethodWarningDialog", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/SuperMethodWarningDialog", "<init>"));
        }
        if (actionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionString", "com/intellij/ide/util/SuperMethodWarningDialog", "<init>"));
        }
        if (classNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classNames", "com/intellij/ide/util/SuperMethodWarningDialog", "<init>"));
        }
        super(project2, true);
        this.myName = name;
        this.myClassNames = classNames;
        this.myActionString = actionString;
        this.myIsSuperAbstract = isSuperAbstract;
        this.myIsParentInterface = isParentInterface;
        this.myIsContainedInInterface = isContainedInInterface;
        this.setTitle(IdeBundle.message((String)"title.warning", (Object[])new Object[0]));
        this.setButtonsAlignment(0);
        this.setOKButtonText(CommonBundle.getYesButtonText());
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), new NoAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/SuperMethodWarningDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel iconLabel = new JLabel(Messages.getQuestionIcon());
        panel2.add((Component)iconLabel, "West");
        JPanel labelsPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        labelsPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 10));
        String classType = this.myIsParentInterface ? IdeBundle.message((String)"element.of.interface", (Object[])new Object[0]) : IdeBundle.message((String)"element.of.class", (Object[])new Object[0]);
        String methodString = IdeBundle.message((String)"element.method", (Object[])new Object[0]);
        labelsPanel.add(new JLabel(IdeBundle.message((String)"label.method", (Object[])new Object[]{this.myName})));
        if (this.myClassNames.length == 1) {
            String className = this.myClassNames[0];
            labelsPanel.add(new JLabel(this.myIsContainedInInterface || !this.myIsSuperAbstract ? IdeBundle.message((String)"label.overrides.method.of_class_or_interface.name", (Object[])new Object[]{methodString, classType, className}) : IdeBundle.message((String)"label.implements.method.of_class_or_interface.name", (Object[])new Object[]{methodString, classType, className})));
        } else {
            JLabel multLabel = new JLabel(IdeBundle.message((String)"label.implements.method.of_interfaces", (Object[])new Object[0]));
            multLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            labelsPanel.add(multLabel);
            for (String className : this.myClassNames) {
                labelsPanel.add(new JLabel("    " + className));
            }
        }
        JLabel doYouWantLabel = new JLabel(IdeBundle.message((String)"prompt.do.you.want.to.action_verb.the.method.from_class", (Object[])new Object[]{this.myActionString, this.myClassNames.length}));
        doYouWantLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        labelsPanel.add(doYouWantLabel);
        panel2.add((Component)labelsPanel, "Center");
        return panel2;
    }

    public static String capitalize(String text) {
        return Character.toUpperCase(text.charAt(0)) + text.substring(1);
    }

    public JComponent createCenterPanel() {
        return null;
    }

    private class NoAction
    extends AbstractAction {
        private NoAction() {
            super(CommonBundle.getNoButtonText());
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/SuperMethodWarningDialog$NoAction", "actionPerformed"));
            }
            SuperMethodWarningDialog.this.close(3);
        }
    }
}

