/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class TipPanel
extends JPanel {
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 200;
    private final JEditorPane myBrowser;
    private final JLabel myPoweredByLabel;
    private final List<TipAndTrickBean> myTips = ContainerUtil.newArrayList();

    public TipPanel() {
        this.setLayout(new BorderLayout());
        JLabel jlabel = new JLabel(AllIcons.General.Tip);
        jlabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JLabel label1 = new JLabel(IdeBundle.message((String)"label.did.you.know", (Object[])new Object[0]));
        Font font = label1.getFont();
        label1.setFont(font.deriveFont(0, font.getSize() + 4));
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        jpanel.add((Component)jlabel, "West");
        jpanel.add((Component)label1, "Center");
        jpanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.add((Component)jpanel, "North");
        this.myBrowser = TipUIUtil.createTipBrowser();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myBrowser);
        this.add((Component)scrollPane, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        JCheckBox showOnStartCheckBox = new JCheckBox(IdeBundle.message((String)"checkbox.show.tips.on.startup", (Object[])new Object[0]), true);
        showOnStartCheckBox.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        final GeneralSettings settings = GeneralSettings.getInstance();
        showOnStartCheckBox.setSelected(settings.isShowTipsOnStartup());
        showOnStartCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/TipPanel$1", "itemStateChanged"));
                }
                settings.setShowTipsOnStartup(e.getStateChange() == 1);
            }
        });
        southPanel.add((Component)showOnStartCheckBox, "West");
        this.myPoweredByLabel = new JBLabel();
        this.myPoweredByLabel.setHorizontalAlignment(4);
        this.myPoweredByLabel.setForeground(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.getFgColor());
        southPanel.add((Component)this.myPoweredByLabel, "East");
        this.add((Component)southPanel, "South");
        Collections.addAll(this.myTips, Extensions.getExtensions(TipAndTrickBean.EP_NAME));
    }

    @Override
    public Dimension getPreferredSize() {
        return new JBDimension(400, 200);
    }

    public void prevTip() {
        TipAndTrickBean tip;
        if (this.myTips.size() == 0) {
            this.myBrowser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        int lastTip = settings.getLastTip();
        if (--lastTip <= 0) {
            tip = this.myTips.get(this.myTips.size() - 1);
            lastTip = this.myTips.size();
        } else {
            tip = this.myTips.get(lastTip - 1);
        }
        this.setTip(tip, lastTip, this.myBrowser, settings);
    }

    private void setTip(TipAndTrickBean tip, int lastTip, JEditorPane browser, GeneralSettings settings) {
        TipUIUtil.openTipInBrowser(tip, browser);
        this.myPoweredByLabel.setText(TipUIUtil.getPoweredByText(tip));
        settings.setLastTip(lastTip);
    }

    public void nextTip() {
        TipAndTrickBean tip;
        if (this.myTips.size() == 0) {
            this.myBrowser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        int lastTip = settings.getLastTip();
        if (++lastTip - 1 >= this.myTips.size()) {
            tip = this.myTips.get(0);
            lastTip = 1;
        } else {
            tip = this.myTips.get(lastTip - 1);
        }
        this.setTip(tip, lastTip, this.myBrowser, settings);
    }
}

