/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileCellRenderer
extends PsiElementListCellRenderer<PsiFileSystemItem> {
    private final int myMaxWidth;

    public GotoFileCellRenderer(int maxSize) {
        this.myMaxWidth = maxSize;
    }

    @Override
    public String getElementText(PsiFileSystemItem element) {
        return element.getName();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == "non-prefix matches:") {
            Object previousElement = index > 0 ? list.getModel().getElementAt(index - 1) : null;
            return ChooseByNameBase.renderNonPrefixSeparatorComponent(GotoFileCellRenderer.getBackgroundColor(previousElement));
        }
        return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
    }

    @Override
    protected String getContainerText(PsiFileSystemItem element, String name) {
        PsiDirectory psiDirectory;
        PsiFileSystemItem parent = element.getParent();
        PsiDirectory psiDirectory2 = psiDirectory = parent instanceof PsiDirectory ? (PsiDirectory)parent : null;
        if (psiDirectory == null) {
            return null;
        }
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        String relativePath = GotoFileCellRenderer.getRelativePath(virtualFile, element.getProject());
        if (relativePath == null) {
            return "( " + File.separator + " )";
        }
        String path = FilePathSplittingPolicy.SPLIT_BY_SEPARATOR.getOptimalTextForComponent(name + "          ", new File(relativePath), (JComponent)this, this.myMaxWidth);
        return "(" + path + ")";
    }

    @Nullable
    public static String getRelativePath(VirtualFile virtualFile, Project project2) {
        String projectHomeUrl;
        if (project2 == null) {
            return virtualFile.getPresentableUrl();
        }
        VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project2).getContentRootForFile(virtualFile);
        if (root != null) {
            return GotoFileCellRenderer.getRelativePathFromRoot(virtualFile, root);
        }
        String url = virtualFile.getPresentableUrl();
        VirtualFile baseDir = project2.getBaseDir();
        if (baseDir != null && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            String cont = url.substring(projectHomeUrl.length());
            if (cont.isEmpty()) {
                return null;
            }
            url = "..." + cont;
        }
        return url;
    }

    @NotNull
    static String getRelativePathFromRoot(@NotNull VirtualFile file2, @NotNull VirtualFile root) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/util/gotoByName/GotoFileCellRenderer", "getRelativePathFromRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ide/util/gotoByName/GotoFileCellRenderer", "getRelativePathFromRoot"));
        }
        String string = root.getName() + File.separatorChar + VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)root, (char)File.separatorChar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoFileCellRenderer", "getRelativePathFromRoot"));
        }
        return string;
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (!(value instanceof NavigationItem)) {
            return false;
        }
        NavigationItem item = (NavigationItem)value;
        TextAttributes attributes = this.getNavigationItemAttributes(item);
        SimpleTextAttributes nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
        Color color = list.getForeground();
        if (nameAttributes == null) {
            nameAttributes = new SimpleTextAttributes(0, color);
        }
        renderer.append(item + " ", nameAttributes);
        ItemPresentation itemPresentation = item.getPresentation();
        assert (itemPresentation != null);
        renderer.setIcon(itemPresentation.getIcon(true));
        String locationString = itemPresentation.getLocationString();
        if (!StringUtil.isEmpty((String)locationString)) {
            renderer.append(locationString, new SimpleTextAttributes(0, (Color)JBColor.GRAY));
        }
        return true;
    }

    @Override
    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
        DefaultListCellRenderer rightRenderer = super.getRightCellRenderer(value);
        if (rightRenderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return rightRenderer;
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }
}

