/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelDiff {
    @Nullable
    public static List<Cmd> createDiffCmds(@NotNull Model<Object> listModel, @NotNull Object[] oldElements, @NotNull Object[] newElements) {
        if (listModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listModel", "com/intellij/ide/util/gotoByName/ModelDiff", "createDiffCmds"));
        }
        if (oldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElements", "com/intellij/ide/util/gotoByName/ModelDiff", "createDiffCmds"));
        }
        if (newElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElements", "com/intellij/ide/util/gotoByName/ModelDiff", "createDiffCmds"));
        }
        Diff.Change change = null;
        try {
            change = Diff.buildChanges((Object[])oldElements, (Object[])newElements);
        }
        catch (FilesTooBigForDiffException filesTooBigForDiffException) {
            // empty catch block
        }
        if (change == null) {
            return null;
        }
        ArrayList<Cmd> commands = new ArrayList<Cmd>();
        int inserted = 0;
        int deleted = 0;
        while (change != null) {
            if (change.deleted > 0) {
                int start = change.line0 + inserted - deleted;
                commands.add(new RemoveCmd(listModel, start, start + change.deleted - 1));
            }
            if (change.inserted > 0) {
                ArrayList<Object> elements = new ArrayList<Object>(Arrays.asList(newElements).subList(change.line1, change.line1 + change.inserted));
                commands.add(new InsertCmd(listModel, change.line0 + inserted - deleted, elements));
            }
            deleted += change.deleted;
            inserted += change.inserted;
            change = change.link;
        }
        return commands;
    }

    private static class InsertCmd<T>
    implements Cmd {
        private final Model<T> myListModel;
        private final int idx;
        private final List<T> elements;

        private InsertCmd(@NotNull Model<T> model, int idx, @NotNull List<T> elements) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ModelDiff$InsertCmd", "<init>"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/ModelDiff$InsertCmd", "<init>"));
            }
            this.myListModel = model;
            this.idx = idx;
            this.elements = elements;
        }

        @Override
        public void apply() {
            this.myListModel.addAllToModel(this.idx, this.elements);
        }

        @Override
        public int translateSelection(int row) {
            return this.idx > row ? row : row + 1;
        }

        public String toString() {
            return "+[" + this.idx + "]";
        }
    }

    private static class RemoveCmd<T>
    implements Cmd {
        private final Model<T> myListModel;
        private final int start;
        private final int end;

        private RemoveCmd(@NotNull Model<T> model, int start, int end) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ModelDiff$RemoveCmd", "<init>"));
            }
            this.myListModel = model;
            this.start = start;
            this.end = end;
        }

        @Override
        public void apply() {
            this.myListModel.removeRangeFromModel(this.start, this.end);
        }

        @Override
        public int translateSelection(int row) {
            if (row < this.start) {
                return row;
            }
            if (row >= this.end) {
                return row - (this.end - this.start);
            }
            return this.start - 1;
        }

        public String toString() {
            return "-[" + this.start + ", " + this.end + "]";
        }
    }

    public static interface Model<T> {
        public void addToModel(int var1, T var2);

        default public void addAllToModel(int index, List<T> elements) {
            for (int i2 = 0; i2 < elements.size(); ++i2) {
                this.addToModel(index + i2, elements.get(i2));
            }
        }

        public void removeRangeFromModel(int var1, int var2);
    }

    public static interface Cmd {
        public void apply();

        public int translateSelection(int var1);
    }
}

