/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lang.java.parser.ModuleParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleInsight
extends ModuleInsight {
    private static final Logger LOG = Logger.getInstance(JavaModuleInsight.class);
    private final Lexer myLexer = JavaParserDefinition.createLexer(LanguageLevel.JDK_1_5);

    public JavaModuleInsight(@Nullable ProgressIndicator progress, Set<String> existingModuleNames, Set<String> existingProjectLibraryNames) {
        super(progress, existingModuleNames, existingProjectLibraryNames);
    }

    @Override
    public void scanModules() {
        this.scanModuleInfoFiles();
        super.scanModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanModuleInfoFiles() {
        List<DetectedSourceRoot> allRoots = super.getSourceRootsToScan();
        List moduleInfoRoots = ((StreamEx)((StreamEx)StreamEx.of(allRoots).select(JavaModuleSourceRoot.class).filter(JavaModuleSourceRoot::isWithModuleInfoFile)).filter(root -> !this.isIgnoredName(root.getDirectory()))).toList();
        if (moduleInfoRoots.isEmpty()) {
            return;
        }
        this.myProgress.setIndeterminate(true);
        this.myProgress.pushState();
        try {
            HashMap<String, ModuleInfo> moduleInfos = new HashMap<String, ModuleInfo>();
            for (JavaModuleSourceRoot moduleInfoRoot : moduleInfoRoots) {
                File sourceRoot = moduleInfoRoot.getDirectory();
                this.myProgress.setText("Scanning " + sourceRoot.getPath());
                ModuleInfo moduleInfo = this.scanModuleInfoFile(sourceRoot);
                if (moduleInfo == null) continue;
                moduleInfo.descriptor = this.createModuleDescriptor(moduleInfo.directory, Collections.singletonList(moduleInfoRoot));
                moduleInfos.put(moduleInfo.name, moduleInfo);
                this.addExportedPackages(sourceRoot, moduleInfo.exportsPackages);
            }
            this.myProgress.setText("Building modules layout...");
            for (ModuleInfo moduleInfo : moduleInfos.values()) {
                for (String requiresModule : moduleInfo.requiresModules) {
                    ModuleInfo requiredModuleInfo = (ModuleInfo)moduleInfos.get(requiresModule);
                    if (requiredModuleInfo == null) continue;
                    moduleInfo.descriptor.addDependencyOn(requiredModuleInfo.descriptor);
                }
            }
            this.addModules(StreamEx.of(moduleInfos.values()).map(info -> info.descriptor).toList());
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            this.myProgress.popState();
        }
    }

    @Override
    @NotNull
    protected List<DetectedSourceRoot> getSourceRootsToScan() {
        List<DetectedSourceRoot> allRoots = super.getSourceRootsToScan();
        List list = ContainerUtil.filter(allRoots, r -> !(r instanceof JavaModuleSourceRoot) || !((JavaModuleSourceRoot)r).isWithModuleInfoFile());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/JavaModuleInsight", "getSourceRootsToScan"));
        }
        return list;
    }

    private ModuleInfo scanModuleInfoFile(@NotNull File directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/util/importProject/JavaModuleInsight", "scanModuleInfoFile"));
        }
        File file2 = new File(directory, "module-info.java");
        this.myProgress.setText2(file2.getName());
        try {
            File parent;
            char[] chars = FileUtil.loadFileText((File)file2);
            String text = new String(chars);
            ModuleInfo moduleInfo = (ModuleInfo)ReadAction.compute(() -> {
                JavaDummyElement dummyElement;
                Project project2 = ProjectManager.getInstance().getDefaultProject();
                PsiManager manager = PsiManager.getInstance((Project)project2);
                DummyHolder holder = DummyHolderFactory.createHolder(manager, dummyElement = new JavaDummyElement(text, builder -> ModuleParser.parseModule(builder), LanguageLevel.JDK_1_9), null);
                PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement());
                PsiJavaModule javaModule = (PsiJavaModule)PsiTreeUtil.getChildOfType((PsiElement)element, PsiJavaModule.class);
                if (javaModule == null) {
                    throw new IncorrectOperationException("Incorrect module declaration '" + file2.getPath() + "'");
                }
                ModuleInfo info = new ModuleInfo(javaModule.getModuleName());
                javaModule.accept((PsiElementVisitor)new ModuleInfoVisitor(info));
                return info;
            });
            File moduleDirectory = directory;
            while (!this.isEntryPointRoot(moduleDirectory) && !moduleInfo.name.equals(moduleDirectory.getName()) && (parent = moduleDirectory.getParentFile()) != null) {
                moduleDirectory = parent;
            }
            moduleInfo.directory = moduleDirectory;
            return moduleInfo;
        }
        catch (IncorrectOperationException | IOException e) {
            LOG.info(e);
            return null;
        }
    }

    @Override
    protected boolean isSourceFile(File file2) {
        return StringUtil.endsWithIgnoreCase((String)file2.getName(), (String)".java");
    }

    @Override
    protected boolean isLibraryFile(String fileName) {
        return StringUtil.endsWithIgnoreCase((String)fileName, (String)".jar") || StringUtil.endsWithIgnoreCase((String)fileName, (String)".zip");
    }

    @Override
    protected void scanSourceFileForImportedPackages(CharSequence chars, Consumer<String> result2) {
        this.myLexer.start(chars);
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(this.myLexer);
        if (this.myLexer.getTokenType() == JavaTokenType.PACKAGE_KEYWORD) {
            JavaModuleInsight.advanceLexer(this.myLexer);
            if (JavaModuleInsight.readPackageName(chars, this.myLexer) == null) {
                return;
            }
        }
        while (true) {
            String packageName;
            if (this.myLexer.getTokenType() == JavaTokenType.SEMICOLON) {
                JavaModuleInsight.advanceLexer(this.myLexer);
            }
            if (this.myLexer.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
                return;
            }
            JavaModuleInsight.advanceLexer(this.myLexer);
            boolean isStaticImport = false;
            if (this.myLexer.getTokenType() == JavaTokenType.STATIC_KEYWORD) {
                isStaticImport = true;
                JavaModuleInsight.advanceLexer(this.myLexer);
            }
            if ((packageName = JavaModuleInsight.readPackageName(chars, this.myLexer)) == null) {
                return;
            }
            if (packageName.endsWith(".*")) {
                result2.consume((Object)packageName.substring(0, packageName.length() - ".*".length()));
                continue;
            }
            int lastDot = packageName.lastIndexOf(46);
            if (lastDot <= 0) continue;
            String _packageName = packageName.substring(0, lastDot);
            if (isStaticImport) {
                lastDot = _packageName.lastIndexOf(46);
                if (lastDot <= 0) continue;
                result2.consume((Object)_packageName.substring(0, lastDot));
                continue;
            }
            result2.consume((Object)_packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String readPackageName(CharSequence text, Lexer lexer) {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            while (lexer.getTokenType() == JavaTokenType.IDENTIFIER || lexer.getTokenType() == JavaTokenType.ASTERISK) {
                buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd());
                JavaModuleInsight.advanceLexer(lexer);
                if (lexer.getTokenType() != JavaTokenType.DOT) break;
                buffer.append('.');
                JavaModuleInsight.advanceLexer(lexer);
            }
            String packageName = buffer.toString();
            if (packageName.length() == 0 || StringUtil.endsWithChar((CharSequence)packageName, (char)'.') || StringUtil.startsWithChar((CharSequence)packageName, (char)'*')) {
                String string = null;
                return string;
            }
            String string = packageName;
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    private static void advanceLexer(Lexer lexer) {
        lexer.advance();
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scanLibraryForDeclaredPackages(File file2, Consumer<String> result2) throws IOException {
        try (ZipFile zip = new ZipFile(file2);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                int index;
                String entryName = entries.nextElement().getName();
                if (!StringUtil.endsWithIgnoreCase((String)entryName, (String)".class") || (index = entryName.lastIndexOf(47)) <= 0) continue;
                String packageName = entryName.substring(0, index).replace('/', '.');
                result2.consume((Object)packageName);
            }
        }
    }

    @Override
    protected ModuleDescriptor createModuleDescriptor(File moduleContentRoot, Collection<DetectedSourceRoot> sourceRoots) {
        return new ModuleDescriptor(moduleContentRoot, StdModuleTypes.JAVA, sourceRoots);
    }

    @Override
    public boolean isApplicableRoot(DetectedProjectRoot root) {
        return root instanceof JavaModuleSourceRoot;
    }

    private static class ModuleInfoVisitor
    extends JavaRecursiveElementVisitor {
        private final ModuleInfo myInfo;

        public ModuleInfoVisitor(ModuleInfo info) {
            this.myInfo = info;
        }

        public void visitRequiresStatement(PsiRequiresStatement statement2) {
            super.visitRequiresStatement(statement2);
            PsiJavaModuleReferenceElement referenceElement = statement2.getReferenceElement();
            if (referenceElement != null) {
                String referenceText = referenceElement.getReferenceText();
                this.myInfo.requiresModules.add(referenceText);
            }
        }

        public void visitExportsStatement(PsiExportsStatement statement2) {
            String qualifiedName;
            super.visitExportsStatement(statement2);
            PsiJavaCodeReferenceElement reference = statement2.getPackageReference();
            if (reference != null && (qualifiedName = reference.getQualifiedName()) != null) {
                this.myInfo.exportsPackages.add(qualifiedName);
            }
        }
    }

    private static class ModuleInfo {
        @NotNull
        final String name;
        final Set<String> requiresModules;
        final Set<String> exportsPackages;
        File directory;
        ModuleDescriptor descriptor;

        private ModuleInfo(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/importProject/JavaModuleInsight$ModuleInfo", "<init>"));
            }
            this.requiresModules = new HashSet<String>();
            this.exportsPackages = new HashSet<String>();
            this.name = name;
        }
    }
}

