/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class EditorSettingsStatisticsCollector
extends UsagesCollector {
    EditorSettingsStatisticsCollector() {
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("Editor");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        HashSet<UsageDescriptor> set2 = new HashSet<UsageDescriptor>();
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isVirtualSpace(), false, "caretAfterLineEnd");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isCaretInsideTabs(), false, "caretInsideTabs");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isAdditionalPageAtBottom(), false, "virtualSpaceAtFileBottom");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR), false, "softWraps");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE), false, "softWraps.console");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isUseSoftWraps(SoftWrapAppliancePlaces.PREVIEW), false, "softWraps.preview");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isUseCustomSoftWrapIndent(), false, "softWraps.relativeIndent");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isAllSoftWrapsShown(), false, "softWraps.showAll");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.getStripTrailingSpaces(), "Changed", "stripTrailingSpaces");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isEnsureNewLineAtEOF(), false, "ensureNewlineAtEOF");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isShowQuickDocOnMouseOverElement(), false, "quickDocOnMouseHover");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isBlinkCaret(), true, "blinkingCaret");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isBlockCursor(), false, "blockCaret");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isRightMarginShown(), true, "rightMargin");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isLineNumbersShown(), true, "lineNumbers");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.areGutterIconsShown(), true, "gutterIcons");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isFoldingOutlineShown(), true, "foldingOutline");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isWhitespacesShown() && es.isLeadingWhitespacesShown(), false, "showLeadingWhitespace");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isWhitespacesShown() && es.isInnerWhitespacesShown(), false, "showInnerWhitespace");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isWhitespacesShown() && es.isTrailingWhitespacesShown(), false, "showTrailingWhitespace");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isIndentGuidesShown(), true, "indentGuides");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isSmoothScrolling(), true, "animatedScroll");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isDndEnabled(), true, "dragNDrop");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isWheelFontChangeEnabled(), false, "wheelZoom");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isMouseClickSelectionHonorsCamelWords(), true, "mouseCamel");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isVariableInplaceRenameEnabled(), true, "inplaceRename");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isPreselectRename(), true, "preselectOnRename");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isShowInlineLocalDialog(), true, "inlineDialog");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isRefrainFromScrolling(), false, "minimizeScrolling");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.getOptions().SHOW_NOTIFICATION_AFTER_REFORMAT_CODE_ACTION, true, "afterReformatNotification");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.getOptions().SHOW_NOTIFICATION_AFTER_OPTIMIZE_IMPORTS_ACTION, true, "afterOptimizeNotification");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isSmartHome(), true, "smartHome");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isCamelWords(), false, "camelWords");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, es.isShowParameterNameHints(), true, "editor.inlay.parameter.hints");
        RichCopySettings rcs = RichCopySettings.getInstance();
        EditorSettingsStatisticsCollector.addIfDiffers(set2, rcs.isEnabled(), true, "richCopy");
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.AUTO_POPUP_PARAMETER_INFO, true, "parameterAutoPopup");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.AUTO_POPUP_JAVADOC_INFO, false, "javadocAutoPopup");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.AUTO_POPUP_COMPLETION_LOOKUP, true, "completionAutoPopup");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.COMPLETION_CASE_SENSITIVE, 3, "completionCaseSensitivity");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS, false, "autoPopupCharComplete");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.AUTOCOMPLETE_ON_CODE_COMPLETION, true, "autoCompleteBasic");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION, true, "autoCompleteSmart");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO, false, "parameterInfoFullSignature");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.getBackspaceMode(), SmartBackspaceMode.AUTOINDENT, "smartBackspace");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.SMART_INDENT_ON_ENTER, true, "indentOnEnter");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.INSERT_BRACE_ON_ENTER, true, "braceOnEnter");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.JAVADOC_STUB_ON_ENTER, true, "javadocOnEnter");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.SMART_END_ACTION, true, "smartEnd");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.JAVADOC_GENERATE_CLOSING_TAG, true, "autoCloseJavadocTags");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.SURROUND_SELECTION_ON_QUOTE_TYPED, false, "surroundByQuoteOrBrace");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.AUTOINSERT_PAIR_BRACKET, true, "pairBracketAutoInsert");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.AUTOINSERT_PAIR_QUOTE, true, "pairQuoteAutoInsert");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.REFORMAT_BLOCK_ON_RBRACE, true, "reformatOnRBrace");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.REFORMAT_ON_PASTE, 3, "reformatOnPaste");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.ADD_IMPORTS_ON_PASTE, 3, "importsOnPaste");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.HIGHLIGHT_BRACES, true, "bracesHighlight");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.HIGHLIGHT_SCOPE, false, "scopeHighlight");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.HIGHLIGHT_IDENTIFIER_UNDER_CARET, true, "identifierUnderCaretHighlight");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.OPTIMIZE_IMPORTS_ON_THE_FLY, false, "autoOptimizeImports");
        EditorSettingsStatisticsCollector.addIfDiffers(set2, cis.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY, false, "autoAddImports");
        HashSet<UsageDescriptor> hashSet = set2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector", "getUsages"));
        }
        return hashSet;
    }

    private static void addIfDiffers(Set<UsageDescriptor> set2, boolean value, boolean defaultValue, String featureId) {
        if (value != defaultValue) {
            set2.add(new UsageDescriptor(defaultValue ? "no" + StringUtil.capitalize((String)featureId) : featureId, 1));
        }
    }

    private static void addIfDiffers(Set<UsageDescriptor> set2, Object value, Object defaultValue, String featureIdPrefix) {
        if (!Comparing.equal((Object)value, (Object)defaultValue)) {
            set2.add(new UsageDescriptor(featureIdPrefix + "." + value, 1));
        }
    }
}

