/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.lineMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonLineMover
extends LineMover {
    private boolean myShouldAddComma = false;

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/json/editor/lineMover/JsonLineMover", "checkAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/json/editor/lineMover/JsonLineMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/json/editor/lineMover/JsonLineMover", "checkAvailable"));
        }
        this.myShouldAddComma = false;
        if (!(file2 instanceof JsonFile) || !super.checkAvailable(editor, file2, info, down)) {
            return false;
        }
        Pair<PsiElement, PsiElement> movedElementRange = JsonLineMover.getElementRange((Editor)editor, (PsiFile)file2, (LineRange)info.toMove);
        if (!this.isValidElementRange(movedElementRange)) {
            return false;
        }
        movedElementRange = this.expandCommentsInRange(movedElementRange);
        info.toMove = new LineRange((PsiElement)movedElementRange.getFirst(), (PsiElement)movedElementRange.getSecond());
        int lineCount = editor.getDocument().getLineCount();
        info.toMove2 = down ? new LineRange(info.toMove.endLine, Math.min(info.toMove.endLine + 1, lineCount)) : new LineRange(Math.max(info.toMove.startLine - 1, 0), info.toMove.startLine);
        if (movedElementRange.getFirst() instanceof PsiComment && movedElementRange.getSecond() instanceof PsiComment) {
            return true;
        }
        Pair destElementRange = JsonLineMover.getElementRange((Editor)editor, (PsiFile)file2, (LineRange)info.toMove2);
        if (this.isValidElementRange((Pair<PsiElement, PsiElement>)destElementRange) && ((PsiElement)movedElementRange.getFirst()).getParent() == ((PsiElement)destElementRange.getSecond()).getParent()) {
            PsiElement lowerRightElement;
            PsiElement commonParent = ((PsiElement)movedElementRange.getFirst()).getParent();
            PsiElement psiElement = lowerRightElement = down ? (PsiElement)destElementRange.getSecond() : (PsiElement)movedElementRange.getSecond();
            if (lowerRightElement instanceof JsonElement && (commonParent instanceof JsonArray && this.notFollowedByNextElementOrComma(lowerRightElement, JsonValue.class) || commonParent instanceof JsonObject && this.notFollowedByNextElementOrComma(lowerRightElement, JsonProperty.class))) {
                this.myShouldAddComma = true;
            }
        }
        return true;
    }

    @NotNull
    private Pair<PsiElement, PsiElement> expandCommentsInRange(@NotNull Pair<PsiElement, PsiElement> range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/json/editor/lineMover/JsonLineMover", "expandCommentsInRange"));
        }
        PsiElement upper = JsonPsiUtil.findFurthestSiblingOfSameType((PsiElement)range.getFirst(), false);
        PsiElement lower = JsonPsiUtil.findFurthestSiblingOfSameType((PsiElement)range.getSecond(), true);
        Pair pair = Pair.create((Object)upper, (Object)lower);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/editor/lineMover/JsonLineMover", "expandCommentsInRange"));
        }
        return pair;
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/json/editor/lineMover/JsonLineMover", "beforeMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/json/editor/lineMover/JsonLineMover", "beforeMove"));
        }
        if (this.myShouldAddComma) {
            Document document = editor.getDocument();
            int lineBelow = down ? info.toMove2.endLine - 1 : info.toMove.endLine - 1;
            document.insertString(document.getLineEndOffset(lineBelow), (CharSequence)",");
            int lineAbove = down ? info.toMove.endLine - 1 : info.toMove2.endLine - 1;
            int lineAboveEndOffset = document.getLineEndOffset(lineAbove);
            String aboveLineEnding = document.getText(new TextRange(lineAboveEndOffset - 1, lineAboveEndOffset));
            if (aboveLineEnding.equals(",")) {
                document.deleteString(lineAboveEndOffset - 1, lineAboveEndOffset);
            }
            Project project2 = editor.getProject();
            assert (project2 != null);
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        }
    }

    private boolean notFollowedByNextElementOrComma(@NotNull PsiElement anchor, @NotNull Class<? extends PsiElement> nextElementType) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/json/editor/lineMover/JsonLineMover", "notFollowedByNextElementOrComma"));
        }
        if (nextElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nextElementType", "com/intellij/json/editor/lineMover/JsonLineMover", "notFollowedByNextElementOrComma"));
        }
        return PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, nextElementType) == null && TreeUtil.findSibling(anchor.getNode(), JsonElementTypes.COMMA) == null;
    }

    private boolean isValidElementRange(@Nullable Pair<PsiElement, PsiElement> elementRange) {
        if (elementRange == null) {
            return false;
        }
        return ((PsiElement)elementRange.getFirst()).getParent() == ((PsiElement)elementRange.getSecond()).getParent();
    }
}

