/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonTrailingCommaRemover
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/formatter/JsonTrailingCommaRemover", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/json/formatter/JsonTrailingCommaRemover", "process"));
        }
        PsiElement rootPsi = element.getPsi();
        if (rootPsi.getLanguage() != JsonLanguage.INSTANCE) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonTrailingCommaRemover", "process"));
            }
            return textRange;
        }
        JsonCodeStyleSettings settings = (JsonCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)rootPsi.getProject()).getCurrentSettings().getCustomSettings(JsonCodeStyleSettings.class);
        if (!settings.REMOVE_TRAILING_COMMA) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonTrailingCommaRemover", "process"));
            }
            return textRange;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)rootPsi.getProject());
        Document document = psiDocumentManager.getDocument(rootPsi.getContainingFile());
        if (document == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonTrailingCommaRemover", "process"));
            }
            return textRange;
        }
        DocumentUtil.executeInBulk(document, true, () -> {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            Visitor visitor = new Visitor(document);
            rootPsi.accept((PsiElementVisitor)visitor);
            psiDocumentManager.commitDocument(document);
        });
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonTrailingCommaRemover", "process"));
        }
        return textRange;
    }

    private static class Visitor
    extends JsonRecursiveElementVisitor {
        private final Document myDocument;
        private int myOffsetDelta;

        public Visitor(Document document) {
            this.myDocument = document;
        }

        @Override
        public void visitArray(@NotNull JsonArray o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/json/formatter/JsonTrailingCommaRemover$Visitor", "visitArray"));
            }
            super.visitArray(o);
            Visitor.collectTrailingCommas(o).forEach(this::deleteNode);
        }

        @Override
        public void visitObject(@NotNull JsonObject o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/json/formatter/JsonTrailingCommaRemover$Visitor", "visitObject"));
            }
            super.visitObject(o);
            Visitor.collectTrailingCommas(o).forEach(this::deleteNode);
        }

        @NotNull
        private static Collection<ASTNode> collectTrailingCommas(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/formatter/JsonTrailingCommaRemover$Visitor", "collectTrailingCommas"));
            }
            ArrayList result2 = ContainerUtil.newArrayList();
            element = element.getLastChild();
            while (element != null) {
                if ((element = element.getPrevSibling()) != null && element.getNode().getElementType() == JsonElementTypes.COMMA || element instanceof PsiErrorElement && ",".equals(element.getText())) {
                    result2.add(element.getNode());
                    continue;
                }
                if (element instanceof PsiComment || element instanceof PsiWhiteSpace) continue;
            }
            List list = ContainerUtil.reverse((List)result2);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/formatter/JsonTrailingCommaRemover$Visitor", "collectTrailingCommas"));
            }
            return list;
        }

        private void deleteNode(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/formatter/JsonTrailingCommaRemover$Visitor", "deleteNode"));
            }
            int length = node.getTextLength();
            this.myDocument.deleteString(node.getStartOffset() + this.myOffsetDelta, node.getStartOffset() + length + this.myOffsetDelta);
            this.myOffsetDelta -= length;
        }
    }
}

