/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesEP;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ComponentTreeEventDispatcher;
import com.intellij.util.JdomKt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="EditorColorsManagerImpl", storages={@Storage(value="colors.scheme.xml")}, additionalExportFile="colors")
public class EditorColorsManagerImpl
extends EditorColorsManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(EditorColorsManagerImpl.class);
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledColorScheme");
    private final ComponentTreeEventDispatcher<EditorColorsListener> myTreeDispatcher;
    private final DefaultColorSchemesManager myDefaultColorSchemeManager;
    private final SchemeManager<EditorColorsScheme> mySchemeManager;
    static final String FILE_SPEC = "colors";
    private State myState;

    public EditorColorsManagerImpl(@NotNull DefaultColorSchemesManager defaultColorSchemeManager, @NotNull SchemeManagerFactory schemeManagerFactory) {
        if (defaultColorSchemeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultColorSchemeManager", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "<init>"));
        }
        if (schemeManagerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeManagerFactory", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "<init>"));
        }
        this.myTreeDispatcher = ComponentTreeEventDispatcher.create(EditorColorsListener.class);
        this.myState = new State();
        this.myDefaultColorSchemeManager = defaultColorSchemeManager;
        class EditorColorSchemeProcessor
        extends LazySchemeProcessor<EditorColorsScheme, EditorColorsSchemeImpl>
        implements SchemeExtensionProvider {
            EditorColorSchemeProcessor() {
            }

            @Override
            @NotNull
            public EditorColorsSchemeImpl createScheme(@NotNull SchemeDataHolder<? super EditorColorsSchemeImpl> dataHolder, @NotNull String name, @NotNull Function<String, String> attributeProvider2, boolean isBundled) {
                if (dataHolder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor", "createScheme"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor", "createScheme"));
                }
                if (attributeProvider2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeProvider", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor", "createScheme"));
                }
                EditorColorsSchemeImpl scheme2 = isBundled ? new BundledScheme() : new EditorColorsSchemeImpl(null);
                scheme2.readExternal(dataHolder.read());
                if (isBundled) {
                    scheme2.optimizeAttributeMap();
                }
                EditorColorsSchemeImpl editorColorsSchemeImpl = scheme2;
                if (editorColorsSchemeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor", "createScheme"));
                }
                return editorColorsSchemeImpl;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull EditorColorsScheme scheme2) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor", "getState"));
                }
                SchemeState schemeState = scheme2 instanceof ReadOnlyColorsScheme ? SchemeState.NON_PERSISTENT : SchemeState.POSSIBLY_CHANGED;
                if (schemeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor", "getState"));
                }
                return schemeState;
            }

            @Override
            public void onCurrentSchemeSwitched(@Nullable EditorColorsScheme oldScheme, @Nullable EditorColorsScheme newScheme) {
                LafManager.getInstance().updateUI();
                EditorColorsManagerImpl.this.schemeChangedOrSwitched(newScheme);
            }

            @Override
            @NotNull
            @NonNls
            public String getSchemeExtension() {
                if (".icls" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor", "getSchemeExtension"));
                }
                return ".icls";
            }

            @Override
            public boolean isSchemeEqualToBundled(@NotNull EditorColorsSchemeImpl scheme2) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor", "isSchemeEqualToBundled"));
                }
                if (!scheme2.getName().startsWith("_@user_")) {
                    return false;
                }
                AbstractColorsScheme bundledScheme = (AbstractColorsScheme)EditorColorsManagerImpl.this.mySchemeManager.findSchemeByName(scheme2.getName().substring("_@user_".length()));
                if (bundledScheme == null) {
                    return false;
                }
                return scheme2.settingsEqual(bundledScheme);
            }

            @Override
            public void reloaded(@NotNull SchemeManager<EditorColorsScheme> schemeManager2) {
                if (schemeManager2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeManager", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor", "reloaded"));
                }
                EditorColorsManagerImpl.this.initEditableDefaultSchemesCopies();
                EditorColorsManagerImpl.this.initEditableBundledSchemesCopies();
            }
        }
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, new EditorColorSchemeProcessor());
        this.initDefaultSchemes();
        this.loadBundledSchemes();
        this.mySchemeManager.loadSchemes();
        String wizardEditorScheme = WelcomeWizardUtil.getWizardEditorScheme();
        EditorColorsScheme scheme2 = null;
        if (wizardEditorScheme != null) {
            scheme2 = this.getScheme(wizardEditorScheme);
            LOG.assertTrue(scheme2 != null, (Object)("Wizard scheme " + wizardEditorScheme + " not found"));
        }
        this.initEditableDefaultSchemesCopies();
        this.initEditableBundledSchemesCopies();
        this.resolveLinksToBundledSchemes();
        this.setGlobalSchemeInner(scheme2 == null ? this.getDefaultScheme() : scheme2);
    }

    private void initDefaultSchemes() {
        for (DefaultColorsScheme defaultScheme : this.myDefaultColorSchemeManager.getAllSchemes()) {
            this.mySchemeManager.addScheme(defaultScheme);
        }
        this.loadAdditionalTextAttributes();
    }

    private void initEditableDefaultSchemesCopies() {
        for (DefaultColorsScheme defaultScheme : this.myDefaultColorSchemeManager.getAllSchemes()) {
            if (!defaultScheme.hasEditableCopy()) continue;
            this.createEditableCopy(defaultScheme, defaultScheme.getEditableCopyName());
        }
    }

    private void loadBundledSchemes() {
        if (!EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            for (BundledSchemeEP ep : (BundledSchemeEP[])BUNDLED_EP_NAME.getExtensions()) {
                this.mySchemeManager.loadBundledScheme(ep.getPath() + ".xml", (Object)ep);
            }
        }
    }

    private void initEditableBundledSchemesCopies() {
        for (EditorColorsScheme scheme2 : this.mySchemeManager.getAllSchemes()) {
            if (!(scheme2 instanceof BundledScheme)) continue;
            this.createEditableCopy((BundledScheme)scheme2, "_@user_" + scheme2.getName());
        }
    }

    private void resolveLinksToBundledSchemes() {
        for (EditorColorsScheme scheme2 : this.mySchemeManager.getAllSchemes()) {
            if (!(scheme2 instanceof AbstractColorsScheme) || scheme2 instanceof ReadOnlyColorsScheme) continue;
            ((AbstractColorsScheme)scheme2).resolveParent(name -> this.mySchemeManager.findSchemeByName((String)name));
        }
    }

    private void createEditableCopy(@NotNull AbstractColorsScheme initialScheme, @NotNull String editableCopyName) {
        if (initialScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialScheme", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "createEditableCopy"));
        }
        if (editableCopyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editableCopyName", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "createEditableCopy"));
        }
        AbstractColorsScheme editableCopy = (AbstractColorsScheme)this.getScheme(editableCopyName);
        if (editableCopy == null) {
            editableCopy = (AbstractColorsScheme)initialScheme.clone();
            editableCopy.setName(editableCopyName);
            this.mySchemeManager.addScheme(editableCopy);
        }
        editableCopy.setCanBeDeleted(false);
    }

    @Deprecated
    public static void schemeChangedOrSwitched() {
        EditorColorsManagerImpl manager = (EditorColorsManagerImpl)EditorColorsManagerImpl.getInstance();
        manager.schemeChangedOrSwitched(manager.getGlobalScheme());
    }

    public void schemeChangedOrSwitched(@Nullable EditorColorsScheme newScheme) {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        }
        ((EditorColorsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).globalSchemeChange(newScheme);
        ((EditorColorsListener)this.myTreeDispatcher.getMulticaster()).globalSchemeChange(newScheme);
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public TextAttributes getDefaultAttributes(TextAttributesKey key2) {
        boolean dark = UIUtil.isUnderDarcula() && this.getScheme("Darcula") != null;
        return this.getScheme(dark ? "Darcula" : "Default").getAttributes(key2);
    }

    private void loadAdditionalTextAttributes() {
        for (AdditionalTextAttributesEP attributesEP : (AdditionalTextAttributesEP[])AdditionalTextAttributesEP.EP_NAME.getExtensions()) {
            EditorColorsScheme editorColorsScheme = this.mySchemeManager.findSchemeByName(attributesEP.scheme);
            if (editorColorsScheme == null) {
                if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) continue;
                LOG.warn("Cannot find scheme: " + attributesEP.scheme + " from plugin: " + attributesEP.getPluginDescriptor().getPluginId());
                continue;
            }
            try {
                URL resource = attributesEP.getLoaderForClass().getResource(attributesEP.file);
                assert (resource != null);
                ((AbstractColorsScheme)editorColorsScheme).readAttributes(JdomKt.loadElement(URLUtil.openStream((URL)resource)));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void addColorsScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "addColorsScheme"));
        }
        if (!this.isDefaultScheme(scheme2) && !StringUtil.isEmpty((String)scheme2.getName())) {
            this.mySchemeManager.addScheme(scheme2);
        }
    }

    public void removeAllSchemes() {
    }

    public void setSchemes(@NotNull List<EditorColorsScheme> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "setSchemes"));
        }
        this.mySchemeManager.setSchemes(schemes);
    }

    @NotNull
    public EditorColorsScheme[] getAllSchemes() {
        EditorColorsScheme[] result2 = EditorColorsManagerImpl.getAllVisibleSchemes(this.mySchemeManager.getAllSchemes());
        Arrays.sort(result2, EditorColorSchemesComparator.INSTANCE);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getAllSchemes"));
        }
        return result2;
    }

    private static EditorColorsScheme[] getAllVisibleSchemes(@NotNull Collection<EditorColorsScheme> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getAllVisibleSchemes"));
        }
        ArrayList<EditorColorsScheme> visibleSchemes = new ArrayList<EditorColorsScheme>(schemes.size() - 1);
        for (EditorColorsScheme scheme2 : schemes) {
            if (!AbstractColorsScheme.isVisible(scheme2)) continue;
            visibleSchemes.add(scheme2);
        }
        return visibleSchemes.toArray(new EditorColorsScheme[visibleSchemes.size()]);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme2) {
        Application application = ApplicationManager.getApplication();
        boolean notify = application instanceof ApplicationImpl && ((ApplicationImpl)application).isLoaded();
        this.mySchemeManager.setCurrent(scheme2 == null ? this.getDefaultScheme() : scheme2, notify);
    }

    private void setGlobalSchemeInner(@Nullable EditorColorsScheme scheme2) {
        this.mySchemeManager.setCurrent(scheme2 == null ? this.getDefaultScheme() : scheme2, false);
    }

    @NotNull
    private EditorColorsScheme getDefaultScheme() {
        DefaultColorsScheme defaultScheme = this.myDefaultColorSchemeManager.getFirstScheme();
        String editableCopyName = defaultScheme.getEditableCopyName();
        EditorColorsScheme editableCopy = this.getScheme(editableCopyName);
        assert (editableCopy != null) : "An editable copy of " + defaultScheme.getName() + " has not been initialized.";
        EditorColorsScheme editorColorsScheme = editableCopy;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getDefaultScheme"));
        }
        return editorColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme editableCopy;
        EditorColorsScheme scheme2 = this.mySchemeManager.getCurrentScheme();
        String editableCopyName = null;
        if (scheme2 instanceof DefaultColorsScheme && ((DefaultColorsScheme)scheme2).hasEditableCopy()) {
            editableCopyName = ((DefaultColorsScheme)scheme2).getEditableCopyName();
        } else if (scheme2 instanceof BundledScheme) {
            editableCopyName = "_@user_" + scheme2.getName();
        }
        if (editableCopyName != null && (editableCopy = this.getScheme(editableCopyName)) != null) {
            EditorColorsScheme editorColorsScheme = editableCopy;
            if (editorColorsScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getGlobalScheme"));
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = scheme2 == null ? this.getDefaultScheme() : scheme2;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getGlobalScheme"));
        }
        return editorColorsScheme;
    }

    public EditorColorsScheme getScheme(@NotNull String schemeName) {
        if (schemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeName", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getScheme"));
        }
        return this.mySchemeManager.findSchemeByName(schemeName);
    }

    public void setUseOnlyMonospacedFonts(boolean value) {
        this.myState.USE_ONLY_MONOSPACED_FONTS = value;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.myState.USE_ONLY_MONOSPACED_FONTS;
    }

    @Nullable
    public State getState() {
        String currentSchemeName = this.mySchemeManager.getCurrentSchemeName();
        if (currentSchemeName != null) {
            this.myState.colorScheme = "Default".equals(currentSchemeName) || "_@user_Default".equals(currentSchemeName) ? null : currentSchemeName;
        }
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
        this.setGlobalSchemeInner(this.myState.colorScheme == null ? this.getDefaultScheme() : this.mySchemeManager.findSchemeByName(this.myState.colorScheme));
    }

    public boolean isDefaultScheme(EditorColorsScheme scheme2) {
        return scheme2 instanceof DefaultColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        EditorColorsScheme editableCopy;
        String schemeName = UIUtil.isUnderDarcula() ? "Darcula" : "Default";
        EditorColorsScheme scheme2 = this.myDefaultColorSchemeManager.getScheme(schemeName);
        assert (scheme2 != null) : "The default scheme '" + schemeName + "' not found, available schemes: " + Arrays.toString(this.myDefaultColorSchemeManager.listNames());
        if (((DefaultColorsScheme)scheme2).hasEditableCopy() && (editableCopy = this.getScheme(((DefaultColorsScheme)scheme2).getEditableCopyName())) != null) {
            EditorColorsScheme editorColorsScheme = editableCopy;
            if (editorColorsScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getSchemeForCurrentUITheme"));
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = scheme2;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getSchemeForCurrentUITheme"));
        }
        return editorColorsScheme;
    }

    @NotNull
    public SchemeManager<EditorColorsScheme> getSchemeManager() {
        SchemeManager<EditorColorsScheme> schemeManager2 = this.mySchemeManager;
        if (schemeManager2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getSchemeManager"));
        }
        return schemeManager2;
    }

    static class State {
        public boolean USE_ONLY_MONOSPACED_FONTS = true;
        @OptionTag(tag="global_color_scheme", nameAttribute="", valueAttribute="name")
        public String colorScheme;

        State() {
        }
    }

    static class BundledScheme
    extends EditorColorsSchemeImpl
    implements ReadOnlyColorsScheme {
        public BundledScheme() {
            super(null);
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }
}

