/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapHelper;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.EmptyClipboardOwner;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretImpl
extends UserDataHolderBase
implements Caret,
Dumpable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.CaretImpl");
    private static final Key<CaretVisualAttributes> VISUAL_ATTRIBUTES_KEY = new Key("CaretAttributes");
    private final EditorImpl myEditor;
    private boolean isValid = true;
    private LogicalPosition myLogicalCaret;
    private VerticalInfo myCaretInfo;
    private VisualPosition myVisibleCaret;
    private volatile PositionMarker myPositionMarker;
    private boolean myLeansTowardsLargerOffsets;
    private int myVirtualSpaceOffset;
    private int myVisualLineStart;
    private int myVisualLineEnd;
    private boolean mySkipChangeRequests;
    private int myLastColumnNumber = 0;
    private int myDesiredSelectionStartColumn = -1;
    private int myDesiredSelectionEndColumn = -1;
    private boolean myReportCaretMoves;
    private int myDesiredX = -1;
    private volatile SelectionMarker mySelectionMarker;
    private volatile VisualPosition myRangeMarkerStartPosition;
    private volatile VisualPosition myRangeMarkerEndPosition;
    private volatile boolean myRangeMarkerEndPositionIsLead;
    boolean myUnknownDirection;
    private int myDocumentUpdateCounter;

    CaretImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myLogicalCaret = new LogicalPosition(0, 0);
        this.myVisibleCaret = new VisualPosition(0, 0);
        this.myCaretInfo = new VerticalInfo(0, 0);
        this.myPositionMarker = new PositionMarker(0);
        this.myVisualLineStart = 0;
        DocumentEx doc = this.myEditor.getDocument();
        this.myVisualLineEnd = doc.getLineCount() > 1 ? doc.getLineStartOffset(1) : (doc.getLineCount() == 0 ? 0 : doc.getLineEndOffset(0));
        this.myDocumentUpdateCounter = editor.getCaretModel().myDocumentUpdateCounter;
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        CaretImpl.assertIsDispatchThread();
        this.validateCallContext();
        if (this.mySkipChangeRequests) {
            return;
        }
        this.myEditor.getCaretModel().doWithCaretMerging(() -> {
            LogicalPosition logicalPosition = this.myEditor.offsetToLogicalPosition(offset);
            CaretEvent event = this.moveToLogicalPosition(logicalPosition, locateBeforeSoftWrap, null, false);
            LogicalPosition positionByOffsetAfterMove = this.myEditor.offsetToLogicalPosition(this.getOffset());
            if (!positionByOffsetAfterMove.equals((Object)logicalPosition)) {
                StringBuilder debugBuffer = new StringBuilder();
                this.moveToLogicalPosition(logicalPosition, locateBeforeSoftWrap, debugBuffer, true);
                int actualOffset = this.getOffset();
                int textStart = Math.max(0, Math.min(offset, actualOffset) - 1);
                DocumentEx document = this.myEditor.getDocument();
                int textEnd = Math.min(document.getTextLength() - 1, Math.max(offset, actualOffset) + 1);
                CharSequence text = document.getCharsSequence().subSequence(textStart, textEnd);
                int inverseOffset = this.myEditor.logicalPositionToOffset(logicalPosition);
                LogMessageEx.error(LOG, "caret moved to wrong offset. Please submit a dedicated ticket and attach current editor's text to it.", "Requested: offset=" + offset + ", logical position='" + logicalPosition + "' but actual: offset=" + actualOffset + ", logical position='" + this.myLogicalCaret + "' (" + positionByOffsetAfterMove + "). " + this.myEditor.dumpState() + "\ninterested text [" + textStart + ";" + textEnd + "): '" + text + "'\n debug trace: " + debugBuffer + "\nLogical position -> offset ('" + logicalPosition + "'->'" + inverseOffset + "')");
            }
            if (event != null) {
                this.myEditor.getCaretModel().fireCaretPositionChanged(event);
                EditorActionUtil.selectNonexpandableFold(this.myEditor);
            }
        });
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModelImpl caretModelImpl = this.myEditor.getCaretModel();
        if (caretModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getCaretModel"));
        }
        return caretModelImpl;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void moveCaretRelatively(int _columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        CaretImpl.assertIsDispatchThread();
        if (this.mySkipChangeRequests) {
            return;
        }
        if (this.myReportCaretMoves) {
            LogMessageEx.error(LOG, "Unexpected caret move request", new String[0]);
        }
        if (!this.myEditor.isStickySelection() && !this.myEditor.getDocument().isInEventsHandling()) {
            CopyPasteManager.getInstance().stopKillRings();
        }
        this.myEditor.getCaretModel().doWithCaretMerging(() -> {
            boolean newLeansRight;
            this.updateCachedStateIfNeeded();
            int oldOffset = this.getOffset();
            int columnShift = _columnShift;
            if (withSelection && lineShift == 0) {
                if (columnShift == -1) {
                    int column = this.myVisibleCaret.column - (this.hasSelection() && oldOffset == this.getSelectionEnd() ? 2 : 1);
                    if (column >= 0 && this.myEditor.getInlayModel().hasInlineElementAt(new VisualPosition(this.myVisibleCaret.line, column))) {
                        columnShift = -2;
                    }
                } else if (columnShift == 1 && this.myEditor.getInlayModel().hasInlineElementAt(new VisualPosition(this.myVisibleCaret.line, this.myVisibleCaret.column + (this.hasSelection() && oldOffset == this.getSelectionStart() ? 1 : 0)))) {
                    columnShift = 2;
                }
            }
            int leadSelectionOffset = this.getLeadSelectionOffset();
            VisualPosition leadSelectionPosition = this.getLeadSelectionPosition();
            EditorSettings editorSettings = this.myEditor.getSettings();
            VisualPosition visualCaret = this.getVisualPosition();
            int lastColumnNumber = this.myLastColumnNumber;
            int desiredX = this.myDesiredX;
            if (columnShift == 0) {
                if (this.myDesiredX < 0) {
                    desiredX = this.getCurrentX();
                }
            } else {
                desiredX = -1;
                this.myDesiredX = -1;
            }
            int newLineNumber = visualCaret.line + lineShift;
            int newColumnNumber = visualCaret.column + columnShift;
            boolean bl = lineShift == 0 && columnShift != 0 ? columnShift < 0 : (newLeansRight = visualCaret.leansRight);
            if (desiredX >= 0) {
                newColumnNumber = this.myEditor.xyToVisualPosition((Point)new Point((int)desiredX, (int)(Math.max((int)0, (int)newLineNumber) * this.myEditor.getLineHeight()))).column;
            }
            DocumentEx document = this.myEditor.getDocument();
            if (!editorSettings.isVirtualSpace() && lineShift == 0 && columnShift == 1) {
                int lastLine = document.getLineCount() - 1;
                if (lastLine < 0) {
                    lastLine = 0;
                }
                if (newColumnNumber > EditorUtil.getLastVisualLineColumnNumber(this.myEditor, newLineNumber) && newLineNumber < this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)lastLine, (int)0)).line) {
                    newColumnNumber = 0;
                    ++newLineNumber;
                }
            } else if (!editorSettings.isVirtualSpace() && lineShift == 0 && columnShift == -1 && newColumnNumber < 0 && newLineNumber > 0) {
                newColumnNumber = EditorUtil.getLastVisualLineColumnNumber(this.myEditor, --newLineNumber);
            }
            if (newColumnNumber < 0) {
                newColumnNumber = 0;
            }
            boolean selectToDocumentStart = false;
            if (newLineNumber < 0) {
                selectToDocumentStart = true;
                newLineNumber = 0;
                newColumnNumber = 0;
            }
            VisualPosition pos = new VisualPosition(newLineNumber, newColumnNumber);
            if (!this.myEditor.getSoftWrapModel().isInsideSoftWrap(pos)) {
                int lastOffsetColumn;
                LogicalPosition log = this.myEditor.visualToLogicalPosition(new VisualPosition(newLineNumber, newColumnNumber, newLeansRight));
                int offset = this.myEditor.logicalPositionToOffset(log);
                if (offset >= document.getTextLength() && columnShift == 0 && (lastOffsetColumn = this.myEditor.offsetToVisualPosition((int)document.getTextLength(), (boolean)true, (boolean)false).column) > newColumnNumber) {
                    newColumnNumber = lastOffsetColumn;
                    newLeansRight = true;
                }
                if (!editorSettings.isCaretInsideTabs()) {
                    CharSequence text = document.getCharsSequence();
                    if (offset >= 0 && offset < document.getTextLength() && text.charAt(offset) == '\t' && (columnShift <= 0 || offset == oldOffset)) {
                        SoftWrap softWrap;
                        newColumnNumber = columnShift <= 0 ? this.myEditor.offsetToVisualPosition((int)offset, (boolean)true, (boolean)false).column : ((softWrap = this.myEditor.getSoftWrapModel().getSoftWrap(offset + 1)) == null ? this.myEditor.offsetToVisualPosition((int)(offset + 1)).column : EditorUtil.getLastVisualLineColumnNumber(this.myEditor, newLineNumber));
                    }
                }
            }
            pos = new VisualPosition(newLineNumber, newColumnNumber, newLeansRight);
            if (columnShift != 0 && lineShift == 0 && this.myEditor.getSoftWrapModel().isInsideSoftWrap(pos)) {
                LogicalPosition logical = this.myEditor.visualToLogicalPosition(pos);
                int softWrapOffset = this.myEditor.logicalPositionToOffset(logical);
                if (columnShift >= 0) {
                    this.moveToOffset(softWrapOffset);
                } else {
                    int line = this.myEditor.offsetToVisualLine(softWrapOffset - 1);
                    this.moveToVisualPosition(new VisualPosition(line, EditorUtil.getLastVisualLineColumnNumber(this.myEditor, line)));
                }
            } else {
                this.moveToVisualPosition(pos);
                if (!editorSettings.isVirtualSpace() && columnShift == 0 && lastColumnNumber >= 0) {
                    this.setLastColumnNumber(lastColumnNumber);
                }
            }
            if (withSelection) {
                if (selectToDocumentStart) {
                    this.setSelection(leadSelectionPosition, leadSelectionOffset, this.myEditor.offsetToVisualPosition(0), 0);
                } else if (pos.line >= this.myEditor.getVisibleLineCount()) {
                    int endOffset = document.getTextLength();
                    if (leadSelectionOffset < endOffset) {
                        this.setSelection(leadSelectionPosition, leadSelectionOffset, this.myEditor.offsetToVisualPosition(endOffset), endOffset);
                    }
                } else {
                    int selectionStartToUse = leadSelectionOffset;
                    VisualPosition selectionStartPositionToUse = leadSelectionPosition;
                    if (this.isUnknownDirection() || oldOffset > this.getSelectionStart() && oldOffset < this.getSelectionEnd()) {
                        if (this.getOffset() > leadSelectionOffset ^ this.getSelectionStart() < this.getSelectionEnd()) {
                            selectionStartToUse = this.getSelectionEnd();
                            selectionStartPositionToUse = this.getSelectionEndPosition();
                        } else {
                            selectionStartToUse = this.getSelectionStart();
                            selectionStartPositionToUse = this.getSelectionStartPosition();
                        }
                    }
                    this.setSelection(selectionStartPositionToUse, selectionStartToUse, this.getVisualPosition(), this.getOffset());
                }
            } else {
                this.removeSelection();
            }
            if (scrollToCaret) {
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
            if (desiredX >= 0) {
                this.myDesiredX = desiredX;
            }
            EditorActionUtil.selectNonexpandableFold(this.myEditor);
        });
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "moveToLogicalPosition"));
        }
        this.myEditor.getCaretModel().doWithCaretMerging(() -> {
            if (pos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "lambda$moveToLogicalPosition$2"));
            }
            this.moveToLogicalPosition(pos, false, null, true);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaretEvent doMoveToLogicalPosition(@NotNull LogicalPosition pos, boolean locateBeforeSoftWrap, @NonNls @Nullable StringBuilder debugBuffer, boolean fireListeners) {
        int lineToUse;
        FoldRegion collapsedAt;
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "doMoveToLogicalPosition"));
        }
        CaretImpl.assertIsDispatchThread();
        this.updateCachedStateIfNeeded();
        if (debugBuffer != null) {
            debugBuffer.append("Start moveToLogicalPosition(). Locate before soft wrap: ").append(locateBeforeSoftWrap).append(", position: ").append(pos).append("\n");
        }
        this.myDesiredX = -1;
        this.validateCallContext();
        int column = pos.column;
        int line = pos.line;
        int softWrapLinesBefore = pos.softWrapLinesBeforeCurrentLogicalLine;
        int softWrapLinesCurrent = pos.softWrapLinesOnCurrentLogicalLine;
        int softWrapColumns = pos.softWrapColumnDiff;
        boolean leansForward = pos.leansForward;
        boolean leansRight = pos.visualPositionLeansRight;
        DocumentEx doc = this.myEditor.getDocument();
        int lineCount = doc.getLineCount();
        if (lineCount == 0) {
            if (debugBuffer != null) {
                debugBuffer.append("Resetting target logical line to zero as the document is empty\n");
            }
            line = 0;
        } else if (line > lineCount - 1) {
            if (debugBuffer != null) {
                debugBuffer.append("Resetting target logical line (").append(line).append(") to ").append(lineCount - 1).append(" as it is greater than total document lines number\n");
            }
            line = lineCount - 1;
            softWrapLinesBefore = 0;
            softWrapLinesCurrent = 0;
        }
        EditorSettings editorSettings = this.myEditor.getSettings();
        if (!editorSettings.isVirtualSpace() && line < lineCount) {
            int lineEndOffset = doc.getLineEndOffset(line);
            LogicalPosition endLinePosition = this.myEditor.offsetToLogicalPosition(lineEndOffset);
            int lineEndColumnNumber = endLinePosition.column;
            if (column > lineEndColumnNumber) {
                int oldColumn = column;
                column = lineEndColumnNumber;
                leansForward = true;
                leansRight = true;
                if (softWrapColumns != 0) {
                    softWrapColumns -= column - lineEndColumnNumber;
                }
                if (debugBuffer != null) {
                    debugBuffer.append("Resetting target logical column (").append(oldColumn).append(") to ").append(lineEndColumnNumber).append(" because caret is not allowed to be located after line end (offset: ").append(lineEndOffset).append(", ").append("logical position: ").append(endLinePosition).append("). Current soft wrap columns value: ").append(softWrapColumns).append("\n");
                }
            }
        }
        this.myEditor.getFoldingModel().flushCaretPosition(this);
        VerticalInfo oldInfo = this.myCaretInfo;
        LogicalPosition oldCaretPosition = this.myLogicalCaret;
        VisualPosition oldVisualPosition = this.myVisibleCaret;
        LogicalPosition logicalPositionToUse = pos.visualPositionAware ? new LogicalPosition(line, column, softWrapLinesBefore, softWrapLinesCurrent, softWrapColumns, pos.foldedLines, pos.foldingColumnDiff, leansForward, leansRight) : new LogicalPosition(line, column, leansForward);
        int offset = this.myEditor.logicalPositionToOffset(logicalPositionToUse);
        if (debugBuffer != null) {
            debugBuffer.append("Resulting logical position to use: ").append(logicalPositionToUse).append(". It's mapped to offset ").append(offset).append("\n");
        }
        if ((collapsedAt = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(offset)) != null && offset > collapsedAt.getStartOffset()) {
            if (debugBuffer != null) {
                debugBuffer.append("Scheduling expansion of fold region ").append(collapsedAt).append("\n");
            }
            Runnable runnable2 = () -> {
                FoldRegion[] allCollapsedAt;
                for (FoldRegion foldRange : allCollapsedAt = this.myEditor.getFoldingModel().fetchCollapsedAt(offset)) {
                    foldRange.setExpanded(true);
                }
            };
            this.mySkipChangeRequests = true;
            try {
                this.myEditor.getFoldingModel().runBatchFoldingOperation(runnable2, false);
            }
            finally {
                this.mySkipChangeRequests = false;
            }
            logicalPositionToUse = logicalPositionToUse.visualPositionAware ? logicalPositionToUse.withoutVisualPositionInfo() : logicalPositionToUse;
        }
        this.setCurrentLogicalCaret(logicalPositionToUse);
        this.setLastColumnNumber(this.myLogicalCaret.column);
        this.myDesiredSelectionEndColumn = -1;
        this.myDesiredSelectionStartColumn = -1;
        this.myVisibleCaret = this.myEditor.logicalToVisualPosition(this.myLogicalCaret);
        this.updateOffsetsFromLogicalPosition();
        int newOffset = this.getOffset();
        if (debugBuffer != null) {
            debugBuffer.append("Storing offset ").append(newOffset).append(" (mapped from logical position ").append(this.myLogicalCaret).append(")\n");
        }
        this.updateVisualLineInfo();
        this.myEditor.updateCaretCursor();
        this.requestRepaint(oldInfo);
        if (locateBeforeSoftWrap && SoftWrapHelper.isCaretAfterSoftWrap(this) && (lineToUse = this.myVisibleCaret.line - 1) >= 0) {
            LogicalPosition logicalPosition;
            int tmpOffset;
            VisualPosition visualPosition = new VisualPosition(lineToUse, EditorUtil.getLastVisualLineColumnNumber(this.myEditor, lineToUse));
            if (debugBuffer != null) {
                debugBuffer.append("Adjusting caret position by moving it before soft wrap. Moving to visual position ").append(visualPosition).append("\n");
            }
            if ((tmpOffset = this.myEditor.logicalPositionToOffset(logicalPosition = this.myEditor.visualToLogicalPosition(visualPosition))) == newOffset) {
                boolean restore = this.myReportCaretMoves;
                this.myReportCaretMoves = false;
                try {
                    this.moveToVisualPosition(visualPosition);
                    CaretEvent caretEvent = null;
                    return caretEvent;
                }
                finally {
                    this.myReportCaretMoves = restore;
                }
            }
            LogMessageEx.error(LOG, "Invalid editor dimension mapping", "Expected to map visual position '" + visualPosition + "' to offset " + newOffset + " but got the following: -> logical position '" + logicalPosition + "'; -> offset " + tmpOffset + ". State: " + this.myEditor.dumpState());
        }
        if (!oldVisualPosition.equals((Object)this.myVisibleCaret)) {
            CaretEvent event = new CaretEvent((Editor)this.myEditor, (Caret)this, oldCaretPosition, this.myLogicalCaret);
            if (fireListeners) {
                this.myEditor.getCaretModel().fireCaretPositionChanged(event);
            } else {
                return event;
            }
        }
        return null;
    }

    private void updateOffsetsFromLogicalPosition() {
        int offset = this.myEditor.logicalPositionToOffset(this.myLogicalCaret);
        this.myPositionMarker = new PositionMarker(offset);
        this.myLeansTowardsLargerOffsets = this.myLogicalCaret.leansForward;
        this.myVirtualSpaceOffset = this.myLogicalCaret.column - this.myEditor.offsetToLogicalPosition((int)offset).column;
    }

    private void setLastColumnNumber(int lastColumnNumber) {
        this.myLastColumnNumber = lastColumnNumber;
    }

    private void requestRepaint(VerticalInfo oldCaretInfo) {
        int lineHeight = this.myEditor.getLineHeight();
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        EditorGutterComponentImpl gutter = this.myEditor.getGutterComponentEx();
        EditorComponentImpl content = this.myEditor.getContentComponent();
        int updateWidth = this.myEditor.getScrollPane().getHorizontalScrollBar().getValue() + visibleArea.width;
        if (Math.abs(this.myCaretInfo.y - oldCaretInfo.y) <= 2 * lineHeight) {
            int minY = Math.min(oldCaretInfo.y, this.myCaretInfo.y);
            int maxY = Math.max(oldCaretInfo.y + oldCaretInfo.height, this.myCaretInfo.y + this.myCaretInfo.height);
            content.repaintEditorComponent(0, minY, updateWidth, maxY - minY);
            gutter.repaint(0, minY, gutter.getWidth(), maxY - minY);
        } else {
            content.repaintEditorComponent(0, oldCaretInfo.y, updateWidth, oldCaretInfo.height + lineHeight);
            gutter.repaint(0, oldCaretInfo.y, updateWidth, oldCaretInfo.height + lineHeight);
            content.repaintEditorComponent(0, this.myCaretInfo.y, updateWidth, this.myCaretInfo.height + lineHeight);
            gutter.repaint(0, this.myCaretInfo.y, updateWidth, this.myCaretInfo.height + lineHeight);
        }
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "moveToVisualPosition"));
        }
        this.myEditor.getCaretModel().doWithCaretMerging(() -> {
            if (pos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "lambda$moveToVisualPosition$4"));
            }
            this.moveToVisualPosition(pos, true);
        });
    }

    void moveToVisualPosition(@NotNull VisualPosition pos, boolean fireListeners) {
        int lineEndColumn;
        EditorSettings editorSettings;
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "moveToVisualPosition"));
        }
        CaretImpl.assertIsDispatchThread();
        this.validateCallContext();
        if (this.mySkipChangeRequests) {
            return;
        }
        if (this.myReportCaretMoves) {
            LogMessageEx.error(LOG, "Unexpected caret move request", new String[0]);
        }
        if (!(this.myEditor.isStickySelection() || this.myEditor.getDocument().isInEventsHandling() || pos.equals((Object)this.myVisibleCaret))) {
            CopyPasteManager.getInstance().stopKillRings();
        }
        this.updateCachedStateIfNeeded();
        this.myDesiredX = -1;
        int column = pos.column;
        int line = pos.line;
        boolean leanRight = pos.leansRight;
        int lastLine = this.myEditor.getVisibleLineCount() - 1;
        if (lastLine <= 0) {
            lastLine = 0;
        }
        if (line > lastLine) {
            line = lastLine;
        }
        if (!(editorSettings = this.myEditor.getSettings()).isVirtualSpace() && column > (lineEndColumn = EditorUtil.getLastVisualLineColumnNumber(this.myEditor, line)) && !this.myEditor.getSoftWrapModel().isInsideSoftWrap(pos)) {
            column = lineEndColumn;
            leanRight = true;
        }
        this.myVisibleCaret = new VisualPosition(line, column, leanRight);
        VerticalInfo oldInfo = this.myCaretInfo;
        LogicalPosition oldPosition = this.myLogicalCaret;
        this.setCurrentLogicalCaret(this.myEditor.visualToLogicalPosition(this.myVisibleCaret));
        this.updateOffsetsFromLogicalPosition();
        this.updateVisualLineInfo();
        this.myEditor.getFoldingModel().flushCaretPosition(this);
        this.setLastColumnNumber(this.myLogicalCaret.column);
        this.myDesiredSelectionEndColumn = -1;
        this.myDesiredSelectionStartColumn = -1;
        this.myEditor.updateCaretCursor();
        this.requestRepaint(oldInfo);
        if (fireListeners && !oldPosition.equals((Object)this.myLogicalCaret)) {
            CaretEvent event = new CaretEvent((Editor)this.myEditor, (Caret)this, oldPosition, this.myLogicalCaret);
            this.myEditor.getCaretModel().fireCaretPositionChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CaretEvent moveToLogicalPosition(@NotNull LogicalPosition pos, boolean locateBeforeSoftWrap, @Nullable StringBuilder debugBuffer, boolean fireListeners) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretImpl", "moveToLogicalPosition"));
        }
        if (this.mySkipChangeRequests) {
            return null;
        }
        if (this.myReportCaretMoves) {
            LogMessageEx.error(LOG, "Unexpected caret move request", new String[0]);
        }
        if (!(this.myEditor.isStickySelection() || this.myEditor.getDocument().isInEventsHandling() || pos.equals((Object)this.myLogicalCaret))) {
            CopyPasteManager.getInstance().stopKillRings();
        }
        this.myReportCaretMoves = true;
        try {
            CaretEvent caretEvent = this.doMoveToLogicalPosition(pos, locateBeforeSoftWrap, debugBuffer, fireListeners);
            return caretEvent;
        }
        finally {
            this.myReportCaretMoves = false;
        }
    }

    private static void assertIsDispatchThread() {
        EditorImpl.assertIsDispatchThread();
    }

    private void validateCallContext() {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread() || !this.myEditor.getCaretModel().myIsInUpdate, (Object)"Caret model is in its update process. All requests are illegal at this point.");
    }

    public void dispose() {
        if (this.myPositionMarker != null) {
            this.myPositionMarker = null;
        }
        if (this.mySelectionMarker != null) {
            this.mySelectionMarker = null;
        }
        this.isValid = false;
    }

    public boolean isUpToDate() {
        return !this.myEditor.getCaretModel().myIsInUpdate && !this.myReportCaretMoves;
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        this.validateCallContext();
        this.updateCachedStateIfNeeded();
        LogicalPosition logicalPosition = this.myLogicalCaret;
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        this.validateCallContext();
        this.updateCachedStateIfNeeded();
        VisualPosition visualPosition = this.myVisibleCaret;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getVisualPosition"));
        }
        return visualPosition;
    }

    public int getOffset() {
        this.validateCallContext();
        CaretImpl.validateContext(false);
        PositionMarker marker = this.myPositionMarker;
        if (marker == null) {
            return 0;
        }
        assert (marker.isValid());
        return marker.getStartOffset();
    }

    public int getVisualLineStart() {
        this.updateCachedStateIfNeeded();
        return this.myVisualLineStart;
    }

    public int getVisualLineEnd() {
        this.updateCachedStateIfNeeded();
        return this.myVisualLineEnd;
    }

    @NotNull
    private VerticalInfo createVerticalInfo(LogicalPosition position) {
        int lineHeight;
        int logicalLine = position.line;
        DocumentEx document = this.myEditor.getDocument();
        if (logicalLine >= document.getLineCount()) {
            logicalLine = Math.max(0, document.getLineCount() - 1);
        }
        int startOffset = document.getLineStartOffset(logicalLine);
        int endOffset = document.getLineEndOffset(logicalLine);
        int visualLine = this.myEditor.offsetToVisualLine(document.getLineStartOffset(logicalLine));
        int y = this.myEditor.visibleLineToY(visualLine);
        int height = lineHeight = this.myEditor.getLineHeight();
        List<? extends SoftWrap> softWraps = this.myEditor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffset);
        for (SoftWrap softWrap : softWraps) {
            height += StringUtil.countNewLines((CharSequence)softWrap.getText()) * lineHeight;
        }
        VerticalInfo verticalInfo = new VerticalInfo(y, height);
        if (verticalInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "createVerticalInfo"));
        }
        return verticalInfo;
    }

    void updateVisualPosition() {
        this.updateCachedStateIfNeeded();
        VerticalInfo oldInfo = this.myCaretInfo;
        LogicalPosition visUnawarePos = new LogicalPosition(this.myLogicalCaret.line, this.myLogicalCaret.column, this.myLogicalCaret.leansForward);
        this.setCurrentLogicalCaret(visUnawarePos);
        this.myVisibleCaret = this.myEditor.logicalToVisualPosition(this.myLogicalCaret);
        this.updateVisualLineInfo();
        this.myEditor.updateCaretCursor();
        this.requestRepaint(oldInfo);
    }

    private void updateVisualLineInfo() {
        this.myVisualLineStart = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line, 0)));
        this.myVisualLineEnd = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line + 1, 0)));
    }

    void onInlayAdded(int offset) {
        this.updateCachedStateIfNeeded();
        int currentOffset = this.getOffset();
        if (offset == currentOffset && this.myLogicalCaret.leansForward) {
            VisualPosition pos = this.myEditor.offsetToVisualPosition(currentOffset, true, false);
            this.moveToVisualPosition(pos);
        } else {
            this.updateVisualPosition();
        }
    }

    private void setCurrentLogicalCaret(@NotNull LogicalPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/CaretImpl", "setCurrentLogicalCaret"));
        }
        this.myLogicalCaret = position;
        this.myCaretInfo = this.createVerticalInfo(position);
    }

    int getWordAtCaretStart() {
        int newOffset;
        DocumentEx document = this.myEditor.getDocument();
        int offset = this.getOffset();
        if (offset == 0) {
            return 0;
        }
        int lineNumber = this.getLogicalPosition().line;
        int minOffset = lineNumber > 0 ? document.getLineEndOffset(lineNumber - 1) : 0;
        boolean camel = this.myEditor.getSettings().isCamelWords();
        for (newOffset = offset - 1; newOffset > minOffset && !EditorActionUtil.isWordOrLexemeStart(this.myEditor, newOffset, camel); --newOffset) {
        }
        return newOffset;
    }

    int getWordAtCaretEnd() {
        DocumentEx document = this.myEditor.getDocument();
        int offset = this.getOffset();
        if (offset >= document.getTextLength() - 1 || document.getLineCount() == 0) {
            return offset;
        }
        int newOffset = offset + 1;
        int lineNumber = this.getLogicalPosition().line;
        int maxOffset = document.getLineEndOffset(lineNumber);
        if (newOffset > maxOffset) {
            if (lineNumber + 1 >= document.getLineCount()) {
                return offset;
            }
            maxOffset = document.getLineEndOffset(lineNumber + 1);
        }
        boolean camel = this.myEditor.getSettings().isCamelWords();
        while (newOffset < maxOffset && !EditorActionUtil.isWordOrLexemeEnd(this.myEditor, newOffset, camel)) {
            ++newOffset;
        }
        return newOffset;
    }

    private CaretImpl cloneWithoutSelection() {
        this.updateCachedStateIfNeeded();
        CaretImpl clone = new CaretImpl(this.myEditor);
        clone.myLogicalCaret = this.myLogicalCaret;
        clone.myCaretInfo = this.myCaretInfo;
        clone.myVisibleCaret = this.myVisibleCaret;
        clone.myPositionMarker = new PositionMarker(this.getOffset());
        clone.myLeansTowardsLargerOffsets = this.myLeansTowardsLargerOffsets;
        clone.myVirtualSpaceOffset = this.myVirtualSpaceOffset;
        clone.myVisualLineStart = this.myVisualLineStart;
        clone.myVisualLineEnd = this.myVisualLineEnd;
        clone.mySkipChangeRequests = this.mySkipChangeRequests;
        clone.myLastColumnNumber = this.myLastColumnNumber;
        clone.myReportCaretMoves = this.myReportCaretMoves;
        clone.myDesiredX = this.myDesiredX;
        clone.myDesiredSelectionStartColumn = -1;
        clone.myDesiredSelectionEndColumn = -1;
        return clone;
    }

    @Nullable
    public Caret clone(boolean above) {
        boolean hasNewSelection;
        VisualPosition newSelectionEndPosition;
        VisualPosition newSelectionStartPosition;
        int newSelectionEndOffset;
        int newSelectionStartOffset;
        int newSelectionEndColumn;
        int newSelectionStartColumn;
        CaretImpl.assertIsDispatchThread();
        int lineShift = above ? -1 : 1;
        LogicalPosition oldPosition = this.getLogicalPosition();
        int newLine = oldPosition.line + lineShift;
        if (newLine < 0 || newLine >= this.myEditor.getDocument().getLineCount()) {
            return null;
        }
        CaretImpl clone = this.cloneWithoutSelection();
        if (this.hasSelection() || this.myDesiredSelectionStartColumn >= 0 || this.myDesiredSelectionEndColumn >= 0) {
            VisualPosition startPosition = this.getSelectionStartPosition();
            VisualPosition endPosition = this.getSelectionEndPosition();
            VisualPosition leadPosition = this.getLeadSelectionPosition();
            boolean leadIsStart = leadPosition.equals((Object)startPosition);
            boolean leadIsEnd = leadPosition.equals((Object)endPosition);
            LogicalPosition selectionStart = this.myEditor.visualToLogicalPosition(leadIsStart || leadIsEnd ? leadPosition : startPosition);
            LogicalPosition selectionEnd = this.myEditor.visualToLogicalPosition(leadIsEnd ? startPosition : endPosition);
            newSelectionStartColumn = this.myDesiredSelectionStartColumn < 0 ? selectionStart.column : this.myDesiredSelectionStartColumn;
            newSelectionEndColumn = this.myDesiredSelectionEndColumn < 0 ? selectionEnd.column : this.myDesiredSelectionEndColumn;
            LogicalPosition newSelectionStart = this.truncate(selectionStart.line + lineShift, newSelectionStartColumn);
            LogicalPosition newSelectionEnd = this.truncate(selectionEnd.line + lineShift, newSelectionEndColumn);
            newSelectionStartOffset = this.myEditor.logicalPositionToOffset(newSelectionStart);
            newSelectionEndOffset = this.myEditor.logicalPositionToOffset(newSelectionEnd);
            newSelectionStartPosition = this.myEditor.logicalToVisualPosition(newSelectionStart);
            newSelectionEndPosition = this.myEditor.logicalToVisualPosition(newSelectionEnd);
            hasNewSelection = !newSelectionStart.equals((Object)newSelectionEnd);
        } else {
            newSelectionStartOffset = 0;
            newSelectionEndOffset = 0;
            newSelectionStartPosition = null;
            newSelectionEndPosition = null;
            hasNewSelection = false;
            newSelectionStartColumn = -1;
            newSelectionEndColumn = -1;
        }
        clone.moveToLogicalPosition(new LogicalPosition(newLine, this.myLastColumnNumber), false, null, false);
        clone.myLastColumnNumber = this.myLastColumnNumber;
        clone.myDesiredX = this.myDesiredX >= 0 ? this.myDesiredX : this.getCurrentX();
        clone.myDesiredSelectionStartColumn = newSelectionStartColumn;
        clone.myDesiredSelectionEndColumn = newSelectionEndColumn;
        if (this.myEditor.getCaretModel().addCaret(clone, true)) {
            if (hasNewSelection) {
                this.myEditor.getCaretModel().doWithCaretMerging(() -> clone.setSelection(newSelectionStartPosition, newSelectionStartOffset, newSelectionEndPosition, newSelectionEndOffset));
                if (!clone.isValid()) {
                    return null;
                }
            }
            this.myEditor.getScrollingModel().scrollTo(clone.getLogicalPosition(), ScrollType.RELATIVE);
            return clone;
        }
        Disposer.dispose((Disposable)clone);
        return null;
    }

    private LogicalPosition truncate(int line, int column) {
        if (line < 0) {
            return new LogicalPosition(0, 0);
        }
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return this.myEditor.offsetToLogicalPosition(this.myEditor.getDocument().getTextLength());
        }
        return new LogicalPosition(line, column);
    }

    boolean isUnknownDirection() {
        return this.myUnknownDirection;
    }

    void setUnknownDirection(boolean unknownDirection) {
        this.myUnknownDirection = unknownDirection;
    }

    public int getSelectionStart() {
        SelectionMarker marker;
        CaretImpl.validateContext(false);
        if (this.hasSelection() && (marker = this.mySelectionMarker) != null) {
            return marker.getStartOffset();
        }
        return this.getOffset();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition position;
        CaretImpl.validateContext(true);
        SelectionMarker marker = this.mySelectionMarker;
        if (this.hasSelection()) {
            position = this.getRangeMarkerStartPosition();
            if (position == null) {
                VisualPosition endPosition;
                VisualPosition startPosition = this.myEditor.offsetToVisualPosition(marker.getStartOffset(), true, false);
                position = startPosition.after(endPosition = this.myEditor.offsetToVisualPosition(marker.getEndOffset(), false, true)) ? endPosition : startPosition;
            }
        } else {
            VisualPosition visualPosition = position = this.isVirtualSelectionEnabled() ? this.getVisualPosition() : this.myEditor.offsetToVisualPosition(this.getOffset(), this.getLogicalPosition().leansForward, false);
        }
        if (this.hasVirtualSelection()) {
            position = new VisualPosition(position.line, position.column + marker.startVirtualOffset);
        }
        VisualPosition visualPosition = position;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getSelectionStartPosition"));
        }
        return visualPosition;
    }

    LogicalPosition getSelectionStartLogicalPosition() {
        VisualPosition visualPosition;
        CaretImpl.validateContext(true);
        SelectionMarker marker = this.mySelectionMarker;
        LogicalPosition position = this.hasSelection() ? ((visualPosition = this.getRangeMarkerStartPosition()) == null ? this.myEditor.offsetToLogicalPosition(marker.getStartOffset()).leanForward(true) : this.myEditor.visualToLogicalPosition(visualPosition)) : this.getLogicalPosition();
        if (this.hasVirtualSelection()) {
            position = new LogicalPosition(position.line, position.column + marker.startVirtualOffset);
        }
        return position;
    }

    public int getSelectionEnd() {
        SelectionMarker marker;
        CaretImpl.validateContext(false);
        if (this.hasSelection() && (marker = this.mySelectionMarker) != null) {
            return marker.getEndOffset();
        }
        return this.getOffset();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition position;
        CaretImpl.validateContext(true);
        SelectionMarker marker = this.mySelectionMarker;
        if (this.hasSelection()) {
            position = this.getRangeMarkerEndPosition();
            if (position == null) {
                VisualPosition endPosition;
                VisualPosition startPosition = this.myEditor.offsetToVisualPosition(marker.getStartOffset(), true, false);
                position = startPosition.after(endPosition = this.myEditor.offsetToVisualPosition(marker.getEndOffset(), false, true)) ? startPosition : endPosition;
            }
        } else {
            VisualPosition visualPosition = position = this.isVirtualSelectionEnabled() ? this.getVisualPosition() : this.myEditor.offsetToVisualPosition(this.getOffset(), this.getLogicalPosition().leansForward, false);
        }
        if (this.hasVirtualSelection()) {
            position = new VisualPosition(position.line, position.column + marker.endVirtualOffset);
        }
        VisualPosition visualPosition = position;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getSelectionEndPosition"));
        }
        return visualPosition;
    }

    LogicalPosition getSelectionEndLogicalPosition() {
        VisualPosition visualPosition;
        CaretImpl.validateContext(true);
        SelectionMarker marker = this.mySelectionMarker;
        LogicalPosition position = this.hasSelection() ? ((visualPosition = this.getRangeMarkerEndPosition()) == null ? this.myEditor.offsetToLogicalPosition(marker.getEndOffset()) : this.myEditor.visualToLogicalPosition(visualPosition)) : this.getLogicalPosition();
        if (this.hasVirtualSelection()) {
            position = new LogicalPosition(position.line, position.column + marker.endVirtualOffset);
        }
        return position;
    }

    public boolean hasSelection() {
        CaretImpl.validateContext(false);
        SelectionMarker marker = this.mySelectionMarker;
        return marker != null && marker.isValid() && (marker.getEndOffset() > marker.getStartOffset() || this.isVirtualSelectionEnabled() && marker.hasVirtualSelection());
    }

    public void setSelection(int startOffset, int endOffset) {
        this.setSelection(startOffset, endOffset, true);
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.doSetSelection(this.myEditor.offsetToVisualPosition(startOffset, true, false), startOffset, this.myEditor.offsetToVisualPosition(endOffset, false, true), endOffset, false, updateSystemSelection);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        VisualPosition startPosition = this.hasSelection() ? this.getLeadSelectionPosition() : this.myEditor.offsetToVisualPosition(startOffset, true, false);
        this.setSelection(startPosition, startOffset, endPosition, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startPosition, startOffset, endPosition, endOffset, true);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        VisualPosition startPositionToUse = startPosition == null ? this.myEditor.offsetToVisualPosition(startOffset, true, false) : startPosition;
        VisualPosition endPositionToUse = endPosition == null ? this.myEditor.offsetToVisualPosition(endOffset, false, true) : endPosition;
        this.doSetSelection(startPositionToUse, startOffset, endPositionToUse, endOffset, true, updateSystemSelection);
    }

    private void doSetSelection(@NotNull VisualPosition startPosition, int _startOffset, @NotNull VisualPosition endPosition, int _endOffset, boolean visualPositionAware, boolean updateSystemSelection) {
        if (startPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPosition", "com/intellij/openapi/editor/impl/CaretImpl", "doSetSelection"));
        }
        if (endPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPosition", "com/intellij/openapi/editor/impl/CaretImpl", "doSetSelection"));
        }
        this.myEditor.getCaretModel().doWithCaretMerging(() -> {
            int oldSelectionEnd;
            int oldSelectionStart;
            FoldRegion endFold;
            FoldingModelImpl foldingModel;
            FoldRegion startFold;
            if (endPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPosition", "com/intellij/openapi/editor/impl/CaretImpl", "lambda$doSetSelection$6"));
            }
            if (startPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPosition", "com/intellij/openapi/editor/impl/CaretImpl", "lambda$doSetSelection$6"));
            }
            int startOffset = DocumentUtil.alignToCodePointBoundary(this.myEditor.getDocument(), _startOffset);
            int endOffset = DocumentUtil.alignToCodePointBoundary(this.myEditor.getDocument(), _endOffset);
            this.myUnknownDirection = false;
            DocumentEx doc = this.myEditor.getDocument();
            CaretImpl.validateContext(true);
            int textLength = doc.getTextLength();
            if (startOffset < 0 || startOffset > textLength) {
                LOG.error("Wrong startOffset: " + startOffset + ", textLength=" + textLength);
            }
            if (endOffset < 0 || endOffset > textLength) {
                LOG.error("Wrong endOffset: " + endOffset + ", textLength=" + textLength);
            }
            if (!visualPositionAware && startOffset == endOffset) {
                this.removeSelection();
                return;
            }
            boolean switchedOffsets = false;
            if (startOffset > endOffset) {
                int tmp = startOffset;
                startOffset = endOffset;
                endOffset = tmp;
                switchedOffsets = true;
            }
            if ((startFold = (foldingModel = this.myEditor.getFoldingModel()).getCollapsedRegionAtOffset(startOffset)) != null && startFold.getStartOffset() < startOffset) {
                startOffset = startFold.getStartOffset();
            }
            if ((endFold = foldingModel.getCollapsedRegionAtOffset(endOffset)) != null && endFold.getStartOffset() < endOffset) {
                endOffset = endFold.getEndOffset();
            }
            if (this.hasSelection()) {
                oldSelectionStart = this.getSelectionStart();
                oldSelectionEnd = this.getSelectionEnd();
                if (oldSelectionStart == startOffset && oldSelectionEnd == endOffset && !visualPositionAware) {
                    return;
                }
            } else {
                oldSelectionStart = oldSelectionEnd = this.getOffset();
            }
            SelectionMarker marker = new SelectionMarker(startOffset, endOffset);
            if (visualPositionAware) {
                if (endPosition.after(startPosition)) {
                    this.setRangeMarkerStartPosition(startPosition);
                    this.setRangeMarkerEndPosition(endPosition);
                    this.setRangeMarkerEndPositionIsLead(false);
                } else {
                    this.setRangeMarkerStartPosition(endPosition);
                    this.setRangeMarkerEndPosition(startPosition);
                    this.setRangeMarkerEndPositionIsLead(true);
                }
                if (this.isVirtualSelectionEnabled() && this.myEditor.getDocument().getLineNumber(startOffset) == this.myEditor.getDocument().getLineNumber(endOffset)) {
                    int endLineColumn = this.myEditor.offsetToVisualPosition((int)endOffset).column;
                    int startDiff = EditorUtil.isAtLineEnd(this.myEditor, switchedOffsets ? endOffset : startOffset) ? startPosition.column - endLineColumn : 0;
                    int endDiff = EditorUtil.isAtLineEnd(this.myEditor, switchedOffsets ? startOffset : endOffset) ? endPosition.column - endLineColumn : 0;
                    marker.startVirtualOffset = Math.max(0, Math.min(startDiff, endDiff));
                    marker.endVirtualOffset = Math.max(0, Math.max(startDiff, endDiff));
                }
            }
            this.mySelectionMarker = marker;
            this.myEditor.getSelectionModel().fireSelectionChanged(oldSelectionStart, oldSelectionEnd, startOffset, endOffset);
            if (updateSystemSelection) {
                this.updateSystemSelection();
            }
        });
    }

    private void updateSystemSelection() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Clipboard clip = this.myEditor.getComponent().getToolkit().getSystemSelection();
        if (clip != null) {
            clip.setContents(new StringSelection(this.myEditor.getSelectionModel().getSelectedText(true)), (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
        }
    }

    public void removeSelection() {
        if (this.myEditor.isStickySelection()) {
            return;
        }
        this.myEditor.getCaretModel().doWithCaretMerging(() -> {
            CaretImpl.validateContext(true);
            int caretOffset = this.getOffset();
            SelectionMarker marker = this.mySelectionMarker;
            if (marker != null && marker.isValid()) {
                int startOffset = marker.getStartOffset();
                int endOffset = marker.getEndOffset();
                this.mySelectionMarker = null;
                this.myEditor.getSelectionModel().fireSelectionChanged(startOffset, endOffset, caretOffset, caretOffset);
            }
        });
    }

    public int getLeadSelectionOffset() {
        SelectionMarker marker;
        CaretImpl.validateContext(false);
        int caretOffset = this.getOffset();
        if (this.hasSelection() && (marker = this.mySelectionMarker) != null && marker.isValid()) {
            FoldingModelImpl foldingModel;
            FoldRegion foldRegion;
            int startOffset = marker.getStartOffset();
            int endOffset = marker.getEndOffset();
            if (caretOffset != startOffset && caretOffset != endOffset && (foldRegion = (foldingModel = this.myEditor.getFoldingModel()).getCollapsedRegionAtOffset(caretOffset)) != null) {
                if (foldRegion.getStartOffset() == startOffset) {
                    return endOffset;
                }
                if (foldRegion.getEndOffset() == endOffset) {
                    return startOffset;
                }
            }
            if (caretOffset == endOffset) {
                return startOffset;
            }
            return endOffset;
        }
        return caretOffset;
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        SelectionMarker marker = this.mySelectionMarker;
        VisualPosition caretPosition = this.getVisualPosition();
        if (this.isVirtualSelectionEnabled() && !this.hasSelection()) {
            VisualPosition visualPosition = caretPosition;
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
            }
            return visualPosition;
        }
        if (marker == null || !marker.isValid()) {
            VisualPosition visualPosition = caretPosition;
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
            }
            return visualPosition;
        }
        if (this.isRangeMarkerEndPositionIsLead()) {
            VisualPosition result2 = this.getRangeMarkerEndPosition();
            if (result2 == null) {
                VisualPosition visualPosition = this.getSelectionEndPosition();
                if (visualPosition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
                }
                return visualPosition;
            }
            if (this.hasVirtualSelection()) {
                result2 = new VisualPosition(result2.line, result2.column + marker.endVirtualOffset);
            }
            VisualPosition visualPosition = result2;
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
            }
            return visualPosition;
        }
        VisualPosition result3 = this.getRangeMarkerStartPosition();
        if (result3 == null) {
            VisualPosition visualPosition = this.getSelectionStartPosition();
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
            }
            return visualPosition;
        }
        if (this.hasVirtualSelection()) {
            result3 = new VisualPosition(result3.line, result3.column + marker.startVirtualOffset);
        }
        VisualPosition visualPosition = result3;
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getLeadSelectionPosition"));
        }
        return visualPosition;
    }

    public void selectLineAtCaret() {
        CaretImpl.validateContext(true);
        this.myEditor.getCaretModel().doWithCaretMerging(() -> SelectionModelImpl.doSelectLineAtCaret(this));
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        CaretImpl.validateContext(true);
        this.myEditor.getCaretModel().doWithCaretMerging(() -> {
            boolean needOverrideSetting;
            this.removeSelection();
            EditorSettings settings = this.myEditor.getSettings();
            boolean camelTemp = settings.isCamelWords();
            boolean bl = needOverrideSetting = camelTemp && !honorCamelWordsSettings;
            if (needOverrideSetting) {
                settings.setCamelWords(false);
            }
            try {
                EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorSelectWord");
                handler2.execute((Editor)this.myEditor, (Caret)this, this.myEditor.getDataContext());
            }
            finally {
                if (needOverrideSetting) {
                    settings.resetCamelWords();
                }
            }
        });
    }

    @Nullable
    public String getSelectedText() {
        if (!this.hasSelection()) {
            return null;
        }
        SelectionMarker selectionMarker = this.mySelectionMarker;
        CharSequence text = this.myEditor.getDocument().getCharsSequence();
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        String selectedText = text.subSequence(selectionStart, selectionEnd).toString();
        if (this.isVirtualSelectionEnabled() && selectionMarker.hasVirtualSelection()) {
            int padding = selectionMarker.endVirtualOffset - selectionMarker.startVirtualOffset;
            StringBuilder builder = new StringBuilder(selectedText.length() + padding);
            builder.append(selectedText);
            for (int i2 = 0; i2 < padding; ++i2) {
                builder.append(' ');
            }
            return builder.toString();
        }
        return selectedText;
    }

    private static void validateContext(boolean requireEdt) {
        if (requireEdt) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        } else {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
    }

    private boolean isVirtualSelectionEnabled() {
        return this.myEditor.isColumnMode();
    }

    boolean hasVirtualSelection() {
        CaretImpl.validateContext(false);
        SelectionMarker marker = this.mySelectionMarker;
        return marker != null && marker.isValid() && this.isVirtualSelectionEnabled() && marker.hasVirtualSelection();
    }

    void resetVirtualSelection() {
        SelectionMarker marker = this.mySelectionMarker;
        if (marker != null) {
            marker.resetVirtualSelection();
        }
    }

    private int getCurrentX() {
        return this.myEditor.visualPositionToXY((VisualPosition)this.myVisibleCaret).x;
    }

    @NotNull
    public EditorImpl getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getEditor"));
        }
        return editorImpl;
    }

    public String toString() {
        return "Caret at " + (this.myDocumentUpdateCounter == this.myEditor.getCaretModel().myDocumentUpdateCounter ? this.myVisibleCaret : Integer.valueOf(this.getOffset())) + (this.mySelectionMarker == null ? "" : ", selection marker: " + this.mySelectionMarker.toString());
    }

    public boolean isAtRtlLocation() {
        return this.myEditor.myView.isRtlLocation(this.getVisualPosition());
    }

    public boolean isAtBidiRunBoundary() {
        return this.myEditor.myView.isAtBidiRunBoundary(this.getVisualPosition());
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        CaretVisualAttributes attrs = (CaretVisualAttributes)this.getUserData(VISUAL_ATTRIBUTES_KEY);
        CaretVisualAttributes caretVisualAttributes = attrs == null ? CaretVisualAttributes.DEFAULT : attrs;
        if (caretVisualAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "getVisualAttributes"));
        }
        return caretVisualAttributes;
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/editor/impl/CaretImpl", "setVisualAttributes"));
        }
        this.putUserData(VISUAL_ATTRIBUTES_KEY, attributes == CaretVisualAttributes.DEFAULT ? null : attributes);
        this.requestRepaint(this.myCaretInfo);
    }

    @NotNull
    public String dumpState() {
        String string = "{valid: " + this.isValid + ", update counter: " + this.myDocumentUpdateCounter + ", position: " + this.myPositionMarker + ", logical pos: " + this.myLogicalCaret + ", visual pos: " + this.myVisibleCaret + ", visual line start: " + this.myVisualLineStart + ", visual line end: " + this.myVisualLineEnd + ", skip change requests: " + this.mySkipChangeRequests + ", desired selection start column: " + this.myDesiredSelectionStartColumn + ", desired selection end column: " + this.myDesiredSelectionEndColumn + ", report caret moves: " + this.myReportCaretMoves + ", desired x: " + this.myDesiredX + ", selection marker: " + this.mySelectionMarker + ", rangeMarker start position: " + this.myRangeMarkerStartPosition + ", rangeMarker end position: " + this.myRangeMarkerEndPosition + ", rangeMarker end position is lead: " + this.myRangeMarkerEndPositionIsLead + ", unknown direction: " + this.myUnknownDirection + ", virtual space offset: " + this.myVirtualSpaceOffset + '}';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretImpl", "dumpState"));
        }
        return string;
    }

    @Nullable
    private VisualPosition getRangeMarkerStartPosition() {
        this.invalidateRangeMarkerVisualPositions(this.mySelectionMarker);
        return this.myRangeMarkerStartPosition;
    }

    private void setRangeMarkerStartPosition(@NotNull VisualPosition startPosition) {
        if (startPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPosition", "com/intellij/openapi/editor/impl/CaretImpl", "setRangeMarkerStartPosition"));
        }
        this.myRangeMarkerStartPosition = startPosition;
    }

    @Nullable
    private VisualPosition getRangeMarkerEndPosition() {
        this.invalidateRangeMarkerVisualPositions(this.mySelectionMarker);
        return this.myRangeMarkerEndPosition;
    }

    void setRangeMarkerEndPosition(@NotNull VisualPosition endPosition) {
        if (endPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endPosition", "com/intellij/openapi/editor/impl/CaretImpl", "setRangeMarkerEndPosition"));
        }
        this.myRangeMarkerEndPosition = endPosition;
    }

    private boolean isRangeMarkerEndPositionIsLead() {
        return this.myRangeMarkerEndPositionIsLead;
    }

    void setRangeMarkerEndPositionIsLead(boolean endPositionIsLead) {
        this.myRangeMarkerEndPositionIsLead = endPositionIsLead;
    }

    private void invalidateRangeMarkerVisualPositions(RangeMarker marker) {
        SoftWrapModelImpl model = this.myEditor.getSoftWrapModel();
        InlayModelImpl inlayModel = this.myEditor.getInlayModel();
        int startOffset = marker.getStartOffset();
        int endOffset = marker.getEndOffset();
        if (!this.myEditor.offsetToVisualPosition(startOffset, true, false).equals((Object)this.myRangeMarkerStartPosition) && model.getSoftWrap(startOffset) == null && !inlayModel.hasInlineElementAt(startOffset) || !this.myEditor.offsetToVisualPosition(endOffset, false, true).equals((Object)this.myRangeMarkerEndPosition) && model.getSoftWrap(endOffset) == null && !inlayModel.hasInlineElementAt(endOffset)) {
            this.myRangeMarkerStartPosition = null;
            this.myRangeMarkerEndPosition = null;
        }
    }

    void updateCachedStateIfNeeded() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        int modelCounter = this.myEditor.getCaretModel().myDocumentUpdateCounter;
        if (this.myDocumentUpdateCounter != modelCounter) {
            LogicalPosition lp = this.myEditor.offsetToLogicalPosition(this.getOffset());
            this.setCurrentLogicalCaret(new LogicalPosition(lp.line, lp.column + this.myVirtualSpaceOffset, this.myLeansTowardsLargerOffsets));
            this.myVisibleCaret = this.myEditor.logicalToVisualPosition(this.myLogicalCaret);
            this.updateVisualLineInfo();
            this.setLastColumnNumber(this.myLogicalCaret.column);
            this.myDesiredSelectionEndColumn = -1;
            this.myDesiredSelectionStartColumn = -1;
            this.myDesiredX = -1;
            this.myDocumentUpdateCounter = modelCounter;
        }
    }

    public void validateState() {
        LOG.assertTrue(!DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), this.getOffset()));
        LOG.assertTrue(!DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), this.getSelectionStart()));
        LOG.assertTrue(!DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), this.getSelectionEnd()));
    }

    class SelectionMarker
    extends RangeMarkerImpl {
        private int startVirtualOffset;
        private int endVirtualOffset;

        private SelectionMarker(int start, int end) {
            super(CaretImpl.this.myEditor.getDocument(), start, end, false);
            ((CaretImpl)CaretImpl.this).myEditor.getCaretModel().mySelectionMarkerTree.addInterval(this, start, end, false, false, 0);
        }

        private void resetVirtualSelection() {
            this.startVirtualOffset = 0;
            this.endVirtualOffset = 0;
        }

        private boolean hasVirtualSelection() {
            return this.endVirtualOffset > this.startVirtualOffset;
        }

        @Override
        public void dispose() {
            if (this.isValid()) {
                ((CaretImpl)CaretImpl.this).myEditor.getCaretModel().mySelectionMarkerTree.removeInterval(this);
            }
        }

        @Override
        protected void changedUpdateImpl(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/CaretImpl$SelectionMarker", "changedUpdateImpl"));
            }
            super.changedUpdateImpl(e);
            if (this.isValid()) {
                int startOffset = this.intervalStart();
                int endOffset = this.intervalEnd();
                if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), startOffset)) {
                    this.setIntervalStart(startOffset - 1);
                }
                if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), endOffset)) {
                    this.setIntervalStart(endOffset - 1);
                }
            }
            if (this.endVirtualOffset > 0 && this.isValid()) {
                Document document = e.getDocument();
                int startAfter = this.intervalStart();
                int endAfter = this.intervalEnd();
                if (!DocumentUtil.isAtLineEnd(endAfter, document) || document.getLineNumber(startAfter) != document.getLineNumber(endAfter)) {
                    this.resetVirtualSelection();
                }
            }
        }

        @Override
        protected void onReTarget(int startOffset, int endOffset, int destOffset) {
            int start = this.intervalStart();
            if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), start)) {
                this.setIntervalStart(start - 1);
            }
            int end = this.intervalEnd();
            if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), end)) {
                this.setIntervalStart(end - 1);
            }
        }

        @Override
        public String toString() {
            return super.toString() + (this.hasVirtualSelection() ? " virtual selection: " + this.startVirtualOffset + "-" + this.endVirtualOffset : "");
        }
    }

    class PositionMarker
    extends RangeMarkerImpl {
        private PositionMarker(int offset) {
            super(CaretImpl.this.myEditor.getDocument(), offset, offset, false);
            ((CaretImpl)CaretImpl.this).myEditor.getCaretModel().myPositionMarkerTree.addInterval(this, offset, offset, false, false, 0);
        }

        @Override
        public void dispose() {
            if (this.isValid()) {
                ((CaretImpl)CaretImpl.this).myEditor.getCaretModel().myPositionMarkerTree.removeInterval(this);
            }
        }

        @Override
        protected void changedUpdateImpl(@NotNull DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/CaretImpl$PositionMarker", "changedUpdateImpl"));
            }
            int oldOffset = this.intervalStart();
            super.changedUpdateImpl(e);
            if (this.isValid()) {
                if (e.getOldLength() == 0 && oldOffset == e.getOffset() && !Boolean.TRUE.equals(CaretImpl.this.myEditor.getUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION)) && this.needToShiftWhiteSpaces(e)) {
                    int afterInserted = e.getOffset() + e.getNewLength();
                    this.setIntervalStart(afterInserted);
                    this.setIntervalEnd(afterInserted);
                }
                int offset = this.intervalStart();
                if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), offset)) {
                    this.setIntervalStart(offset - 1);
                    this.setIntervalEnd(offset - 1);
                }
            } else {
                this.setValid(true);
                int newOffset = Math.min(this.intervalStart(), e.getOffset() + e.getNewLength());
                if (!((DocumentEx)e.getDocument()).isInBulkUpdate() && e.isWholeTextReplaced()) {
                    try {
                        int line = ((DocumentEventImpl)e).translateLineViaDiff(((CaretImpl)CaretImpl.this).myLogicalCaret.line);
                        newOffset = CaretImpl.this.myEditor.logicalPositionToOffset(new LogicalPosition(line, ((CaretImpl)CaretImpl.this).myLogicalCaret.column));
                    }
                    catch (FilesTooBigForDiffException ex) {
                        LOG.info((Throwable)ex);
                    }
                }
                newOffset = DocumentUtil.alignToCodePointBoundary(this.getDocument(), newOffset);
                this.setIntervalStart(newOffset);
                this.setIntervalEnd(newOffset);
            }
            if (oldOffset >= e.getOffset() && oldOffset <= e.getOffset() + e.getOldLength() && e.getNewLength() == 0 && CaretImpl.this.myEditor.getInlayModel().hasInlineElementAt(e.getOffset())) {
                CaretImpl.this.myLeansTowardsLargerOffsets = true;
            } else if (oldOffset == e.getOffset()) {
                CaretImpl.this.myLeansTowardsLargerOffsets = false;
            }
        }

        private boolean needToShiftWhiteSpaces(DocumentEvent e) {
            return e.getOffset() > 0 && Character.isWhitespace(e.getDocument().getImmutableCharSequence().charAt(e.getOffset() - 1)) && CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)e.getNewFragment()) && !CharArrayUtil.containLineBreaks((CharSequence)e.getNewFragment());
        }

        @Override
        protected void onReTarget(int startOffset, int endOffset, int destOffset) {
            int offset = this.intervalStart();
            if (DocumentUtil.isInsideSurrogatePair(this.getDocument(), offset)) {
                this.setIntervalStart(offset - 1);
                this.setIntervalEnd(offset - 1);
            }
        }
    }

    private static class VerticalInfo {
        public final int y;
        public final int height;

        private VerticalInfo(int y, int height) {
            this.y = y;
            this.height = height;
        }
    }
}

