/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorLastActionTracker;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.Nullable;

public class EditorLastActionTrackerImpl
extends EditorLastActionTracker
implements ApplicationComponentAdapter,
AnActionListener,
EditorMouseListener,
Disposable {
    private static final Key<Boolean> DISPOSABLE_SET = Key.create((String)"EditorLastActionTracker.dispose.handler.set");
    private final ActionManager myActionManager;
    private final EditorEventMulticaster myEditorEventMulticaster;
    private String myLastActionId;
    private Editor myCurrentEditor;
    private Editor myLastEditor;

    EditorLastActionTrackerImpl(ActionManager actionManager, EditorFactory editorFactory) {
        this.myActionManager = actionManager;
        this.myEditorEventMulticaster = editorFactory.getEventMulticaster();
    }

    public void initComponent() {
        this.myActionManager.addAnActionListener((AnActionListener)this, (Disposable)this);
        this.myEditorEventMulticaster.addEditorMouseListener((EditorMouseListener)this, (Disposable)this);
    }

    public void dispose() {
    }

    @Nullable
    public String getLastActionId() {
        return this.myLastActionId;
    }

    public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        this.myCurrentEditor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        this.registerDisposeHandler(this.myCurrentEditor);
        if (this.myCurrentEditor != this.myLastEditor) {
            this.resetLastAction();
        }
    }

    public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        this.myLastActionId = this.getActionId(action);
        this.myLastEditor = this.myCurrentEditor;
        this.myCurrentEditor = null;
    }

    public void beforeEditorTyping(char c, DataContext dataContext) {
        this.resetLastAction();
    }

    public void mousePressed(EditorMouseEvent e) {
        this.resetLastAction();
    }

    public void mouseClicked(EditorMouseEvent e) {
        this.resetLastAction();
    }

    public void mouseReleased(EditorMouseEvent e) {
        this.resetLastAction();
    }

    public void mouseEntered(EditorMouseEvent e) {
    }

    public void mouseExited(EditorMouseEvent e) {
    }

    private String getActionId(AnAction action) {
        return action instanceof ActionStub ? ((ActionStub)action).getId() : this.myActionManager.getId(action);
    }

    private void resetLastAction() {
        this.myLastActionId = null;
        this.myLastEditor = null;
    }

    private void registerDisposeHandler(final Editor editor) {
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        EditorImpl editorImpl = (EditorImpl)editor;
        if (!editorImpl.isDisposed() && editorImpl.replace(DISPOSABLE_SET, null, Boolean.TRUE)) {
            Disposer.register((Disposable)editorImpl.getDisposable(), (Disposable)new Disposable(){

                public void dispose() {
                    if (EditorLastActionTrackerImpl.this.myCurrentEditor == editor) {
                        EditorLastActionTrackerImpl.this.myCurrentEditor = null;
                    }
                    if (EditorLastActionTrackerImpl.this.myLastEditor == editor) {
                        EditorLastActionTrackerImpl.this.myLastEditor = null;
                    }
                }
            });
        }
    }
}

