/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTree;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksTreeModel;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectPathLookupElement;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectPathField
extends ComponentWithBrowseButton<MyPathAndProjectButtonPanel>
implements TextAccessor {
    @NotNull
    private static final String PROJECT_FILE_TO_START_WITH_KEY = "external.system.task.project.file.to.start";
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    public ExternalProjectPathField(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull FileChooserDescriptor descriptor, @NotNull String fileChooserTitle) {
        ActionListener[] listeners;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "<init>"));
        }
        if (fileChooserTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileChooserTitle", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "<init>"));
        }
        super((JComponent)ExternalProjectPathField.createPanel(project2, externalSystemId), (ActionListener)new MyBrowseListener(descriptor, fileChooserTitle, project2));
        for (ActionListener listener2 : listeners = this.getButton().getActionListeners()) {
            if (!(listener2 instanceof MyBrowseListener)) continue;
            ((MyBrowseListener)listener2).setPathField(((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField());
            break;
        }
        this.myProject = project2;
        this.myExternalSystemId = externalSystemId;
    }

    @NotNull
    public static MyPathAndProjectButtonPanel createPanel(final @NotNull Project project2, final @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "createPanel"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "createPanel"));
        }
        final EditorTextField textField = ExternalProjectPathField.createTextField(project2, externalSystemId);
        final FixedSizeButton selectRegisteredProjectButton = new FixedSizeButton();
        selectRegisteredProjectButton.setIcon(AllIcons.Actions.Module);
        String tooltipText = ExternalSystemBundle.message((String)"run.configuration.tooltip.choose.registered.project", (Object[])new Object[]{externalSystemId.getReadableName()});
        selectRegisteredProjectButton.setToolTipText(tooltipText);
        selectRegisteredProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ref popupRef = new Ref();
                Tree tree = ExternalProjectPathField.buildRegisteredProjectsTree(project2, externalSystemId);
                tree.setBorder(IdeBorderFactory.createEmptyBorder((int)8));
                Runnable treeSelectionCallback = () -> {
                    Object e1;
                    Object lastPathComponent;
                    if (externalSystemId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$1", "lambda$actionPerformed$0"));
                    }
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$1", "lambda$actionPerformed$0"));
                    }
                    TreePath path = tree.getSelectionPath();
                    if (path != null && (lastPathComponent = path.getLastPathComponent()) instanceof ExternalSystemNode && (e1 = ((ExternalSystemNode)lastPathComponent).getDescriptor().getElement()) instanceof ExternalProjectPojo) {
                        ExternalProjectPojo pojo = (ExternalProjectPojo)e1;
                        textField.setText(pojo.getPath());
                        Editor editor = textField.getEditor();
                        if (editor != null) {
                            ExternalProjectPathField.collapseIfPossible(editor, externalSystemId, project2);
                        }
                    }
                    ((JBPopup)popupRef.get()).closeOk(null);
                };
                JBPopup popup = new PopupChooserBuilder((JTree)tree).setTitle(ExternalSystemBundle.message((String)"run.configuration.title.choose.registered.project", (Object[])new Object[]{externalSystemId.getReadableName()})).setResizable(true).setItemChoosenCallback(treeSelectionCallback).setAutoselectOnMouseMove(true).setCloseOnEnter(false).createPopup();
                popupRef.set((Object)popup);
                popup.showUnderneathOf((Component)selectRegisteredProjectButton);
            }
        });
        MyPathAndProjectButtonPanel myPathAndProjectButtonPanel = new MyPathAndProjectButtonPanel(textField, selectRegisteredProjectButton);
        if (myPathAndProjectButtonPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "createPanel"));
        }
        return myPathAndProjectButtonPanel;
    }

    @NotNull
    private static Tree buildRegisteredProjectsTree(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "buildRegisteredProjectsTree"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "buildRegisteredProjectsTree"));
        }
        ExternalSystemTasksTreeModel model = new ExternalSystemTasksTreeModel(externalSystemId);
        ExternalSystemTasksTree result2 = new ExternalSystemTasksTree(model, ContainerUtilRt.newHashMap(), project2, externalSystemId);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project2);
        Map projects = settings.getAvailableProjects();
        ArrayList rootProjects = ContainerUtilRt.newArrayList(projects.keySet());
        ContainerUtil.sort((List)rootProjects);
        for (ExternalProjectPojo rootProject : rootProjects) {
            model.ensureSubProjectsStructure(rootProject, (Collection)projects.get(rootProject));
        }
        ExternalSystemTasksTree externalSystemTasksTree = result2;
        if (externalSystemTasksTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "buildRegisteredProjectsTree"));
        }
        return externalSystemTasksTree;
    }

    @NotNull
    private static EditorTextField createTextField(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "createTextField"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "createTextField"));
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        final AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project2);
        final ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
        TextFieldCompletionProviderDumbAware provider = new TextFieldCompletionProviderDumbAware(){

            @Override
            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$2", "addCompletionVariants"));
                }
                if (prefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$2", "addCompletionVariants"));
                }
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$2", "addCompletionVariants"));
                }
                for (Map.Entry entry : settings.getAvailableProjects().entrySet()) {
                    String rootProjectPath = ((ExternalProjectPojo)entry.getKey()).getPath();
                    String rootProjectName = uiAware.getProjectRepresentationName(rootProjectPath, null);
                    ExternalProjectPathLookupElement rootProjectElement = new ExternalProjectPathLookupElement(rootProjectName, rootProjectPath);
                    result2.addElement((LookupElement)rootProjectElement);
                    for (ExternalProjectPojo subProject : (Collection)entry.getValue()) {
                        String p = subProject.getPath();
                        if (rootProjectPath.equals(p)) continue;
                        String subProjectName = uiAware.getProjectRepresentationName(p, rootProjectPath);
                        ExternalProjectPathLookupElement subProjectElement = new ExternalProjectPathLookupElement(subProjectName, p);
                        result2.addElement((LookupElement)subProjectElement);
                    }
                }
                result2.stopHere();
            }
        };
        EditorTextField result2 = provider.createEditor(project2, false, (Consumer<Editor>)((Consumer)editor -> {
            if (externalSystemId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "lambda$createTextField$0"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "lambda$createTextField$0"));
            }
            ExternalProjectPathField.collapseIfPossible(editor, externalSystemId, project2);
            editor.getSettings().setShowIntentionBulb(false);
        }));
        result2.setBorder(UIUtil.getTextFieldBorder());
        result2.setOneLineMode(true);
        result2.setOpaque(true);
        result2.setBackground(UIUtil.getTextFieldBackground());
        EditorTextField editorTextField = result2;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "createTextField"));
        }
        return editorTextField;
    }

    public void setText(String text) {
        ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().setText(text);
        Editor editor = ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().getEditor();
        if (editor != null) {
            ExternalProjectPathField.collapseIfPossible(editor, this.myExternalSystemId, this.myProject);
        }
    }

    private static void collapseIfPossible(@NotNull Editor editor, @NotNull ProjectSystemId externalSystemId, @NotNull Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "collapseIfPossible"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "collapseIfPossible"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "collapseIfPossible"));
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project2);
        ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
        String rawText = editor.getDocument().getText();
        for (Map.Entry entry : settings.getAvailableProjects().entrySet()) {
            if (((ExternalProjectPojo)entry.getKey()).getPath().equals(rawText)) {
                ExternalProjectPathField.collapse(editor, uiAware.getProjectRepresentationName(((ExternalProjectPojo)entry.getKey()).getPath(), null));
                return;
            }
            for (ExternalProjectPojo pojo : (Collection)entry.getValue()) {
                if (!pojo.getPath().equals(rawText)) continue;
                ExternalProjectPathField.collapse(editor, uiAware.getProjectRepresentationName(pojo.getPath(), ((ExternalProjectPojo)entry.getKey()).getPath()));
                return;
            }
        }
    }

    public static void collapse(@NotNull Editor editor, @NotNull String placeholder) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "collapse"));
        }
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "collapse"));
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        foldingModel.runBatchFoldingOperation(() -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "lambda$collapse$1"));
            }
            if (placeholder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField", "lambda$collapse$1"));
            }
            for (FoldRegion region : foldingModel.getAllFoldRegions()) {
                foldingModel.removeFoldRegion(region);
            }
            FoldRegion region = foldingModel.addFoldRegion(0, editor.getDocument().getTextLength(), placeholder);
            if (region != null) {
                region.setExpanded(false);
            }
        });
    }

    public String getText() {
        return ((MyPathAndProjectButtonPanel)this.getChildComponent()).getTextField().getText();
    }

    public static class MyPathAndProjectButtonPanel
    extends JPanel {
        @NotNull
        private final EditorTextField myTextField;
        @NotNull
        private final FixedSizeButton myRegisteredProjectsButton;

        public MyPathAndProjectButtonPanel(@NotNull EditorTextField textField, @NotNull FixedSizeButton registeredProjectsButton) {
            if (textField == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyPathAndProjectButtonPanel", "<init>"));
            }
            if (registeredProjectsButton == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registeredProjectsButton", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyPathAndProjectButtonPanel", "<init>"));
            }
            super(new GridBagLayout());
            this.myTextField = textField;
            this.myRegisteredProjectsButton = registeredProjectsButton;
            this.add((Component)((Object)this.myTextField), new GridBag().weightx(1.0).fillCellHorizontally());
            this.add((Component)this.myRegisteredProjectsButton, new GridBag().insets(0, 3, 0, 0));
        }

        @NotNull
        public EditorTextField getTextField() {
            EditorTextField editorTextField = this.myTextField;
            if (editorTextField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyPathAndProjectButtonPanel", "getTextField"));
            }
            return editorTextField;
        }
    }

    private static class MyBrowseListener
    implements ActionListener {
        @NotNull
        private final FileChooserDescriptor myDescriptor;
        @NotNull
        private final Project myProject;
        private EditorTextField myPathField;

        MyBrowseListener(@NotNull FileChooserDescriptor descriptor, @NotNull String fileChooserTitle, @NotNull Project project2) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyBrowseListener", "<init>"));
            }
            if (fileChooserTitle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileChooserTitle", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyBrowseListener", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyBrowseListener", "<init>"));
            }
            descriptor.setTitle(fileChooserTitle);
            this.myDescriptor = descriptor;
            this.myProject = project2;
        }

        private void setPathField(@NotNull EditorTextField pathField) {
            if (pathField == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathField", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathField$MyBrowseListener", "setPathField"));
            }
            this.myPathField = pathField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile file2;
            if (this.myPathField == null) {
                assert (false);
                return;
            }
            PropertiesComponent component = PropertiesComponent.getInstance((Project)this.myProject);
            String pathToStart = this.myPathField.getText();
            if (StringUtil.isEmpty((String)pathToStart)) {
                pathToStart = component.getValue(ExternalProjectPathField.PROJECT_FILE_TO_START_WITH_KEY);
            }
            VirtualFile fileToStart = null;
            if (!StringUtil.isEmpty((String)pathToStart)) {
                fileToStart = LocalFileSystem.getInstance().findFileByPath(pathToStart);
            }
            if ((file2 = FileChooser.chooseFile((FileChooserDescriptor)this.myDescriptor, (Project)this.myProject, (VirtualFile)fileToStart)) != null) {
                String path = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2);
                this.myPathField.setText(path);
                component.setValue(ExternalProjectPathField.PROJECT_FILE_TO_START_WITH_KEY, path);
            }
        }
    }
}

