/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class PersistentFileSetManager
implements PersistentStateComponent<Element> {
    private static final String FILE_ELEMENT = "file";
    private static final String PATH_ATTR = "url";
    private final Set<VirtualFile> myFiles = new THashSet();

    PersistentFileSetManager() {
    }

    protected boolean addFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_ELEMENT, "com/intellij/openapi/file/exclude/PersistentFileSetManager", "addFile"));
        }
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        this.myFiles.add(file2);
        return true;
    }

    protected boolean containsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_ELEMENT, "com/intellij/openapi/file/exclude/PersistentFileSetManager", "containsFile"));
        }
        return this.myFiles.contains(file2);
    }

    protected boolean removeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_ELEMENT, "com/intellij/openapi/file/exclude/PersistentFileSetManager", "removeFile"));
        }
        if (!this.myFiles.contains(file2)) {
            return false;
        }
        this.myFiles.remove(file2);
        return true;
    }

    @NotNull
    public Collection<VirtualFile> getFiles() {
        Set<VirtualFile> set2 = this.myFiles;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/file/exclude/PersistentFileSetManager", "getFiles"));
        }
        return set2;
    }

    @NotNull
    private Collection<VirtualFile> getSortedFiles() {
        ArrayList<VirtualFile> sortedFiles = new ArrayList<VirtualFile>();
        sortedFiles.addAll(this.myFiles);
        Collections.sort(sortedFiles, (file1, file2) -> file1.getPath().toLowerCase().compareTo(file2.getPath().toLowerCase()));
        ArrayList<VirtualFile> arrayList = sortedFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/file/exclude/PersistentFileSetManager", "getSortedFiles"));
        }
        return arrayList;
    }

    public Element getState() {
        Element root = new Element("root");
        for (VirtualFile vf : this.getSortedFiles()) {
            Element vfElement = new Element(FILE_ELEMENT);
            Attribute filePathAttr = new Attribute(PATH_ATTR, VfsUtilCore.pathToUrl((String)vf.getPath()));
            vfElement.setAttribute(filePathAttr);
            root.addContent(vfElement);
        }
        return root;
    }

    public void loadState(Element state) {
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        for (Object child : state.getChildren(FILE_ELEMENT)) {
            String filePath;
            VirtualFile vf;
            Element fileElement;
            Attribute filePathAttr;
            if (!(child instanceof Element) || (filePathAttr = (fileElement = (Element)child).getAttribute(PATH_ATTR)) == null || (vf = vfManager.findFileByUrl(filePath = filePathAttr.getValue())) == null) continue;
            this.myFiles.add(vf);
        }
    }
}

