/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.DockableEditorContainerFactory;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerChange;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.fileEditor.impl.FilePreviewPanelProvider;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NullUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.Navigatable;
import com.intellij.reference.SoftReference;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.impl.MessageListenerList;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileEditorManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileEditorManagerImpl
extends FileEditorManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
    private static final Key<Boolean> DUMB_AWARE = Key.create((String)"DUMB_AWARE");
    private static final FileEditor[] EMPTY_EDITOR_ARRAY = new FileEditor[0];
    private static final FileEditorProvider[] EMPTY_PROVIDER_ARRAY = new FileEditorProvider[0];
    public static final Key<Boolean> CLOSING_TO_REOPEN = Key.create((String)"CLOSING_TO_REOPEN");
    public static final String FILE_EDITOR_MANAGER = "FileEditorManager";
    private volatile JPanel myPanels;
    private EditorsSplitters mySplitters;
    private final Project myProject;
    private final List<Pair<VirtualFile, EditorWindow>> mySelectionHistory;
    private Reference<EditorComposite> myLastSelectedComposite;
    private final MergingUpdateQueue myQueue;
    private final BusyObject.Impl.Simple myBusyObject;
    private final PropertyChangeListener myEditorPropertyChangeListener;
    private final DockManager myDockManager;
    private DockableEditorContainerFactory myContentFactory;
    private static final AtomicInteger ourOpenFilesSetModificationCount = new AtomicInteger();
    static final ModificationTracker OPEN_FILE_SET_MODIFICATION_COUNT = ourOpenFilesSetModificationCount::get;
    private final Object myInitLock;
    private final MessageListenerList<FileEditorManagerListener> myListenerList;

    public FileEditorManagerImpl(@NotNull Project project2, DockManager dockManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "<init>"));
        }
        this.mySelectionHistory = new ArrayList<Pair<VirtualFile, EditorWindow>>();
        this.myLastSelectedComposite = new WeakReference<Object>(null);
        this.myQueue = new MergingUpdateQueue("FileEditorManagerUpdateQueue", 50, true, MergingUpdateQueue.ANY_COMPONENT);
        this.myBusyObject = new BusyObject.Impl.Simple();
        this.myEditorPropertyChangeListener = new MyEditorPropertyChangeListener();
        this.myInitLock = new Object();
        this.myProject = project2;
        this.myDockManager = dockManager;
        this.myListenerList = new MessageListenerList(this.myProject.getMessageBus(), FileEditorManagerListener.FILE_EDITOR_MANAGER);
        if (((FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)).length > 0) {
            this.myListenerList.add((Object)new FileEditorManagerListener(){

                public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$1", "selectionChanged"));
                    }
                    EditorsSplitters splitters = FileEditorManagerImpl.this.getSplitters();
                    FileEditorManagerImpl.this.openAssociatedFile(event.getNewFile(), splitters.getCurrentWindow(), splitters);
                }
            });
        }
        this.myQueue.setTrackUiActivity(true);
        final MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!FileEditorManagerImpl.this.myProject.isDisposed()) {
                        FileEditorManagerImpl.this.dumbModeFinished(FileEditorManagerImpl.this.myProject);
                    }
                });
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerAdapter(){

            public void projectOpened(Project project2) {
                if (project2 == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.projectOpened(connection);
                }
            }

            public void projectClosed(Project project2) {
                if (project2 == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.closeAllFiles();
                }
            }
        });
    }

    private void dumbModeFinished(Project project2) {
        VirtualFile[] files;
        for (VirtualFile file2 : files = this.getOpenFiles()) {
            HashSet<FileEditorProvider> providers = new HashSet<FileEditorProvider>();
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            for (EditorWithProviderComposite composite : composites) {
                providers.addAll(Arrays.asList(composite.getProviders()));
            }
            FileEditorProvider[] newProviders = FileEditorProviderManager.getInstance().getProviders(project2, file2);
            if (newProviders.length <= providers.size()) continue;
            ArrayList<FileEditorProvider> toOpen = new ArrayList<FileEditorProvider>(Arrays.asList(newProviders));
            toOpen.removeAll(providers);
            for (EditorWithProviderComposite composite : composites) {
                for (FileEditorProvider provider : toOpen) {
                    FileEditor editor = provider.createEditor(this.myProject, file2);
                    composite.addEditor(editor, provider);
                }
            }
        }
    }

    public void initDockableContentFactory() {
        if (this.myContentFactory != null) {
            return;
        }
        this.myContentFactory = new DockableEditorContainerFactory(this.myProject, this, this.myDockManager);
        this.myDockManager.register("file-editors", (DockContainerFactory)this.myContentFactory);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myContentFactory);
    }

    public static boolean isDumbAware(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "isDumbAware"));
        }
        return Boolean.TRUE.equals(editor.getUserData(DUMB_AWARE)) && (!(editor instanceof PossiblyDumbAware) || ((PossiblyDumbAware)editor).isDumbAware());
    }

    @Override
    public JComponent getComponent() {
        this.initUI();
        return this.myPanels;
    }

    @NotNull
    public EditorsSplitters getMainSplitters() {
        this.initUI();
        EditorsSplitters editorsSplitters = this.mySplitters;
        if (editorsSplitters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getMainSplitters"));
        }
        return editorsSplitters;
    }

    @NotNull
    public Set<EditorsSplitters> getAllSplitters() {
        LinkedHashSet<EditorsSplitters> all = new LinkedHashSet<EditorsSplitters>();
        all.add(this.getMainSplitters());
        Set dockContainers = this.myDockManager.getContainers();
        for (DockContainer each : dockContainers) {
            if (!(each instanceof DockableEditorTabbedContainer)) continue;
            all.add(((DockableEditorTabbedContainer)each).getSplitters());
        }
        Set<EditorsSplitters> set2 = Collections.unmodifiableSet(all);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getAllSplitters"));
        }
        return set2;
    }

    @NotNull
    private AsyncResult<EditorsSplitters> getActiveSplittersAsync() {
        AsyncResult result2 = new AsyncResult();
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        fm.doWhenFocusSettlesDown(() -> {
            if (this.myProject.isDisposed()) {
                result2.setRejected();
                return;
            }
            Component focusOwner = fm.getFocusOwner();
            DockContainer container = this.myDockManager.getContainerFor(focusOwner);
            if (container instanceof DockableEditorTabbedContainer) {
                result2.setDone((Object)((DockableEditorTabbedContainer)container).getSplitters());
            } else {
                result2.setDone((Object)this.getMainSplitters());
            }
        });
        AsyncResult asyncResult = result2;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getActiveSplittersAsync"));
        }
        return asyncResult;
    }

    private EditorsSplitters getActiveSplittersSync() {
        DockContainer container;
        FileEditorManagerImpl.assertDispatchThread();
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Component focusOwner = fm.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (focusOwner == null) {
            focusOwner = fm.getLastFocusedFor(fm.getLastFocusedFrame());
        }
        if ((container = this.myDockManager.getContainerFor(focusOwner)) == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            container = this.myDockManager.getContainerFor(focusOwner);
        }
        if (container instanceof DockableEditorTabbedContainer) {
            return ((DockableEditorTabbedContainer)container).getSplitters();
        }
        return this.getMainSplitters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        if (this.myPanels == null) {
            Object object = this.myInitLock;
            synchronized (object) {
                if (this.myPanels == null) {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.setOpaque(false);
                    panel2.setBorder(new MyBorder());
                    this.mySplitters = new EditorsSplitters(this, this.myDockManager, true);
                    Disposer.register((Disposable)this.myProject, (Disposable)this.mySplitters);
                    panel2.add((Component)((Object)this.mySplitters), "Center");
                    this.myPanels = panel2;
                }
            }
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        EditorWithProviderComposite editor;
        FileEditorManagerImpl.assertReadAccess();
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (editor = window.getSelectedEditor()) != null) {
            return editor.getPreferredFocusedComponent();
        }
        return null;
    }

    public Color getFileColor(@NotNull VirtualFile file2) {
        Color statusColor;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getFileColor"));
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        Color color = statusColor = fileStatusManager != null ? fileStatusManager.getStatus(file2).getColor() : UIUtil.getLabelForeground();
        if (statusColor == null) {
            statusColor = UIUtil.getLabelForeground();
        }
        return statusColor;
    }

    public boolean isProblem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "isProblem"));
        }
        return false;
    }

    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getFileTooltipText"));
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getFileTooltipText"));
        }
        return string;
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "updateFilePresentation"));
        }
        if (!this.isFileOpen(file2)) {
            return;
        }
        this.updateFileColor(file2);
        this.updateFileIcon(file2);
        this.updateFileName(file2);
        this.updateFileBackgroundColor(file2);
    }

    private void updateFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "updateFileColor"));
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileColor(file2);
        }
    }

    private void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "updateFileBackgroundColor"));
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileBackgroundColor(file2);
        }
    }

    protected void updateFileIcon(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "updateFileIcon"));
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileIcon(file2);
        }
    }

    void updateFileName(final @Nullable VirtualFile file2) {
        this.myQueue.queue(new Update("UpdateFileName " + (file2 == null ? "" : file2.getPath())){

            public boolean isExpired() {
                return FileEditorManagerImpl.this.myProject.isDisposed() || !FileEditorManagerImpl.this.myProject.isOpen() || (file2 == null ? super.isExpired() : !file2.isValid());
            }

            public void run() {
                Set<EditorsSplitters> all = FileEditorManagerImpl.this.getAllSplitters();
                for (EditorsSplitters each : all) {
                    each.updateFileName(file2);
                }
            }
        });
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getFile"));
        }
        EditorWithProviderComposite editorComposite = this.getEditorComposite(editor);
        if (editorComposite != null) {
            return editorComposite.getFile();
        }
        return null;
    }

    @Override
    public void unsplitWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplit(true);
        }
    }

    @Override
    public void unsplitAllWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplitAll();
        }
    }

    @Override
    public int getWindowSplitCount() {
        return this.getActiveSplittersSync().getSplitCount();
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        Set<EditorsSplitters> splitters = this.getAllSplitters();
        if (splitters.size() > 1) {
            return true;
        }
        return this.getWindowSplitCount() > 1;
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        ArrayList<EditorWindow> windows = new ArrayList<EditorWindow>();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            EditorWindow[] eachList = each.getWindows();
            windows.addAll(Arrays.asList(eachList));
        }
        EditorWindow[] editorWindowArray = windows.toArray(new EditorWindow[windows.size()]);
        if (editorWindowArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getWindows"));
        }
        return editorWindowArray;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getNextWindow"));
        }
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i2 = 0; i2 != windows.length; ++i2) {
            if (!windows[i2].equals(window)) continue;
            return windows[(i2 + 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getPrevWindow"));
        }
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i2 = 0; i2 != windows.length; ++i2) {
            if (!windows[i2].equals(window)) continue;
            return windows[(i2 + windows.length - 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public void createSplitter(int orientation, @Nullable EditorWindow window) {
        if (window != null) {
            window.split(orientation, true, null, false);
        } else {
            EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
            if (currentWindow != null) {
                currentWindow.split(orientation, true, null, false);
            }
        }
    }

    @Override
    public void changeSplitterOrientation() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.changeOrientation();
        }
    }

    @Override
    public void flipTabs() {
        this.myPanels.revalidate();
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    private void setTabsMode(boolean mode) {
        if (this.tabsMode() != mode) {
            this.flipTabs();
        }
    }

    @Override
    public boolean isInSplitter() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.inSplitter();
    }

    @Override
    public boolean hasOpenedFile() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.getSelectedEditor() != null;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.getActiveSplittersSync().getCurrentFile();
    }

    @Override
    @NotNull
    public AsyncResult<EditorWindow> getActiveWindow() {
        AsyncResult asyncResult = this.getActiveSplittersAsync().subResult(EditorsSplitters::getCurrentWindow);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getActiveWindow"));
        }
        return asyncResult;
    }

    @Override
    public EditorWindow getCurrentWindow() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        EditorsSplitters splitters = this.getActiveSplittersSync();
        return splitters == null ? null : splitters.getCurrentWindow();
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
        this.getActiveSplittersSync().setCurrentWindow(window, true);
    }

    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window, boolean transferFocus) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$closeFile$1"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$closeFile$1"));
            }
            if (window.isFileOpen(file2)) {
                window.closeFile(file2, true, transferFocus);
            }
        }, IdeBundle.message((String)"command.close.active.editor", (Object[])new Object[0]), null);
        this.removeSelectionRecord(file2, window);
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        this.closeFile(file2, window, true);
    }

    public void closeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        this.closeFile(file2, true, false);
    }

    public void closeFile(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFile"));
        }
        FileEditorManagerImpl.assertDispatchThread();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$closeFile$2"));
            }
            this.closeFileImpl(file2, moveFocus, closeAllCopies);
        }, "", null);
    }

    private void closeFileImpl(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "closeFileImpl"));
        }
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        this.runChange(splitters -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$closeFileImpl$3"));
            }
            splitters.closeFile(file2, moveFocus);
        }, closeAllCopies ? null : this.getActiveSplittersSync());
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForSplitter) {
        Pair<FileEditor[], FileEditorProvider[]> previewResult;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (FileEditorManagerImpl.isOpenInNewWindow()) {
            Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileInNewWindow(file2);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
            }
            return pair;
        }
        EditorWindow wndToOpenIn = null;
        if (searchForSplitter) {
            Set<EditorsSplitters> all = this.getAllSplitters();
            EditorsSplitters active = this.getActiveSplittersSync();
            if (active.getCurrentWindow() != null && active.getCurrentWindow().isFileOpen(file2)) {
                wndToOpenIn = active.getCurrentWindow();
            } else {
                for (EditorsSplitters splitters : all) {
                    EditorWindow window = splitters.getCurrentWindow();
                    if (window == null || !window.isFileOpen(file2)) continue;
                    wndToOpenIn = window;
                    break;
                }
            }
        } else {
            wndToOpenIn = this.getSplitters().getCurrentWindow();
        }
        if (!(wndToOpenIn != null && wndToOpenIn.isFileOpen(file2) || (previewResult = PreviewManager.SERVICE.preview(this.myProject, FilePreviewPanelProvider.ID, file2, focusEditor)) == null)) {
            Pair<FileEditor[], FileEditorProvider[]> pair = previewResult;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
            }
            return pair;
        }
        EditorsSplitters splitters = this.getSplitters();
        if (wndToOpenIn == null) {
            wndToOpenIn = splitters.getOrCreateCurrentWindow(file2);
        }
        this.openAssociatedFile(file2, wndToOpenIn, splitters);
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl2(wndToOpenIn, file2, focusEditor);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        return pair;
    }

    public Pair<FileEditor[], FileEditorProvider[]> openFileInNewWindow(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileInNewWindow"));
        }
        return ((DockManagerImpl)DockManager.getInstance((Project)this.getProject())).createNewDockContainerFor(file2, this);
    }

    private static boolean isOpenInNewWindow() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent && ((MouseEvent)event).isShiftDown() && (event.getID() == 500 || event.getID() == 501 || event.getID() == 502)) {
            return true;
        }
        if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
            String[] ids = keymap.getActionIds(KeyStroke.getKeyStroke(ke.getKeyCode(), ke.getModifiers()));
            return Arrays.asList(ids).contains("OpenElementInNewWindow");
        }
        return false;
    }

    private void openAssociatedFile(VirtualFile file2, EditorWindow wndToOpenIn, @NotNull EditorsSplitters splitters) {
        if (splitters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitters", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openAssociatedFile"));
        }
        EditorWindow[] windows = splitters.getWindows();
        if (file2 != null && windows.length == 2) {
            for (FileEditorAssociateFinder finder : (FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)) {
                VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, file2);
                if (associatedFile == null) continue;
                EditorWindow currentWindow = splitters.getCurrentWindow();
                int idx = windows[0] == wndToOpenIn ? 1 : 0;
                this.openFileImpl2(windows[idx], associatedFile, false);
                if (currentWindow == null) break;
                splitters.setCurrentWindow(currentWindow, false);
                break;
            }
        }
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl2(window, file2, focusEditor);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileWithProviders"));
        }
        return pair;
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileImpl2(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl2"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl2"));
        }
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$openFileImpl2$4"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$openFileImpl2$4"));
            }
            result2.set(this.openFileImpl3(window, file2, focusEditor, null, true));
        }, "", null);
        Pair pair = (Pair)result2.get();
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl2"));
        }
        return pair;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor, @Nullable HistoryEntry entry, boolean current) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl3"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl3"));
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl4(window, file2, entry, current, focusEditor, null, -1);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl3"));
        }
        return pair;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl4(@NotNull EditorWindow window, @NotNull VirtualFile file2, @Nullable HistoryEntry entry, boolean current, boolean focusEditor, Boolean pin, int index) {
        AsyncFileEditorProvider.Builder[] builders;
        FileEditorProvider[] newProviders;
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl4"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl4"));
        }
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "must not open files under read action since we are doing a lot of invokeAndWaits here";
        Ref compositeRef = new Ref();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$openFileImpl4$5"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$openFileImpl4$5"));
            }
            compositeRef.set((Object)window.findFileComposite(file2));
        });
        if (compositeRef.isNull()) {
            newProviders = FileEditorProviderManager.getInstance().getProviders(this.myProject, file2);
            if (newProviders.length == 0) {
                Pair pair = Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl4"));
                }
                return pair;
            }
            builders = new AsyncFileEditorProvider.Builder[newProviders.length];
            for (int i2 = 0; i2 < newProviders.length; ++i2) {
                try {
                    FileEditorProvider provider = newProviders[i2];
                    LOG.assertTrue(provider != null, (Object)("Provider for file " + file2 + " is null. All providers: " + Arrays.asList(newProviders)));
                    builders[i2] = (AsyncFileEditorProvider.Builder)ReadAction.compute(() -> {
                        if (file2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$openFileImpl4$6"));
                        }
                        if (this.myProject.isDisposed() || !file2.isValid()) {
                            return null;
                        }
                        LOG.assertTrue(provider.accept(this.myProject, file2), (Object)("Provider " + provider + " doesn't accept file " + file2));
                        return provider instanceof AsyncFileEditorProvider ? ((AsyncFileEditorProvider)provider).createEditorAsync(this.myProject, file2) : null;
                    });
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (AssertionError | Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        } else {
            newProviders = null;
            builders = null;
        }
        Runnable runnable2 = () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$openFileImpl4$8"));
            }
            if (window == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$openFileImpl4$8"));
            }
            if (this.myProject.isDisposed() || !file2.isValid()) {
                return;
            }
            HeavyProcessLatch.INSTANCE.prioritizeUiActivity();
            compositeRef.set((Object)window.findFileComposite(file2));
            boolean newEditor = compositeRef.isNull();
            if (newEditor) {
                FileEditorManagerImpl.clearWindowIfNeeded(window);
                ((FileEditorManagerListener.Before)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER)).beforeFileOpened((FileEditorManager)this, file2);
                FileEditor[] newEditors = new FileEditor[newProviders.length];
                for (int i2 = 0; i2 < newProviders.length; ++i2) {
                    try {
                        FileEditorProvider provider = newProviders[i2];
                        FileEditor editor = builders[i2] == null ? provider.createEditor(this.myProject, file2) : builders[i2].build();
                        LOG.assertTrue(editor.isValid(), (Object)("Invalid editor created by provider " + (provider == null ? null : provider.getClass().getName())));
                        newEditors[i2] = editor;
                        editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
                        editor.putUserData(DUMB_AWARE, (Object)DumbService.isDumbAware((Object)provider));
                        continue;
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (AssertionError | Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
                EditorWithProviderComposite composite = this.createComposite(file2, newEditors, newProviders);
                if (composite == null) {
                    return;
                }
                if (index >= 0) {
                    composite.getFile().putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)index);
                }
                compositeRef.set((Object)composite);
            }
            EditorWithProviderComposite composite = (EditorWithProviderComposite)compositeRef.get();
            FileEditor[] editors = composite.getEditors();
            FileEditorProvider[] providers = composite.getProviders();
            window.setEditor(composite, current, focusEditor);
            for (int i3 = 0; i3 < editors.length; ++i3) {
                this.restoreEditorState(file2, providers[i3], editors[i3], entry, newEditor);
            }
            FileEditorProvider selectedProvider = entry == null ? ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).getSelectedFileEditorProvider(EditorHistoryManager.getInstance(this.myProject), file2, providers) : entry.getSelectedProvider();
            if (selectedProvider != null) {
                for (int i4 = editors.length - 1; i4 >= 0; --i4) {
                    FileEditorProvider provider = providers[i4];
                    if (!provider.equals(selectedProvider)) continue;
                    composite.setSelectedEditor(i4);
                    break;
                }
            }
            window.getOwner().setCurrentWindow(window, focusEditor);
            window.getOwner().afterFileOpen(file2);
            this.addSelectionRecord(file2, window);
            composite.getSelectedEditor().selectNotify();
            if (!ApplicationManagerEx.getApplicationEx().isUnitTestMode() && focusEditor) {
                window.setAsCurrentWindow(true);
                ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
                IdeFocusManager.getInstance((Project)this.myProject).toFront((JComponent)((Object)window.getOwner()));
            }
            if (newEditor) {
                this.notifyPublisher(() -> {
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$null$7"));
                    }
                    if (this.isFileOpen(file2)) {
                        ((FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened((FileEditorManager)this, file2);
                    }
                });
                ourOpenFilesSetModificationCount.incrementAndGet();
            }
            ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(this.myProject)).onSelectionChanged();
            this.updateFileName(file2);
            IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
            if (pin != null) {
                window.setFilePinned(file2, pin);
            }
        };
        UIUtil.invokeAndWaitIfNeeded((Runnable)runnable2);
        EditorWithProviderComposite composite = (EditorWithProviderComposite)compositeRef.get();
        Pair pair = Pair.create((Object)(composite == null ? EMPTY_EDITOR_ARRAY : composite.getEditors()), (Object)(composite == null ? EMPTY_PROVIDER_ARRAY : composite.getProviders()));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openFileImpl4"));
        }
        return pair;
    }

    @Nullable
    private EditorWithProviderComposite createComposite(@NotNull VirtualFile file2, @NotNull FileEditor[] editors, @NotNull FileEditorProvider[] providers) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "createComposite"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "createComposite"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "createComposite"));
        }
        if (NullUtils.hasNull((Object[])editors) || NullUtils.hasNull((Object[])providers)) {
            ArrayList<FileEditor> editorList = new ArrayList<FileEditor>(editors.length);
            ArrayList<FileEditorProvider> providerList = new ArrayList<FileEditorProvider>(providers.length);
            for (int i2 = 0; i2 < editors.length; ++i2) {
                FileEditor editor = editors[i2];
                FileEditorProvider provider = providers[i2];
                if (editor == null || provider == null) continue;
                editorList.add(editor);
                providerList.add(provider);
            }
            if (editorList.isEmpty()) {
                return null;
            }
            editors = editorList.toArray(new FileEditor[editorList.size()]);
            providers = providerList.toArray(new FileEditorProvider[providerList.size()]);
        }
        return new EditorWithProviderComposite(file2, editors, providers, this);
    }

    private static void clearWindowIfNeeded(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "clearWindowIfNeeded"));
        }
        if (UISettings.getInstance().getEditorTabPlacement() == 0 || UISettings.getInstance().getPresentationMode()) {
            window.clear();
        }
    }

    private void restoreEditorState(@NotNull VirtualFile file2, @NotNull FileEditorProvider provider, @NotNull FileEditor editor, HistoryEntry entry, boolean newEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "restoreEditorState"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "restoreEditorState"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "restoreEditorState"));
        }
        FileEditorState state = null;
        if (entry != null) {
            state = entry.getState(provider);
        }
        if (state == null && newEditor) {
            state = EditorHistoryManager.getInstance(this.myProject).getState(file2, provider);
        }
        if (state != null) {
            if (!FileEditorManagerImpl.isDumbAware(editor)) {
                FileEditorState finalState = state;
                DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$restoreEditorState$9"));
                    }
                    editor.setState(finalState);
                });
            } else {
                editor.setState(state);
            }
        }
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "notifyPublisher"));
        }
        final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        final ActionCallback done2 = new ActionCallback();
        ActionCallback actionCallback = this.myBusyObject.execute(new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                focusManager.doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(FileEditorManagerImpl.this.myProject){

                    public void run() {
                        runnable2.run();
                        done2.setDone();
                    }
                });
                ActionCallback actionCallback = done2;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$5", "run"));
                }
                return actionCallback;
            }
        });
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "notifyPublisher"));
        }
        return actionCallback;
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "setSelectedEditor"));
        }
        if (fileEditorProviderId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorProviderId", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "setSelectedEditor"));
        }
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file2);
        if (composite == null) {
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            if (composites.isEmpty()) {
                return;
            }
            composite = composites.get(0);
        }
        FileEditorProvider[] editorProviders = composite.getProviders();
        FileEditorProvider selectedProvider = (FileEditorProvider)composite.getSelectedEditorWithProvider().getSecond();
        for (int i2 = 0; i2 < editorProviders.length; ++i2) {
            if (!editorProviders[i2].getEditorTypeId().equals(fileEditorProviderId) || selectedProvider.equals(editorProviders[i2])) continue;
            composite.setSelectedEditor(i2);
            composite.getSelectedEditor().selectNotify();
        }
    }

    @Nullable
    EditorWithProviderComposite newEditorComposite(VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        FileEditorProvider[] providers = editorProviderManager.getProviders(this.myProject, file2);
        if (providers.length == 0) {
            return null;
        }
        FileEditor[] editors = new FileEditor[providers.length];
        for (int i2 = 0; i2 < providers.length; ++i2) {
            FileEditor editor;
            FileEditorProvider provider = providers[i2];
            LOG.assertTrue(provider != null);
            LOG.assertTrue(provider.accept(this.myProject, file2));
            editors[i2] = editor = provider.createEditor(this.myProject, file2);
            LOG.assertTrue(editor.isValid());
            editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
        }
        EditorWithProviderComposite newComposite = new EditorWithProviderComposite(file2, editors, providers, this);
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance(this.myProject);
        for (int i3 = 0; i3 < editors.length; ++i3) {
            FileEditor editor = editors[i3];
            FileEditorProvider provider = providers[i3];
            FileEditorState state = editorHistoryManager.getState(file2, provider);
            if (state == null) continue;
            editor.setState(state);
        }
        return newComposite;
    }

    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openEditor"));
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (descriptor.getFile() instanceof VirtualFileWindow) {
            VirtualFileWindow delegate = (VirtualFileWindow)descriptor.getFile();
            int hostOffset = delegate.getDocumentWindow().injectedToHost(descriptor.getOffset());
            OpenFileDescriptor realDescriptor = new OpenFileDescriptor(descriptor.getProject(), delegate.getDelegate(), hostOffset);
            realDescriptor.setUseCurrentWindow(descriptor.isUseCurrentWindow());
            List<FileEditor> list = this.openEditor(realDescriptor, focusEditor);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openEditor"));
            }
            return list;
        }
        SmartList result2 = new SmartList();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.lambda$openEditor$10(descriptor, focusEditor, (List)result2), "", null);
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openEditor"));
        }
        return smartList;
    }

    private boolean navigateAndSelectEditor(@NotNull NavigatableFileEditor editor, @NotNull OpenFileDescriptor descriptor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "navigateAndSelectEditor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "navigateAndSelectEditor"));
        }
        if (editor.canNavigateTo((Navigatable)descriptor)) {
            this.setSelectedEditor((FileEditor)editor);
            editor.navigateTo((Navigatable)descriptor);
            return true;
        }
        return false;
    }

    private void setSelectedEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "setSelectedEditor"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite == null) {
            return;
        }
        FileEditor[] editors = composite.getEditors();
        for (int i2 = 0; i2 < editors.length; ++i2) {
            FileEditor each = editors[i2];
            if (editor != each) continue;
            composite.setSelectedEditor(i2);
            composite.getSelectedEditor().selectNotify();
            break;
        }
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getProject"));
        }
        return project2;
    }

    @Nullable
    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "openTextEditor"));
        }
        List<FileEditor> fileEditors = this.openEditor(descriptor, focusEditor);
        for (FileEditor fileEditor : fileEditors) {
            if (!(fileEditor instanceof TextEditor)) continue;
            this.setSelectedEditor(descriptor.getFile(), TextEditorProvider.getInstance().getEditorTypeId());
            Editor editor = ((TextEditor)fileEditor).getEditor();
            return this.getOpenedEditor(editor, focusEditor);
        }
        return null;
    }

    protected Editor getOpenedEditor(@NotNull Editor editor, boolean focusEditor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getOpenedEditor"));
        }
        return editor;
    }

    public Editor getSelectedTextEditor() {
        return this.getSelectedTextEditor(false);
    }

    public Editor getSelectedTextEditor(boolean lockfree) {
        EditorWithProviderComposite selectedEditor;
        EditorWindow currentWindow;
        if (!lockfree) {
            FileEditorManagerImpl.assertDispatchThread();
        }
        EditorWindow editorWindow = currentWindow = lockfree ? this.getMainSplitters().getCurrentWindow() : this.getSplitters().getCurrentWindow();
        if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && selectedEditor.getSelectedEditor() instanceof TextEditor) {
            return ((TextEditor)selectedEditor.getSelectedEditor()).getEditor();
        }
        return null;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "isFileOpen"));
        }
        return !this.getEditorComposites(file2).isEmpty();
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        THashSet openFiles = new THashSet();
        for (EditorsSplitters each : this.getAllSplitters()) {
            openFiles.addAll(Arrays.asList(each.getOpenFiles()));
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)openFiles);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getOpenFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        LinkedHashSet<VirtualFile> selectedFiles = new LinkedHashSet<VirtualFile>();
        EditorsSplitters activeSplitters = this.getSplitters();
        selectedFiles.addAll(Arrays.asList(activeSplitters.getSelectedFiles()));
        for (EditorsSplitters each : this.getAllSplitters()) {
            if (each == activeSplitters) continue;
            selectedFiles.addAll(Arrays.asList(each.getSelectedFiles()));
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(selectedFiles);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSelectedFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        HashSet<FileEditor> selectedEditors = new HashSet<FileEditor>();
        for (EditorsSplitters each : this.getAllSplitters()) {
            selectedEditors.addAll(Arrays.asList(each.getSelectedEditors()));
        }
        FileEditor[] fileEditorArray = selectedEditors.toArray(new FileEditor[selectedEditors.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSelectedEditors"));
        }
        return fileEditorArray;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        EditorsSplitters active = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            active = this.getActiveSplittersSync();
        }
        EditorsSplitters editorsSplitters = active == null ? this.getMainSplitters() : active;
        if (editorsSplitters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSplitters"));
        }
        return editorsSplitters;
    }

    @Nullable
    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSelectedEditor"));
        }
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider = this.getSelectedEditorWithProvider(file2);
        return selectedEditorWithProvider == null ? null : (FileEditor)selectedEditorWithProvider.getFirst();
    }

    @Override
    @Nullable
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSelectedEditorWithProvider"));
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2)) != null) {
            return composite.getSelectedEditorWithProvider();
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        return composites.isEmpty() ? null : composites.get(0).getSelectedEditorWithProvider();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorsWithProviders"));
        }
        FileEditorManagerImpl.assertReadAccess();
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file2);
        if (composite != null) {
            Pair pair = Pair.create((Object)composite.getEditors(), (Object)composite.getProviders());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorsWithProviders"));
            }
            return pair;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            Pair pair = Pair.create((Object)composites.get(0).getEditors(), (Object)composites.get(0).getProviders());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorsWithProviders"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorsWithProviders"));
        }
        return pair;
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditors"));
        }
        FileEditorManagerImpl.assertReadAccess();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2)) != null) {
            FileEditor[] fileEditorArray = composite.getEditors();
            if (fileEditorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditors"));
            }
            return fileEditorArray;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            FileEditor[] fileEditorArray = composites.get(0).getEditors();
            if (fileEditorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditors"));
            }
            return fileEditorArray;
        }
        if (EMPTY_EDITOR_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditors"));
        }
        return EMPTY_EDITOR_ARRAY;
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getAllEditors"));
        }
        List<EditorWithProviderComposite> editorComposites = this.getEditorComposites(file2);
        if (editorComposites.isEmpty()) {
            if (EMPTY_EDITOR_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getAllEditors"));
            }
            return EMPTY_EDITOR_ARRAY;
        }
        ArrayList editors = new ArrayList();
        for (EditorWithProviderComposite composite : editorComposites) {
            ContainerUtil.addAll(editors, (Object[])composite.getEditors());
        }
        FileEditor[] fileEditorArray = editors.toArray(new FileEditor[editors.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getAllEditors"));
        }
        return fileEditorArray;
    }

    @Nullable
    private EditorWithProviderComposite getCurrentEditorWithProviderComposite(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getCurrentEditorWithProviderComposite"));
        }
        EditorWindow editorWindow = this.getSplitters().getCurrentWindow();
        if (editorWindow != null) {
            return editorWindow.findFileComposite(virtualFile);
        }
        return null;
    }

    @NotNull
    private List<EditorWithProviderComposite> getEditorComposites(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorComposites"));
        }
        ArrayList<EditorWithProviderComposite> result2 = new ArrayList<EditorWithProviderComposite>();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            result2.addAll(each.findEditorComposites(file2));
        }
        ArrayList<EditorWithProviderComposite> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorComposites"));
        }
        return arrayList;
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        FileEditorManagerImpl.assertReadAccess();
        ArrayList result2 = new ArrayList();
        Set<EditorsSplitters> allSplitters = this.getAllSplitters();
        for (EditorsSplitters splitter : allSplitters) {
            EditorWithProviderComposite[] editorsComposites;
            for (EditorWithProviderComposite editorsComposite : editorsComposites = splitter.getEditorsComposites()) {
                Object[] editors = editorsComposite.getEditors();
                ContainerUtil.addAll(result2, (Object[])editors);
            }
        }
        FileEditor[] fileEditorArray = result2.toArray(new FileEditor[result2.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getAllEditors"));
        }
        return fileEditorArray;
    }

    public void showEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "showEditorAnnotation"));
        }
        if (annotationComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationComponent", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "showEditorAnnotation"));
        }
        this.addTopComponent(editor, annotationComponent);
    }

    public void removeEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeEditorAnnotation"));
        }
        if (annotationComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationComponent", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeEditorAnnotation"));
        }
        this.removeTopComponent(editor, annotationComponent);
    }

    @NotNull
    public List<JComponent> getTopComponents(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getTopComponents"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        List<JComponent> list = composite != null ? composite.getTopComponents(editor) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getTopComponents"));
        }
        return list;
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addTopComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addTopComponent"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addTopComponent(editor, component);
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeTopComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeTopComponent"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeTopComponent(editor, component);
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addBottomComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addBottomComponent"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addBottomComponent(editor, component);
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeBottomComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeBottomComponent"));
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeBottomComponent(editor, component);
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addFileEditorManagerListener"));
        }
        this.myListenerList.add((Object)listener2);
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addFileEditorManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addFileEditorManagerListener"));
        }
        this.myListenerList.add((Object)listener2, parentDisposable);
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeFileEditorManagerListener"));
        }
        this.myListenerList.remove((Object)listener2);
    }

    protected void projectOpened(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "projectOpened"));
        }
        this.getMainSplitters().startListeningFocus();
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            MyFileStatusListener myFileStatusListener = new MyFileStatusListener();
            fileStatusManager.addFileStatusListener((FileStatusListener)myFileStatusListener, (Disposable)this.myProject);
        }
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootsListener());
        MyVirtualFileListener myVirtualFileListener = new MyVirtualFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myVirtualFileListener, (Disposable)this.myProject);
        connection.subscribe(UISettingsListener.TOPIC, (Object)new MyUISettingsListener());
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.setTabsMode(UISettings.getInstance().getEditorTabPlacement() != 0);
            ToolWindowManager.getInstance((Project)this.myProject).invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().invokeLater(() -> {
                        long currentTime = System.nanoTime();
                        Long startTime = (Long)this.myProject.getUserData(ProjectImpl.CREATION_TIME);
                        if (startTime != null) {
                            LOG.info("Project opening took " + (currentTime - startTime) / 1000000L + " ms");
                            PluginManagerCore.dumpPluginClassStatistics();
                        }
                    }, this.myProject.getDisposed()), "", null);
                }
            });
        }));
    }

    @Nullable
    public Element getState() {
        if (this.mySplitters == null) {
            return null;
        }
        Element state = new Element("state");
        this.getMainSplitters().writeExternal(state);
        return state;
    }

    public void loadState(Element state) {
        this.getMainSplitters().readExternal(state);
    }

    @Nullable
    private EditorWithProviderComposite getEditorComposite(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getEditorComposite"));
        }
        for (EditorsSplitters splitters : this.getAllSplitters()) {
            EditorWithProviderComposite[] editorsComposites = splitters.getEditorsComposites();
            for (int i2 = editorsComposites.length - 1; i2 >= 0; --i2) {
                EditorWithProviderComposite composite = editorsComposites[i2];
                FileEditor[] editors = composite.getEditors();
                for (int j = editors.length - 1; j >= 0; --j) {
                    FileEditor _editor = editors[j];
                    LOG.assertTrue(_editor != null);
                    if (!editor.equals(_editor)) continue;
                    return composite;
                }
            }
        }
        return null;
    }

    private static void assertDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    public void fireSelectionChanged(EditorComposite newSelectedComposite) {
        boolean editorsEqual;
        boolean filesEqual;
        Trinity<VirtualFile, FileEditor, FileEditorProvider> oldData = FileEditorManagerImpl.extract((EditorComposite)SoftReference.dereference(this.myLastSelectedComposite));
        Trinity<VirtualFile, FileEditor, FileEditorProvider> newData = FileEditorManagerImpl.extract(newSelectedComposite);
        WeakReference<EditorComposite> weakReference = this.myLastSelectedComposite = newSelectedComposite == null ? null : new WeakReference<EditorComposite>(newSelectedComposite);
        boolean bl = oldData.first == null ? newData.first == null : (filesEqual = ((VirtualFile)oldData.first).equals(newData.first));
        boolean bl2 = oldData.second == null ? newData.second == null : (editorsEqual = ((FileEditor)oldData.second).equals(newData.second));
        if (!filesEqual || !editorsEqual) {
            JComponent component;
            EditorWindowHolder holder;
            if (oldData.first != null && newData.first != null) {
                for (FileEditorAssociateFinder finder : (FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)) {
                    VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, (VirtualFile)oldData.first);
                    if (!Comparing.equal((Object)associatedFile, (Object)newData.first)) continue;
                    return;
                }
            }
            FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, (VirtualFile)oldData.first, (FileEditor)oldData.second, (FileEditorProvider)oldData.third, (VirtualFile)newData.first, (FileEditor)newData.second, (FileEditorProvider)newData.third);
            FileEditorManagerListener publisher = (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
            if (newData.first != null && (holder = (EditorWindowHolder)UIUtil.getParentOfType(EditorWindowHolder.class, (Component)(component = ((FileEditor)newData.second).getComponent()))) != null) {
                this.addSelectionRecord((VirtualFile)newData.first, holder.getEditorWindow());
            }
            this.notifyPublisher(() -> publisher.selectionChanged(event));
        }
    }

    @NotNull
    private static Trinity<VirtualFile, FileEditor, FileEditorProvider> extract(@Nullable EditorComposite composite) {
        FileEditorProvider provider;
        FileEditor editor;
        VirtualFile file2;
        if (composite == null || composite.isDisposed()) {
            file2 = null;
            editor = null;
            provider = null;
        } else {
            file2 = composite.getFile();
            Pair<FileEditor, FileEditorProvider> pair = composite.getSelectedEditorWithProvider();
            editor = (FileEditor)pair.first;
            provider = (FileEditorProvider)pair.second;
        }
        Trinity trinity = new Trinity((Object)file2, (Object)editor, provider);
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "extract"));
        }
        return trinity;
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "isChanged"));
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager == null) {
            return false;
        }
        FileStatus status = fileStatusManager.getStatus(editor.getFile());
        return status != FileStatus.UNKNOWN && status != FileStatus.NOT_CHANGED;
    }

    void disposeComposite(@NotNull EditorWithProviderComposite editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "disposeComposite"));
        }
        if (this.getAllEditors().length == 0) {
            this.setCurrentWindow(null);
        }
        if (editor.equals(this.getLastSelected())) {
            editor.getSelectedEditor().deselectNotify();
            this.getSplitters().setCurrentWindow(null, false);
        }
        FileEditor[] editors = editor.getEditors();
        FileEditorProvider[] providers = editor.getProviders();
        FileEditor selectedEditor = editor.getSelectedEditor();
        for (int i2 = editors.length - 1; i2 >= 0; --i2) {
            FileEditor editor1 = editors[i2];
            FileEditorProvider provider = providers[i2];
            if (!editor.equals(selectedEditor) && selectedEditor.equals(editor1)) {
                editor1.deselectNotify();
            }
            editor1.removePropertyChangeListener(this.myEditorPropertyChangeListener);
            provider.disposeEditor(editor1);
        }
        Disposer.dispose((Disposable)editor);
    }

    @Nullable
    private EditorComposite getLastSelected() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            return currentWindow.getSelectedEditor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runChange(@NotNull FileEditorManagerChange change, @Nullable EditorsSplitters splitters) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "runChange"));
        }
        HashSet<EditorsSplitters> target = new HashSet<EditorsSplitters>();
        if (splitters == null) {
            target.addAll(this.getAllSplitters());
        } else {
            target.add(splitters);
        }
        for (EditorsSplitters each : target) {
            ++each.myInsideChange;
            try {
                change.run(each);
            }
            finally {
                --each.myInsideChange;
            }
        }
    }

    private static boolean moveFocusOnDelete() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            Component component = FocusTrackback.getFocusFor(window);
            if (component != null) {
                return component instanceof EditorComponentImpl;
            }
            return window instanceof IdeFrameImpl;
        }
        return true;
    }

    @Override
    public boolean isInsideChange() {
        return this.getSplitters().isInsideChange();
    }

    @Override
    public void closeAllFiles() {
        VirtualFile[] openFiles;
        for (VirtualFile openFile2 : openFiles = this.getSplitters().getOpenFiles()) {
            this.closeFile(openFile2);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSiblings"));
        }
        VirtualFile[] virtualFileArray = this.getOpenFiles();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSiblings"));
        }
        return virtualFileArray;
    }

    void queueUpdateFile(final @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "queueUpdateFile"));
        }
        this.myQueue.queue(new Update(file2){

            public void run() {
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileColor(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                }
            }
        });
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        EditorsSplitters splitters = null;
        DockContainer dockContainer = this.myDockManager.getContainerFor(c);
        if (dockContainer instanceof DockableEditorTabbedContainer) {
            splitters = ((DockableEditorTabbedContainer)dockContainer).getSplitters();
        }
        if (splitters == null) {
            splitters = this.getMainSplitters();
        }
        return splitters;
    }

    @NotNull
    public List<Pair<VirtualFile, EditorWindow>> getSelectionHistory() {
        ArrayList<Object> copy = new ArrayList<Object>();
        for (Pair<VirtualFile, EditorWindow> pair : this.mySelectionHistory) {
            if (((EditorWindow)pair.second).getFiles().length == 0) {
                Pair p;
                EditorWindow[] windows = ((EditorWindow)pair.second).getOwner().getWindows();
                if (windows.length <= 0 || windows[0] == null || windows[0].getFiles().length <= 0 || copy.contains(p = Pair.create((Object)pair.first, (Object)windows[0]))) continue;
                copy.add(p);
                continue;
            }
            if (copy.contains(pair)) continue;
            copy.add(pair);
        }
        this.mySelectionHistory.clear();
        this.mySelectionHistory.addAll(copy);
        List<Pair<VirtualFile, EditorWindow>> list = this.mySelectionHistory;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getSelectionHistory"));
        }
        return list;
    }

    public void addSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addSelectionRecord"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "addSelectionRecord"));
        }
        Pair record = Pair.create((Object)file2, (Object)window);
        this.mySelectionHistory.remove(record);
        this.mySelectionHistory.add(0, (Pair<VirtualFile, EditorWindow>)record);
    }

    void removeSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeSelectionRecord"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "removeSelectionRecord"));
        }
        this.mySelectionHistory.remove(Pair.create((Object)file2, (Object)window));
        this.updateFileName(file2);
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getReady"));
        }
        ActionCallback actionCallback = this.myBusyObject.getReady(requestor);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "getReady"));
        }
        return actionCallback;
    }

    private /* synthetic */ void lambda$openEditor$10(@NotNull OpenFileDescriptor descriptor, boolean focusEditor, List result2) {
        Object editor;
        int n;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl", "lambda$openEditor$10"));
        }
        VirtualFile file2 = descriptor.getFile();
        Object[] editors = this.openFile(file2, focusEditor, !descriptor.isUseCurrentWindow());
        ContainerUtil.addAll((Collection)result2, (Object[])editors);
        boolean navigated = false;
        Object[] objectArray = editors;
        int n2 = objectArray.length;
        for (n = 0; !(n >= n2 || (editor = objectArray[n]) instanceof NavigatableFileEditor && this.getSelectedEditor(descriptor.getFile()) == editor && (navigated = this.navigateAndSelectEditor((NavigatableFileEditor)editor, descriptor))); ++n) {
        }
        if (!navigated) {
            objectArray = editors;
            n2 = objectArray.length;
            for (n = 0; !(n >= n2 || (editor = objectArray[n]) instanceof NavigatableFileEditor && this.getSelectedEditor(descriptor.getFile()) != editor && this.navigateAndSelectEditor((NavigatableFileEditor)editor, descriptor)); ++n) {
            }
        }
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings uiSettings) {
            FileEditorManagerImpl.assertDispatchThread();
            FileEditorManagerImpl.this.setTabsMode(uiSettings.getEditorTabPlacement() != 0 && !uiSettings.getPresentationMode());
            for (EditorsSplitters each : FileEditorManagerImpl.this.getAllSplitters()) {
                each.setTabsPlacement(uiSettings.getEditorTabPlacement());
                each.trimToSize(uiSettings.EDITOR_TAB_LIMIT);
                if (uiSettings.getScrollTabLayoutInEditor()) {
                    each.setTabLayoutPolicy(1);
                    continue;
                }
                each.setTabLayoutPolicy(0);
            }
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                VirtualFile file2 = openFiles[i2];
                FileEditorManagerImpl.this.updateFileIcon(file2);
                FileEditorManagerImpl.this.updateFileName(file2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
            }
        }
    }

    private class MyRootsListener
    implements ModuleRootListener {
        private boolean myScheduled;

        private MyRootsListener() {
        }

        public void rootsChanged(ModuleRootEvent event) {
            if (this.myScheduled) {
                return;
            }
            this.myScheduled = true;
            DumbService.getInstance((Project)FileEditorManagerImpl.this.myProject).runWhenSmart(() -> {
                this.myScheduled = false;
                this.handleRootChange();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRootChange() {
            EditorFileSwapper[] swappers = (EditorFileSwapper[])Extensions.getExtensions(EditorFileSwapper.EP_NAME);
            for (EditorWindow eachWindow : FileEditorManagerImpl.this.getWindows()) {
                EditorWithProviderComposite selected = eachWindow.getSelectedEditor();
                EditorWithProviderComposite[] editors = eachWindow.getEditors();
                for (int i2 = 0; i2 < editors.length; ++i2) {
                    VirtualFile newFile;
                    EditorFileSwapper each;
                    EditorWithProviderComposite editor = editors[i2];
                    VirtualFile file2 = editor.getFile();
                    if (!file2.isValid()) continue;
                    Pair<VirtualFile, Integer> newFilePair = null;
                    EditorFileSwapper[] editorFileSwapperArray = swappers;
                    int n = editorFileSwapperArray.length;
                    for (int j = 0; j < n && (newFilePair = (each = editorFileSwapperArray[j]).getFileToSwapTo(FileEditorManagerImpl.this.myProject, editor)) == null; ++j) {
                    }
                    if (newFilePair == null || (newFile = (VirtualFile)newFilePair.first) == null || eachWindow.findFileIndex(newFile) != -1) continue;
                    try {
                        TextEditorImpl openedEditor;
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)i2);
                        Pair<FileEditor[], FileEditorProvider[]> pair = FileEditorManagerImpl.this.openFileImpl2(eachWindow, newFile, editor == selected);
                        if (newFilePair.second != null && (openedEditor = EditorFileSwapper.findSinglePsiAwareEditor((FileEditor[])pair.first)) != null) {
                            openedEditor.getEditor().getCaretModel().moveToOffset(((Integer)newFilePair.second).intValue());
                            openedEditor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                        }
                    }
                    finally {
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, null);
                    }
                    FileEditorManagerImpl.this.closeFile(file2, eachWindow);
                }
            }
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileTypeListener", "fileTypesChanged"));
            }
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                VirtualFile file2 = openFiles[i2];
                LOG.assertTrue(file2 != null);
                FileEditorManagerImpl.this.updateFileIcon(file2);
            }
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            FileEditorManagerImpl.assertDispatchThread();
            LOG.debug("FileEditorManagerImpl.MyFileStatusListener.fileStatusesChanged()");
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                VirtualFile file2 = openFiles[i2];
                LOG.assertTrue(file2 != null);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("updating file status in tab for " + file2.getPath());
                    }
                    this.updateFileStatus(file2);
                }, ModalityState.NON_MODAL, FileEditorManagerImpl.this.myProject.getDisposed());
            }
        }

        public void fileStatusChanged(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileStatusListener", "fileStatusChanged"));
            }
            FileEditorManagerImpl.assertDispatchThread();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                this.updateFileStatus(file2);
            }
        }

        private void updateFileStatus(VirtualFile file2) {
            FileEditorManagerImpl.this.updateFileColor(file2);
            FileEditorManagerImpl.this.updateFileIcon(file2);
        }
    }

    private final class MyEditorPropertyChangeListener
    implements PropertyChangeListener {
        private MyEditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent e) {
            boolean valid;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyEditorPropertyChangeListener", "propertyChange"));
            }
            FileEditorManagerImpl.assertDispatchThread();
            String propertyName = e.getPropertyName();
            if ("modified".equals(propertyName)) {
                FileEditor editor = (FileEditor)e.getSource();
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.updateFileIcon(composite.getFile());
                }
            } else if ("valid".equals(propertyName) && !(valid = ((Boolean)e.getNewValue()).booleanValue())) {
                FileEditor editor = (FileEditor)e.getSource();
                LOG.assertTrue(editor != null);
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.closeFile(composite.getFile());
                }
            }
        }
    }

    private final class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyVirtualFileListener", "beforeFileDeletion"));
            }
            FileEditorManagerImpl.assertDispatchThread();
            boolean moveFocus = FileEditorManagerImpl.moveFocusOnDelete();
            VirtualFile file2 = e.getFile();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)openFiles[i2], (boolean)false)) continue;
                FileEditorManagerImpl.this.closeFile(openFiles[i2], moveFocus, true);
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyVirtualFileListener", "propertyChanged"));
            }
            if ("name".equals(e.getPropertyName())) {
                FileEditorManagerImpl.assertDispatchThread();
                VirtualFile file2 = e.getFile();
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileName(file2);
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                }
            } else if ("writable".equals(e.getPropertyName()) || "encoding".equals(e.getPropertyName())) {
                this.updateIconAndStatusBar(e);
            }
        }

        private void updateIconAndStatusBar(VirtualFilePropertyEvent e) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file2 = e.getFile();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                FileEditorManagerImpl.this.updateFileIcon(file2);
                if (file2.equals(FileEditorManagerImpl.this.getSelectedFiles()[0])) {
                    StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(FileEditorManagerImpl.this.myProject);
                    assert (statusBar != null);
                    statusBar.updateWidgets();
                }
            }
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent e) {
            VirtualFile[] openFiles;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyVirtualFileListener", "fileMoved"));
            }
            VirtualFile file2 = e.getFile();
            for (VirtualFile openFile2 : openFiles = FileEditorManagerImpl.this.getOpenFiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)openFile2, (boolean)false)) continue;
                FileEditorManagerImpl.this.updateFileName(openFile2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(openFile2);
            }
        }
    }

    private static class MyBorder
    implements Border {
        private MyBorder() {
        }

        @Override
        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyBorder", "paintBorder"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyBorder", "paintBorder"));
            }
            if (UIUtil.isUnderAquaLookAndFeel()) {
                g.setColor(JBTabsImpl.MAC_AQUA_BG_COLOR);
                Insets insets = this.getBorderInsets(c);
                if (insets.top > 0) {
                    g.fillRect(x, y, width, height + insets.top);
                }
            }
        }

        @Override
        @NotNull
        public Insets getBorderInsets(Component c) {
            JBInsets jBInsets = JBUI.emptyInsets();
            if (jBInsets == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyBorder", "getBorderInsets"));
            }
            return jBInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

