/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class UniqueNameEditorTabTitleProvider
implements EditorTabTitleProvider {
    @Override
    public String getEditorTabTitle(Project project2, VirtualFile file2) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings == null || !uiSettings.SHOW_DIRECTORY_FOR_NON_UNIQUE_FILENAMES || DumbService.isDumb((Project)project2)) {
            return null;
        }
        String uniqueName = uiSettings.getEditorTabPlacement() == 0 ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project2, file2) : UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePathWithinOpenedFileEditors(project2, file2);
        uniqueName = UniqueNameEditorTabTitleProvider.getEditorTabText(uniqueName, File.separator, uiSettings.HIDE_KNOWN_EXTENSION_IN_TABS);
        return uniqueName.equals(file2.getName()) ? null : uniqueName;
    }

    public static String getEditorTabText(String result2, String separator, boolean hideKnownExtensionInTabs) {
        String withoutExtension;
        if (hideKnownExtensionInTabs && StringUtil.isNotEmpty((String)(withoutExtension = FileUtil.getNameWithoutExtension((String)result2))) && !withoutExtension.endsWith(separator)) {
            return withoutExtension;
        }
        return result2;
    }
}

