/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Producer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorProvider
extends TextEditorProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider");
    @NonNls
    private static final String FOLDING_ELEMENT = "folding";

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditor"));
        }
        PsiAwareTextEditorImpl psiAwareTextEditorImpl = new PsiAwareTextEditorImpl(project2, file2, this);
        if (psiAwareTextEditorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createEditor"));
        }
        return psiAwareTextEditorImpl;
    }

    @Override
    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project2, @NotNull VirtualFile file2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        TextEditorState state = (TextEditorState)super.readState(element, project2, file2);
        Element child = element.getChild(FOLDING_ELEMENT);
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (child != null) {
            if (document == null) {
                Element detachedStateCopy = child.clone();
                state.setDelayedFoldState((Producer<CodeFoldingState>)((Producer)() -> {
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "lambda$readState$0"));
                    }
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "lambda$readState$0"));
                    }
                    Document document1 = FileDocumentManager.getInstance().getCachedDocument(file2);
                    return document1 == null ? null : CodeFoldingManager.getInstance(project2).readFoldingState(detachedStateCopy, document1);
                }));
            } else {
                state.setFoldingState(CodeFoldingManager.getInstance(project2).readFoldingState(child, document));
            }
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "readState"));
        }
        return textEditorState;
    }

    @Override
    public void writeState(@NotNull FileEditorState _state, @NotNull Project project2, @NotNull Element element) {
        if (_state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_state", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "writeState"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "writeState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "writeState"));
        }
        super.writeState(_state, project2, element);
        TextEditorState state = (TextEditorState)_state;
        CodeFoldingState foldingState = state.getFoldingState();
        if (foldingState != null) {
            Element e = new Element(FOLDING_ELEMENT);
            try {
                CodeFoldingManager.getInstance(project2).writeFoldingState(foldingState, e);
            }
            catch (WriteExternalException writeExternalException) {
                // empty catch block
            }
            element.addContent(e);
        }
    }

    @Override
    protected TextEditorState getStateImpl(Project project2, @NotNull Editor editor, @NotNull FileEditorStateLevel level) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "getStateImpl"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "getStateImpl"));
        }
        TextEditorState state = super.getStateImpl(project2, editor, level);
        if (FileEditorStateLevel.FULL == level) {
            if (project2 != null && !project2.isDisposed() && !editor.isDisposed() && project2.isInitialized()) {
                state.setFoldingState(CodeFoldingManager.getInstance(project2).saveFoldingState(editor));
            } else {
                state.setFoldingState(null);
            }
        }
        return state;
    }

    @Override
    protected void setStateImpl(Project project2, Editor editor, TextEditorState state) {
        super.setStateImpl(project2, editor, state);
        CodeFoldingState foldState = state.getFoldingState();
        if (project2 != null && foldState != null && AsyncEditorLoader.isEditorLoaded(editor)) {
            if (!PsiDocumentManager.getInstance((Project)project2).isCommitted(editor.getDocument())) {
                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                LOG.error("File should be parsed when changing editor state, otherwise UI might be frozen for a considerable time");
            }
            editor.getFoldingModel().runBatchFoldingOperation(() -> CodeFoldingManager.getInstance(project2).restoreFoldingState(editor, foldState));
        }
    }

    @Override
    @NotNull
    protected TextEditorProvider.EditorWrapper createWrapperForEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createWrapperForEditor"));
        }
        PsiAwareEditorWrapper psiAwareEditorWrapper = new PsiAwareEditorWrapper(editor);
        if (psiAwareEditorWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider", "createWrapperForEditor"));
        }
        return psiAwareEditorWrapper;
    }

    private final class PsiAwareEditorWrapper
    extends TextEditorProvider.EditorWrapper {
        private final TextEditorBackgroundHighlighter myBackgroundHighlighter;

        private PsiAwareEditorWrapper(Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider$PsiAwareEditorWrapper", "<init>"));
            }
            super(editor);
            Project project2 = editor.getProject();
            this.myBackgroundHighlighter = project2 == null ? null : new TextEditorBackgroundHighlighter(project2, editor);
        }

        @Override
        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return this.myBackgroundHighlighter;
        }

        @Override
        public boolean isValid() {
            return !this.getEditor().isDisposed();
        }
    }
}

