/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NotNull;

public class GenericKeymapManager
extends DefaultKeymap {
    @Override
    @NotNull
    public String getDefaultKeymapName() {
        if (SystemInfo.isMac) {
            if ("Mac OS X 10.5+" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/GenericKeymapManager", "getDefaultKeymapName"));
            }
            return "Mac OS X 10.5+";
        }
        if (SystemInfo.isXWindow) {
            if ("Default for XWin" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/GenericKeymapManager", "getDefaultKeymapName"));
            }
            return "Default for XWin";
        }
        if ("$default" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/GenericKeymapManager", "getDefaultKeymapName"));
        }
        return "$default";
    }

    @Override
    @NotNull
    public String getKeymapPresentableName(@NotNull KeymapImpl keymap) {
        if (keymap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymap", "com/intellij/openapi/keymap/impl/GenericKeymapManager", "getKeymapPresentableName"));
        }
        String name = keymap.getName();
        if (this.getDefaultKeymapName().equals(name)) {
            if ("Default" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/GenericKeymapManager", "getKeymapPresentableName"));
            }
            return "Default";
        }
        if ("$default".equals(name)) {
            String string = "IntelliJ IDEA Classic" + (SystemInfo.isMac ? " (Windows)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/GenericKeymapManager", "getKeymapPresentableName"));
            }
            return string;
        }
        if ("Mac OS X".equals(name)) {
            if ("IntelliJ IDEA Classic (OS X)" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/GenericKeymapManager", "getKeymapPresentableName"));
            }
            return "IntelliJ IDEA Classic (OS X)";
        }
        String string = super.getKeymapPresentableName(keymap);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/GenericKeymapManager", "getKeymapPresentableName"));
        }
        return string;
    }
}

