/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.paths.DynamicContextProvider;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;

public class GenericDynamicContextProvider
implements DynamicContextProvider {
    @Override
    public int getOffset(PsiElement element, int offset, String elementText) {
        PsiElement[] children2;
        for (PsiElement child : children2 = element.getChildren()) {
            if (!this.isDynamic(child)) continue;
            int i2 = child.getStartOffsetInParent();
            if (i2 == offset) {
                PsiElement next = child.getNextSibling();
                if (next == null || !next.getText().startsWith("/")) {
                    return -1;
                }
                offset = next.getStartOffsetInParent();
                continue;
            }
            int pos = PathReferenceProviderBase.getLastPosOfURL(offset, elementText);
            if (pos == -1 || pos > i2) {
                return -1;
            }
            return offset;
        }
        return offset;
    }

    protected boolean isDynamic(PsiElement child) {
        return child instanceof OuterLanguageElement;
    }
}

