/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReadTask {
    public void computeInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/util/ReadTask", "computeInReadAction"));
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/util/ReadTask", "performInReadAction"));
        }
        this.computeInReadAction(indicator);
        return null;
    }

    public abstract void onCanceled(@NotNull ProgressIndicator var1);

    public Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/util/ReadTask", "runBackgroundProcess"));
        }
        return (Continuation)ReadAction.compute(() -> {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/util/ReadTask", "lambda$runBackgroundProcess$0"));
            }
            return this.performInReadAction(indicator);
        });
    }

    public static final class Continuation {
        private final Runnable myAction;
        private final ModalityState myModalityState;

        public Continuation(@NotNull Runnable action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ReadTask$Continuation", "<init>"));
            }
            this(action, ModalityState.defaultModalityState());
        }

        public Continuation(@NotNull Runnable action, @NotNull ModalityState modalityState) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ReadTask$Continuation", "<init>"));
            }
            if (modalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/util/ReadTask$Continuation", "<init>"));
            }
            this.myAction = action;
            this.myModalityState = modalityState;
        }

        @NotNull
        public ModalityState getModalityState() {
            ModalityState modalityState = this.myModalityState;
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ReadTask$Continuation", "getModalityState"));
            }
            return modalityState;
        }

        @NotNull
        public Runnable getAction() {
            Runnable runnable2 = this.myAction;
            if (runnable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ReadTask$Continuation", "getAction"));
            }
            return runnable2;
        }
    }
}

