/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.UndefinedMacrosConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.WaitForProgressToShow;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProjectMacrosUtil {
    private ProjectMacrosUtil() {
    }

    public static boolean showMacrosConfigurationDialog(Project project2, Collection<String> undefinedMacros) {
        String text = ProjectBundle.message((String)"project.load.undefined.path.variables.message", (Object[])new Object[0]);
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment() || application.isUnitTestMode()) {
            throw new RuntimeException(text + ": " + StringUtil.join(undefinedMacros, (String)", "));
        }
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)new UndefinedMacrosConfigurable(text, undefinedMacros));
    }

    public static boolean checkNonIgnoredMacros(Project project2, Set<String> usedMacros) {
        PathMacros pathMacros = PathMacros.getInstance();
        Iterator<String> iterator = usedMacros.iterator();
        while (iterator.hasNext()) {
            if (!pathMacros.isIgnoredMacroName(iterator.next())) continue;
            iterator.remove();
        }
        return ProjectMacrosUtil.checkMacros(project2, usedMacros);
    }

    public static boolean checkMacros(@NotNull Project project2, @NotNull Set<String> usedMacros) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectMacrosUtil", "checkMacros"));
        }
        if (usedMacros == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedMacros", "com/intellij/openapi/project/impl/ProjectMacrosUtil", "checkMacros"));
        }
        PathMacros pathMacros = PathMacros.getInstance();
        usedMacros.removeAll(pathMacros.getSystemMacroNames());
        usedMacros.removeAll(pathMacros.getUserMacroNames());
        String pathMacroSystemPrefix = "path.macro.";
        Iterator<String> it = usedMacros.iterator();
        while (it.hasNext()) {
            String macro = it.next();
            String value = System.getProperty(pathMacroSystemPrefix + macro, null);
            if (value == null) continue;
            pathMacros.setMacro(macro, value);
            it.remove();
        }
        if (usedMacros.isEmpty()) {
            return true;
        }
        boolean[] result2 = new boolean[1];
        WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/impl/ProjectMacrosUtil", "lambda$checkMacros$0"));
            }
            if (usedMacros == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedMacros", "com/intellij/openapi/project/impl/ProjectMacrosUtil", "lambda$checkMacros$0"));
            }
            result2[0] = ProjectMacrosUtil.showMacrosConfigurationDialog(project2, usedMacros);
        }, (ModalityState)ModalityState.NON_MODAL);
        return result2[0];
    }
}

