/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.messages.MessageBus;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("language_level_persistence", 3, true);

    public static void pushLanguageLevel(@NotNull Project project2) {
        FilePropertyPusher[] extensions;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "pushLanguageLevel"));
        }
        PushedFilePropertiesUpdater instance = PushedFilePropertiesUpdater.getInstance((Project)project2);
        for (FilePropertyPusher pusher : extensions = (FilePropertyPusher[])EP_NAME.getExtensions()) {
            if (!(pusher instanceof JavaLanguageLevelPusher)) continue;
            instance.pushAll(new FilePropertyPusher[]{pusher});
        }
    }

    public void initExtra(@NotNull Project project2, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "initExtra"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "initExtra"));
        }
        if (languageLevelUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevelUpdater", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "initExtra"));
        }
    }

    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        Key key2 = LanguageLevel.KEY;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getFileDataKey"));
        }
        return key2;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getDefaultValue"));
        }
        return languageLevel;
    }

    public LanguageLevel getImmediateValue(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getImmediateValue"));
        }
        return null;
    }

    public LanguageLevel getImmediateValue(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getImmediateValue"));
        }
        return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module2);
    }

    public boolean acceptsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "acceptsFile"));
        }
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "acceptsDirectory"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "acceptsDirectory"));
        }
        return ProjectFileIndex.SERVICE.getInstance((Project)project2).isInSourceContent(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project2, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) throws IOException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "persistAttribute"));
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "persistAttribute"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "persistAttribute"));
        }
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtil.readINT((DataInput)iStream);
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT((DataOutput)oStream, (int)level.ordinal());
        oStream.close();
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !JavaLanguageLevelPusher.isJavaLike(child.getFileType())) continue;
            PushedFilePropertiesUpdater.getInstance((Project)project2).filePropertiesChanged(child);
        }
    }

    private static boolean isJavaLike(FileType type) {
        return type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    public void afterRootsChanged(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "afterRootsChanged"));
        }
    }

    @Nullable
    public String getInconsistencyLanguageLevelMessage(@NotNull String message, @NotNull PsiElement element, @NotNull LanguageLevel level, @NotNull PsiFile file2) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getInconsistencyLanguageLevelMessage"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getInconsistencyLanguageLevelMessage"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getInconsistencyLanguageLevelMessage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher", "getInconsistencyLanguageLevelMessage"));
        }
        return null;
    }
}

