/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModifiableModelCommitter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModifiableModelCommitter");

    public static void multiCommit(@NotNull ModifiableRootModel[] rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModels", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        ModifiableModelCommitter.multiCommit(Arrays.asList(rootModels), moduleModel);
    }

    public static void multiCommit(@NotNull Collection<ModifiableRootModel> rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModels", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<RootModelImpl> modelsToCommit = ModifiableModelCommitter.getSortedChangedModels(rootModels, moduleModel);
        SmartList modelsToDispose = new SmartList(rootModels);
        modelsToDispose.removeAll(modelsToCommit);
        ModuleManagerImpl.commitModelWithRunnable(moduleModel, () -> ModifiableModelCommitter.lambda$multiCommit$0(modelsToCommit, (List)modelsToDispose));
    }

    @NotNull
    private static List<RootModelImpl> getSortedChangedModels(Collection<ModifiableRootModel> rootModels, ModifiableModuleModel moduleModel) {
        List result2 = null;
        for (ModifiableRootModel model : rootModels) {
            RootModelImpl rootModel = (RootModelImpl)model;
            if (!rootModel.isChanged()) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(rootModel);
        }
        if (result2 == null) {
            List<RootModelImpl> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "getSortedChangedModels"));
            }
            return list;
        }
        if (result2.size() > 1) {
            result2.sort(ModifiableModelCommitter.createDFSTBuilder(result2, moduleModel).comparator());
        }
        List list = result2;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "getSortedChangedModels"));
        }
        return list;
    }

    private static DFSTBuilder<RootModelImpl> createDFSTBuilder(List<RootModelImpl> rootModels, final ModifiableModuleModel moduleModel) {
        Module[] modules;
        final HashMap nameToModel = ContainerUtil.newHashMap();
        for (RootModelImpl rootModelImpl : rootModels) {
            String name = rootModelImpl.getModule().getName();
            LOG.assertTrue(!nameToModel.containsKey(name), (Object)name);
            nameToModel.put(name, rootModelImpl);
        }
        for (Module module2 : modules = moduleModel.getModules()) {
            String name = module2.getName();
            if (nameToModel.containsKey(name)) continue;
            RootModelImpl rootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module2)).getRootModel();
            nameToModel.put(name, rootModel);
        }
        final Collection collection = nameToModel.values();
        InboundSemiGraph<RootModelImpl> graph = new InboundSemiGraph<RootModelImpl>(){

            public Collection<RootModelImpl> getNodes() {
                return collection;
            }

            public Iterator<RootModelImpl> getIn(RootModelImpl rootModel) {
                OrderEnumerator entries = rootModel.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries();
                List namesList = (List)entries.process((RootPolicy)new RootPolicy<List<String>>(){

                    public List<String> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, List<String> strings) {
                        Module module2 = moduleOrderEntry.getModule();
                        if (module2 != null && !module2.isDisposed()) {
                            strings.add(module2.getName());
                        } else {
                            Module moduleToBeRenamed = moduleModel.getModuleToBeRenamed(moduleOrderEntry.getModuleName());
                            if (moduleToBeRenamed != null && !moduleToBeRenamed.isDisposed()) {
                                strings.add(moduleToBeRenamed.getName());
                            }
                        }
                        return strings;
                    }
                }, new ArrayList());
                String[] names = ArrayUtil.toStringArray((Collection)namesList);
                ArrayList<RootModelImpl> result2 = new ArrayList<RootModelImpl>();
                for (String name : names) {
                    RootModelImpl depRootModel = (RootModelImpl)nameToModel.get(name);
                    if (depRootModel == null) continue;
                    result2.add(depRootModel);
                }
                return result2.iterator();
            }
        };
        return new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)graph)));
    }

    private static /* synthetic */ void lambda$multiCommit$0(List modelsToCommit, List modelsToDispose) {
        for (RootModelImpl model : modelsToCommit) {
            ModuleRootManagerImpl.doCommit(model);
        }
        for (RootModelImpl model : modelsToDispose) {
            if (model instanceof RootModelImpl) {
                model.checkModuleExtensionModification();
            }
            model.dispose();
        }
    }
}

