/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkComboBox
extends ComboBoxWithWidePopup<JdkComboBoxItem> {
    private static final Icon EMPTY_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1, (int)16));
    @Nullable
    private final Condition<Sdk> myFilter;
    @Nullable
    private final Condition<SdkTypeId> myCreationFilter;
    private JButton mySetUpButton;
    private Condition<SdkTypeId> mySdkTypeFilter;

    public JdkComboBox(@NotNull ProjectSdksModel jdkModel) {
        if (jdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkModel", "com/intellij/openapi/roots/ui/configuration/JdkComboBox", "<init>"));
        }
        this(jdkModel, null);
    }

    public JdkComboBox(@NotNull ProjectSdksModel jdkModel, @Nullable Condition<SdkTypeId> filter) {
        if (jdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkModel", "com/intellij/openapi/roots/ui/configuration/JdkComboBox", "<init>"));
        }
        this(jdkModel, filter, JdkComboBox.getSdkFilter(filter), filter, false);
    }

    public JdkComboBox(final @NotNull ProjectSdksModel jdkModel, @Nullable Condition<SdkTypeId> sdkTypeFilter, @Nullable Condition<Sdk> filter, @Nullable Condition<SdkTypeId> creationFilter, boolean addSuggestedItems) {
        if (jdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkModel", "com/intellij/openapi/roots/ui/configuration/JdkComboBox", "<init>"));
        }
        super((ComboBoxModel)new JdkComboBoxModel(jdkModel, sdkTypeFilter, filter, addSuggestedItems));
        this.myFilter = filter;
        this.mySdkTypeFilter = sdkTypeFilter;
        this.myCreationFilter = creationFilter;
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdkComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JdkComboBoxItem> list, JdkComboBoxItem value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$1", "customizeCellRenderer"));
                }
                if (JdkComboBox.this.isEnabled()) {
                    this.setIcon(EMPTY_ICON);
                    if (value instanceof InvalidJdkComboBoxItem) {
                        String str = value.toString();
                        this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else if (value instanceof ProjectJdkComboBoxItem) {
                        Sdk jdk2 = jdkModel.getProjectSdk();
                        if (jdk2 != null) {
                            this.setIcon(((SdkType)jdk2.getSdkType()).getIcon());
                            this.append(ProjectBundle.message((String)"project.roots.project.jdk.inherited", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                            this.append(" (" + jdk2.getName() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        } else {
                            String str = value.toString();
                            this.append(str, SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                    } else if (value instanceof SuggestedJdkItem) {
                        SdkType type = ((SuggestedJdkItem)value).getSdkType();
                        String home = ((SuggestedJdkItem)value).getPath();
                        this.setIcon(type.getIconForAddAction());
                        String version = type.getVersionString(home);
                        this.append(version == null ? type.getPresentableName() : version);
                        this.append(" (" + home + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else if (value != null) {
                        OrderEntryAppearanceService.getInstance().forJdk(value.getJdk(), false, selected, true).customize((SimpleColoredComponent)this);
                    } else {
                        this.customizeCellRenderer(list, new NoneJdkComboBoxItem(), index, selected, hasFocus);
                    }
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        Rectangle rec = ScreenUtil.getScreenRectangle((int)0, (int)0);
        Dimension size = super.getPreferredSize();
        int maxWidth = rec.width / 4;
        if (size.width > maxWidth) {
            size.width = maxWidth;
        }
        return size;
    }

    public Dimension getMinimumSize() {
        Dimension minSize = super.getMinimumSize();
        Dimension prefSize = this.getPreferredSize();
        if (minSize.width > prefSize.width) {
            minSize.width = prefSize.width;
        }
        return minSize;
    }

    public void setSetupButton(JButton setUpButton, @Nullable Project project2, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<Sdk> additionalSetup, boolean moduleJdkSetup) {
        this.setSetupButton(setUpButton, project2, jdksModel, firstItem, additionalSetup, ProjectBundle.message((String)"project.roots.set.up.jdk.title", (Object[])new Object[]{moduleJdkSetup ? 1 : 2}));
    }

    public void setSetupButton(final JButton setUpButton, final @Nullable Project project2, final ProjectSdksModel jdksModel, final JdkComboBoxItem firstItem, final @Nullable Condition<Sdk> additionalSetup, final String actionGroupTitle) {
        this.mySetUpButton = setUpButton;
        this.mySetUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultActionGroup group = new DefaultActionGroup();
                jdksModel.createAddActions(group, (JComponent)((Object)JdkComboBox.this), (Consumer<Sdk>)((Consumer)jdk2 -> {
                    if (project2 != null) {
                        JdkListConfigurable configurable = JdkListConfigurable.getInstance(project2);
                        configurable.addJdkNode((Sdk)jdk2, false);
                    }
                    JdkComboBox.this.reloadModel(new ActualJdkComboBoxItem((Sdk)jdk2), project2);
                    JdkComboBox.this.setSelectedJdk((Sdk)jdk2);
                    if (additionalSetup != null && additionalSetup.value(jdk2)) {
                        JdkComboBox.this.setSelectedJdk(firstItem.getJdk());
                    }
                }), (Condition<SdkTypeId>)JdkComboBox.this.myCreationFilter);
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)JdkComboBox.this));
                if (group.getChildrenCount() > 1) {
                    JBPopupFactory.getInstance().createActionGroupPopup(actionGroupTitle, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf((Component)setUpButton);
                } else {
                    AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(""), ActionManager.getInstance(), 0);
                    group.getChildren(event)[0].actionPerformed(event);
                }
            }
        });
    }

    public void setEditButton(final JButton editButton, final Project project2, final Computable<Sdk> retrieveJDK) {
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk projectJdk = (Sdk)retrieveJDK.compute();
                if (projectJdk != null) {
                    ProjectStructureConfigurable.getInstance(project2).select(projectJdk, true);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JdkComboBoxItem selectedItem = JdkComboBox.this.getSelectedItem();
                if (selectedItem instanceof ProjectJdkComboBoxItem) {
                    editButton.setEnabled(ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel().getProjectSdk() != null);
                } else {
                    editButton.setEnabled(!(selectedItem instanceof InvalidJdkComboBoxItem) && selectedItem != null && selectedItem.getJdk() != null);
                }
            }
        });
    }

    public JButton getSetUpButton() {
        return this.mySetUpButton;
    }

    public JdkComboBoxItem getSelectedItem() {
        return (JdkComboBoxItem)super.getSelectedItem();
    }

    @Nullable
    public Sdk getSelectedJdk() {
        JdkComboBoxItem selectedItem = this.getSelectedItem();
        return selectedItem != null ? selectedItem.getJdk() : null;
    }

    public void setSelectedJdk(Sdk jdk2) {
        int index = this.indexOf(jdk2);
        if (index >= 0) {
            this.setSelectedIndex(index);
        }
    }

    public void setInvalidJdk(String name) {
        this.removeInvalidElement();
        this.addItem(new InvalidJdkComboBoxItem(name));
        this.setSelectedIndex(this.getModel().getSize() - 1);
    }

    private int indexOf(Sdk jdk2) {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        int count = model.getSize();
        for (int idx = 0; idx < count; ++idx) {
            Sdk elementAtJdk;
            JdkComboBoxItem elementAt = (JdkComboBoxItem)model.getElementAt(idx);
            if (!(jdk2 == null ? elementAt instanceof NoneJdkComboBoxItem || elementAt instanceof ProjectJdkComboBoxItem : (elementAtJdk = elementAt.getJdk()) != null && jdk2.getName().equals(elementAtJdk.getName()))) continue;
            return idx;
        }
        return -1;
    }

    private void removeInvalidElement() {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        int count = model.getSize();
        for (int idx = 0; idx < count; ++idx) {
            JdkComboBoxItem elementAt = (JdkComboBoxItem)model.getElementAt(idx);
            if (!(elementAt instanceof InvalidJdkComboBoxItem)) continue;
            this.removeItemAt(idx);
            break;
        }
    }

    public void reloadModel(JdkComboBoxItem firstItem, @Nullable Project project2) {
        JdkComboBoxModel model = (JdkComboBoxModel)this.getModel();
        if (project2 == null) {
            model.addElement(firstItem);
            return;
        }
        model.reload(firstItem, ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel(), this.mySdkTypeFilter, this.myFilter, false);
    }

    public static Condition<Sdk> getSdkFilter(@Nullable Condition<SdkTypeId> filter) {
        return filter == null ? Conditions.alwaysTrue() : sdk -> filter.value((Object)sdk.getSdkType());
    }

    public static class SuggestedJdkItem
    extends JdkComboBoxItem {
        private final SdkType mySdkType;
        private final String myPath;

        public SuggestedJdkItem(SdkType sdkType, @NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$SuggestedJdkItem", "<init>"));
            }
            this.mySdkType = sdkType;
            this.myPath = path;
        }

        public SdkType getSdkType() {
            return this.mySdkType;
        }

        public String getPath() {
            return this.myPath;
        }

        public String toString() {
            return this.myPath;
        }
    }

    private static class InvalidJdkComboBoxItem
    extends JdkComboBoxItem {
        private final String mySdkName;

        public InvalidJdkComboBoxItem(String name) {
            this.mySdkName = name;
        }

        @Override
        public String getSdkName() {
            return this.mySdkName;
        }

        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.invalid.item", (Object[])new Object[]{this.mySdkName});
        }
    }

    public static class NoneJdkComboBoxItem
    extends JdkComboBoxItem {
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.none.item", (Object[])new Object[0]);
        }
    }

    public static class ProjectJdkComboBoxItem
    extends JdkComboBoxItem {
        public String toString() {
            return ProjectBundle.message((String)"jdk.combo.box.project.item", (Object[])new Object[0]);
        }
    }

    public static class ActualJdkComboBoxItem
    extends JdkComboBoxItem {
        private final Sdk myJdk;

        public ActualJdkComboBoxItem(@NotNull Sdk jdk2) {
            if (jdk2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$ActualJdkComboBoxItem", "<init>"));
            }
            this.myJdk = jdk2;
        }

        public String toString() {
            return this.myJdk.getName();
        }

        @Override
        @Nullable
        public Sdk getJdk() {
            return this.myJdk;
        }

        @Override
        @Nullable
        public String getSdkName() {
            return this.myJdk.getName();
        }
    }

    public static abstract class JdkComboBoxItem {
        @Nullable
        public Sdk getJdk() {
            return null;
        }

        @Nullable
        public String getSdkName() {
            return null;
        }
    }

    private static class JdkComboBoxModel
    extends DefaultComboBoxModel<JdkComboBoxItem> {
        public JdkComboBoxModel(@NotNull ProjectSdksModel jdksModel, @Nullable Condition<SdkTypeId> sdkTypeFilter, @Nullable Condition<Sdk> sdkFilter, boolean addSuggested) {
            if (jdksModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdksModel", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$JdkComboBoxModel", "<init>"));
            }
            this.reload(null, jdksModel, sdkTypeFilter, sdkFilter, addSuggested);
        }

        void reload(@Nullable JdkComboBoxItem firstItem, @NotNull ProjectSdksModel jdksModel, @Nullable Condition<SdkTypeId> sdkTypeFilter, @Nullable Condition<Sdk> sdkFilter, boolean addSuggested) {
            Sdk[] jdks;
            if (jdksModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdksModel", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$JdkComboBoxModel", "reload"));
            }
            this.removeAllElements();
            if (firstItem != null) {
                this.addElement(firstItem);
            }
            for (Sdk jdk2 : jdks = JdkComboBoxModel.sortSdks(jdksModel.getSdks())) {
                if (sdkFilter != null && !sdkFilter.value((Object)jdk2)) continue;
                this.addElement(new ActualJdkComboBoxItem(jdk2));
            }
            if (addSuggested) {
                this.addSuggestedItems(sdkTypeFilter, jdks);
            }
        }

        @NotNull
        private static Sdk[] sortSdks(@NotNull Sdk[] sdks) {
            if (sdks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdks", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$JdkComboBoxModel", "sortSdks"));
            }
            Sdk[] clone = (Sdk[])sdks.clone();
            Arrays.sort(clone, (sdk1, sdk2) -> {
                SdkType sdkType1 = (SdkType)sdk1.getSdkType();
                SdkType sdkType2 = (SdkType)sdk2.getSdkType();
                if (!sdkType1.getComparator().equals(sdkType2.getComparator())) {
                    return StringUtil.compare((String)sdkType1.getPresentableName(), (String)sdkType2.getPresentableName(), (boolean)true);
                }
                return sdkType1.getComparator().compare(sdk1, sdk2);
            });
            if (clone == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JdkComboBox$JdkComboBoxModel", "sortSdks"));
            }
            return clone;
        }

        protected void addSuggestedItems(@Nullable Condition<SdkTypeId> sdkTypeFilter, Sdk[] jdks) {
            SdkType[] types;
            for (SdkType type : types = SdkType.getAllTypes()) {
                if (sdkTypeFilter != null && (!sdkTypeFilter.value((Object)type) || ContainerUtil.find((Object[])jdks, sdk -> sdk.getSdkType() == type) != null)) continue;
                Collection paths = type.suggestHomePaths();
                for (String path : paths) {
                    if (path == null || !type.isValidSdkHome(path)) continue;
                    this.addElement(new SuggestedJdkItem(type, path));
                }
            }
        }
    }
}

