/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010#\u001a\u0004\u0018\u00010\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010%\u001a\u00020\u000fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "", "node", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "apiVersion", "Lcom/intellij/openapi/util/BuildNumber;", "getApiVersion", "()Lcom/intellij/openapi/util/BuildNumber;", "buttons", "", "Lcom/intellij/openapi/updateSettings/impl/ButtonInfo;", "getButtons", "()Ljava/util/List;", "downloadUrl", "", "getDownloadUrl", "()Ljava/lang/String;", "message", "getMessage", "number", "getNumber", "patches", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "getPatches", "releaseDate", "Ljava/util/Date;", "getReleaseDate", "()Ljava/util/Date;", "target", "Lcom/intellij/openapi/util/BuildRange;", "getTarget", "()Lcom/intellij/openapi/util/BuildRange;", "version", "getVersion", "parseDate", "value", "toString", "platform-impl"})
public final class BuildInfo {
    @NotNull
    private final BuildNumber number;
    @NotNull
    private final BuildNumber apiVersion;
    @NotNull
    private final String version;
    @NotNull
    private final String message;
    @Nullable
    private final Date releaseDate;
    @Nullable
    private final BuildRange target;
    @NotNull
    private final List<ButtonInfo> buttons;
    @NotNull
    private final List<PatchInfo> patches;

    @NotNull
    public final BuildNumber getNumber() {
        return this.number;
    }

    @NotNull
    public final BuildNumber getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final Date getReleaseDate() {
        return this.releaseDate;
    }

    @Nullable
    public final BuildRange getTarget() {
        return this.target;
    }

    @NotNull
    public final List<ButtonInfo> getButtons() {
        return this.buttons;
    }

    @NotNull
    public final List<PatchInfo> getPatches() {
        return this.patches;
    }

    private final Date parseDate(String value) {
        Date date;
        String string = value;
        if (string != null) {
            Date date2;
            String string2 = string;
            String it = string2;
            try {
                date2 = new SimpleDateFormat("yyyyMMdd", Locale.US).parse(it);
            }
            catch (ParseException e) {
                Logger.getInstance(BuildInfo.class).info("Failed to parse build release date " + it);
                date2 = null;
            }
            date = date2;
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public final String getDownloadUrl() {
        Object v0;
        block1: {
            Iterable iterable = this.buttons;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                Object receiver = t;
                if (!((ButtonInfo)receiver).isDownload()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        ButtonInfo buttonInfo = v0;
        return buttonInfo != null ? buttonInfo.getUrl() : null;
    }

    @NotNull
    public String toString() {
        return this.number + "/" + this.version;
    }

    public BuildInfo(@NotNull Element node) {
        Object object;
        Element p1;
        Collection<Object> collection;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Object object2;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        String string2 = node.getAttributeValue("fullNumber");
        if (string2 == null) {
            string2 = node.getAttributeValue("number");
        }
        if (string2 == null) {
            throw (Throwable)new JDOMException("build@number missing");
        }
        BuildNumber buildNumber = BuildNumber.fromString((String)string2);
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"BuildNumber.fromString(n\u2026(\"build@number missing\"))");
        this.number = buildNumber;
        BuildNumber buildNumber2 = BuildNumber.fromString((String)node.getAttributeValue("apiVersion"), (String)this.number.getProductCode());
        if (buildNumber2 == null) {
            buildNumber2 = this.apiVersion = this.number;
        }
        if ((string = node.getAttributeValue("version")) == null) {
            string = this.version = "";
        }
        if ((object2 = node.getChild("message")) == null || (object2 = object2.getValue()) == null) {
            object2 = "";
        }
        this.message = object2;
        this.releaseDate = this.parseDate(node.getAttributeValue("releaseDate"));
        this.target = BuildRange.fromStrings((String)node.getAttributeValue("targetSince"), (String)node.getAttributeValue("targetUntil"));
        Iterable iterable = node.getChildren("button");
        BuildInfo buildInfo = this;
        void var3_4 = $receiver$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Element element = (Element)item$iv$iv;
            collection = destination$iv$iv;
            object = new ButtonInfo(p1);
            collection.add(object);
        }
        collection = (List)destination$iv$iv;
        buildInfo.buttons = collection;
        $receiver$iv = node.getChildren("patch");
        buildInfo = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            p1 = (Element)item$iv$iv;
            collection = destination$iv$iv;
            object = new PatchInfo(p1);
            collection.add(object);
        }
        collection = (List)destination$iv$iv;
        buildInfo.patches = collection;
    }
}

